/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.cluster.replication.sync;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.cluster.replication.ConsistencyLevel;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import com.gigaspaces.lrmi.LRMIInvocationContext;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Field;

@InternalApi
public class SyncReplPolicy
implements Externalizable {
    private static final long serialVersionUID = 2L;
    public static final String DEFAULT_IP_GROUP = "224.0.0.1";
    public static final int DEFAULT_PORT = 28672;
    public static final int DEFAULT_MULTICAST_TTL = 4;
    public static final long DEFAULT_TODO_QUEUE_TIMEOUT = 1500L;
    public static final long DEFAULT_ASYNC_INTERVAL_TO_CHECK = 4500L;
    public static final long DEFAULT_RESPONSE_TIMEOUT = 1950L;
    public static final long DEFAULT_ACK_INTERVAL = 500L;
    public static final long DEFAULT_ASYNC_ONE_WAY_HEARTBEAT_INTERVAL = 1500L;
    public static final int DEFAULT_UNICAST_MIN_WORK_THREADS = 4;
    public static final int DEFAULT_UNICAST_MAX_WORK_THREADS = 16;
    public static final int DEFAULT_MULTICAST_MIN_WORK_THREADS = 4;
    public static final int DEFAULT_MULTICAST_MAX_WORK_THREADS = 16;
    public static final int DEFAULT_MULTIPLE_OPERATION_CHUNK_SIZE = -1;
    public static final boolean DEFAULT_THROTTLE_WHEN_INACTIVE = true;
    public static final int DEFAULT_MAX_THROTTLE_TP_WHEN_INACTIVE = 50000;
    public static final int DEFAULT_MIN_THROTTLE_TP_WHEN_ACTIVE = 1000;
    public static final long DEFAULT_TARGET_CONSUME_TIMEOUT = 10000L;
    public static final ConsistencyLevel DEFAULT_CONSISTENCY_LEVEL = ConsistencyLevel.ANY;
    public String nodeName;
    private long asyncIntervalToCheck = 4500L;
    private long responseTimeout = 1950L;
    private long ackIntervalTime = 500L;
    private String multicastIpGroup = "224.0.0.1";
    private int multicastPort = 28672;
    private int ttl = 4;
    private int unicastMinThreadPoolSize = 4;
    private int unicastMaxThreadPoolSize = 16;
    private int multicastMinThreadPoolSize = 4;
    private int multicastMaxThreadPoolSize = 16;
    private long todoQueueTimeout = 1500L;
    private long asyncOneWayHeartBeatInterval = 1500L;
    private boolean isAdaptiveMulticast = true;
    private boolean isHoldTxnLockUntilSyncReplication = false;
    private int multipleOperChunkSize = -1;
    private boolean throttleWhenInactive = true;
    private int maxThrottleTPWhenInactive = 50000;
    private int minThrottleTPWhenActive = 1000;
    private long targetConsumeTimeout = 10000L;
    private ConsistencyLevel consistencyLevel = DEFAULT_CONSISTENCY_LEVEL;

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.nodeName);
        int flags = 0;
        if (this.responseTimeout == 1950L) {
            flags |= 1;
        }
        if (this.ackIntervalTime == 500L) {
            flags |= 2;
        }
        if (this.multicastIpGroup.equals(DEFAULT_IP_GROUP)) {
            flags |= 4;
        }
        if (this.multicastPort == 28672) {
            flags |= 8;
        }
        if (this.ttl == 4) {
            flags |= 0x10;
        }
        if (this.unicastMinThreadPoolSize == 4) {
            flags |= 0x20;
        }
        if (this.unicastMaxThreadPoolSize == 16) {
            flags |= 0x40;
        }
        if (this.multicastMinThreadPoolSize == 4) {
            flags |= 0x80;
        }
        if (this.multicastMaxThreadPoolSize == 16) {
            flags |= 0x100;
        }
        if (this.todoQueueTimeout == 1500L) {
            flags |= 0x200;
        }
        if (this.asyncOneWayHeartBeatInterval == 1500L) {
            flags |= 0x400;
        }
        if (this.isAdaptiveMulticast) {
            flags |= 0x800;
        }
        if (!this.isHoldTxnLockUntilSyncReplication) {
            flags |= 0x1000;
        }
        if (this.multipleOperChunkSize == -1) {
            flags |= 0x2000;
        }
        if (this.asyncIntervalToCheck == 4500L) {
            flags |= 0x4000;
        }
        if (this.throttleWhenInactive) {
            flags |= 0x8000;
        }
        if (this.maxThrottleTPWhenInactive == 50000) {
            flags |= 0x10000;
        }
        if (this.minThrottleTPWhenActive == 1000) {
            flags |= 0x20000;
        }
        if (this.targetConsumeTimeout == 10000L) {
            flags |= 0x40000;
        }
        if (this.consistencyLevel == DEFAULT_CONSISTENCY_LEVEL) {
            flags |= 0x80000;
        }
        out.writeInt(flags);
        if (this.responseTimeout != 1950L) {
            out.writeLong(this.responseTimeout);
        }
        if (this.ackIntervalTime != 500L) {
            out.writeLong(this.ackIntervalTime);
        }
        if (!this.multicastIpGroup.equals(DEFAULT_IP_GROUP)) {
            out.writeUTF(this.multicastIpGroup);
        }
        if (this.multicastPort != 28672) {
            out.writeInt(this.multicastPort);
        }
        if (this.ttl != 4) {
            out.writeInt(this.ttl);
        }
        if (this.unicastMinThreadPoolSize != 4) {
            out.writeInt(this.unicastMinThreadPoolSize);
        }
        if (this.unicastMaxThreadPoolSize != 16) {
            out.writeInt(this.unicastMaxThreadPoolSize);
        }
        if (this.multicastMinThreadPoolSize != 4) {
            out.writeInt(this.multicastMinThreadPoolSize);
        }
        if (this.multicastMaxThreadPoolSize != 16) {
            out.writeInt(this.multicastMaxThreadPoolSize);
        }
        if (this.todoQueueTimeout != 1500L) {
            out.writeLong(this.todoQueueTimeout);
        }
        if (this.asyncOneWayHeartBeatInterval != 1500L) {
            out.writeLong(this.asyncOneWayHeartBeatInterval);
        }
        if (!this.isAdaptiveMulticast) {
            out.writeBoolean(this.isAdaptiveMulticast);
        }
        if (this.isHoldTxnLockUntilSyncReplication) {
            out.writeBoolean(this.isHoldTxnLockUntilSyncReplication);
        }
        if (this.multipleOperChunkSize != -1) {
            out.writeInt(this.multipleOperChunkSize);
        }
        if (this.asyncIntervalToCheck != 4500L) {
            out.writeLong(this.asyncIntervalToCheck);
        }
        if (!this.throttleWhenInactive) {
            out.writeBoolean(this.throttleWhenInactive);
        }
        if (this.maxThrottleTPWhenInactive != 50000) {
            out.writeInt(this.maxThrottleTPWhenInactive);
        }
        if (this.minThrottleTPWhenActive != 1000) {
            out.writeInt(this.minThrottleTPWhenActive);
        }
        if (this.targetConsumeTimeout != 10000L) {
            out.writeLong(this.targetConsumeTimeout);
        }
        if (LRMIInvocationContext.getEndpointLogicalVersion().greaterOrEquals(PlatformLogicalVersion.v9_5_1) && this.consistencyLevel != DEFAULT_CONSISTENCY_LEVEL) {
            out.writeByte(this.consistencyLevel.getCode());
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.nodeName = (String)in.readObject();
        int flags = in.readInt();
        this.responseTimeout = (flags & 1) == 0 ? in.readLong() : 1950L;
        this.ackIntervalTime = (flags & 2) == 0 ? in.readLong() : 500L;
        this.multicastIpGroup = (flags & 4) == 0 ? in.readUTF() : DEFAULT_IP_GROUP;
        this.multicastPort = (flags & 8) == 0 ? in.readInt() : 28672;
        this.ttl = (flags & 0x10) == 0 ? in.readInt() : 4;
        this.unicastMinThreadPoolSize = (flags & 0x20) == 0 ? in.readInt() : 4;
        this.unicastMaxThreadPoolSize = (flags & 0x40) == 0 ? in.readInt() : 16;
        this.multicastMinThreadPoolSize = (flags & 0x80) == 0 ? in.readInt() : 4;
        this.multicastMaxThreadPoolSize = (flags & 0x100) == 0 ? in.readInt() : 16;
        this.todoQueueTimeout = (flags & 0x200) == 0 ? in.readLong() : 1500L;
        this.asyncOneWayHeartBeatInterval = (flags & 0x400) == 0 ? in.readLong() : 1500L;
        this.isAdaptiveMulticast = (flags & 0x800) == 0 ? in.readBoolean() : true;
        this.isHoldTxnLockUntilSyncReplication = (flags & 0x1000) == 0 ? in.readBoolean() : false;
        this.multipleOperChunkSize = (flags & 0x2000) == 0 ? in.readInt() : -1;
        this.asyncIntervalToCheck = (flags & 0x4000) == 0 ? in.readLong() : 4500L;
        this.throttleWhenInactive = (flags & 0x8000) == 0 ? in.readBoolean() : true;
        this.maxThrottleTPWhenInactive = (flags & 0x10000) == 0 ? in.readInt() : 50000;
        this.minThrottleTPWhenActive = (flags & 0x20000) == 0 ? in.readInt() : 1000;
        this.targetConsumeTimeout = (flags & 0x40000) == 0 ? in.readLong() : 10000L;
        if (LRMIInvocationContext.getEndpointLogicalVersion().greaterOrEquals(PlatformLogicalVersion.v9_5_1)) {
            this.consistencyLevel = (flags & 0x80000) == 0 ? ConsistencyLevel.fromCode(in.readByte()) : DEFAULT_CONSISTENCY_LEVEL;
        }
    }

    public SyncReplPolicy() {
    }

    public SyncReplPolicy(String nodeName) {
        this.nodeName = nodeName;
    }

    public boolean isHoldTxnLockUntilSyncReplication() {
        return this.isHoldTxnLockUntilSyncReplication;
    }

    public void setHoldTxnLockUntilSyncReplication(boolean isHoldTxnLock) {
        this.isHoldTxnLockUntilSyncReplication = isHoldTxnLock;
    }

    public void setAsyncOneWayHeartBeatInterval(long heartBeatIntervalTime) {
        this.asyncOneWayHeartBeatInterval = heartBeatIntervalTime;
    }

    public long getAsyncOneWayHeartBeatInterval() {
        return this.asyncOneWayHeartBeatInterval;
    }

    public long getAsyncIntervalToCheck() {
        return this.asyncIntervalToCheck;
    }

    public String getMulticastIpGroup() {
        return this.multicastIpGroup;
    }

    public int getMulticastPort() {
        return this.multicastPort;
    }

    public int getMulticastTTL() {
        return this.ttl;
    }

    public void setMulticastTTL(int timeToLeave) {
        this.ttl = timeToLeave;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public int getMulticastMaxThreadPoolSize() {
        return this.multicastMaxThreadPoolSize;
    }

    public void setMulticastMaxThreadPoolSize(int multicastMaxThreadPoolSize) {
        this.multicastMaxThreadPoolSize = multicastMaxThreadPoolSize;
    }

    public int getMulticastMinThreadPoolSize() {
        return this.multicastMinThreadPoolSize;
    }

    public void setMulticastMinThreadPoolSize(int multicastMinThreadPoolSize) {
        this.multicastMinThreadPoolSize = multicastMinThreadPoolSize;
    }

    public long getResponseTimeout() {
        return this.responseTimeout;
    }

    public long getTodoQueueTimeout() {
        return this.todoQueueTimeout;
    }

    public void setTodoQueueTimeout(long todoQueueTimeout) {
        this.todoQueueTimeout = todoQueueTimeout;
        this.responseTimeout = todoQueueTimeout + (long)((double)todoQueueTimeout * 0.3);
        this.ackIntervalTime = todoQueueTimeout / 3L;
        this.asyncIntervalToCheck = todoQueueTimeout * 3L;
        this.asyncOneWayHeartBeatInterval = todoQueueTimeout;
    }

    public void setAdaptiveMulticast(boolean isAdaptive) {
        this.isAdaptiveMulticast = isAdaptive;
    }

    public boolean isAdaptiveMulticast() {
        return this.isAdaptiveMulticast;
    }

    public int getUnicastMaxThreadPoolSize() {
        return this.unicastMaxThreadPoolSize;
    }

    public void setUnicastMaxThreadPoolSize(int unicastMaxThreadPoolSize) {
        this.unicastMaxThreadPoolSize = unicastMaxThreadPoolSize;
    }

    public int getUnicastMinThreadPoolSize() {
        return this.unicastMinThreadPoolSize;
    }

    public void setUnicastMinThreadPoolSize(int unicastMinThreadPoolSize) {
        this.unicastMinThreadPoolSize = unicastMinThreadPoolSize;
    }

    public long getAckIntervalTime() {
        return this.ackIntervalTime;
    }

    public void setMulticastIpGroup(String multicastIpGroup) {
        this.multicastIpGroup = multicastIpGroup;
    }

    public void setMulticastPort(int multicastPort) {
        this.multicastPort = multicastPort;
    }

    public void setMultipleOperationChunkSize(int chunkSmultipleOperChunkSizeize) {
        this.multipleOperChunkSize = chunkSmultipleOperChunkSizeize;
    }

    public int getMultipleOperationChunkSize() {
        return this.multipleOperChunkSize;
    }

    public boolean isThrottleWhenInactive() {
        return this.throttleWhenInactive;
    }

    public void setThrottleWhenInactive(boolean throttleWhenInactive) {
        this.throttleWhenInactive = throttleWhenInactive;
    }

    public int getMaxThrottleTPWhenInactive() {
        return this.maxThrottleTPWhenInactive;
    }

    public void setMaxThrottleTPWhenInactive(int maxThrottleTPWhenInactive) {
        this.maxThrottleTPWhenInactive = maxThrottleTPWhenInactive;
    }

    public int getMinThrottleTPWhenActive() {
        return this.minThrottleTPWhenActive;
    }

    public void setMinThrottleTPWhenActive(int minThrottleTPWhenActive) {
        this.minThrottleTPWhenActive = minThrottleTPWhenActive;
    }

    public long getTargetConsumeTimeout() {
        return this.targetConsumeTimeout;
    }

    public void setTargetConsumeTimeout(long targetConsumeTimeout) {
        this.targetConsumeTimeout = targetConsumeTimeout;
    }

    public ConsistencyLevel getConsistencyLevel() {
        return this.consistencyLevel;
    }

    public void setConsistencyLevel(ConsistencyLevel consistencyLevel) {
        this.consistencyLevel = consistencyLevel;
    }

    public String getDump() {
        StringBuilder dumpInfo = new StringBuilder();
        dumpInfo.append("\n------------- SYNC-REPLICATION DUMP [" + this.nodeName + "] ------------------");
        try {
            Field[] fields = this.getClass().getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                dumpInfo.append("\n" + fields[i].getName() + " : " + fields[i].get(this));
            }
        }
        catch (Exception ex) {
            return ex.toString();
        }
        dumpInfo.append("\n------------- SYNC-REPLICATION DUMP [" + this.nodeName + "] ------------------");
        return dumpInfo.toString();
    }

    public String toString() {
        StringBuilder strBuffer = new StringBuilder("\n------------Sync Replication Policy---------\n");
        strBuffer.append("Async Interval To Check -\t" + this.asyncIntervalToCheck + "\n");
        strBuffer.append("Node Name -\t" + this.nodeName + "\n");
        strBuffer.append("Response Timeout -\t" + this.responseTimeout + "\n");
        strBuffer.append("ack Interval Time -\t" + this.ackIntervalTime + "\n");
        strBuffer.append("Multicast IP Group -\t" + this.multicastIpGroup + "\n");
        strBuffer.append("Multicast Port -\t" + this.multicastPort + "\n");
        strBuffer.append("ttl -\t" + this.ttl + "\n");
        strBuffer.append("Unicast Min Thread Pool Size -\t" + this.unicastMinThreadPoolSize + "\n");
        strBuffer.append("Unicast Max Thread Pool Size -\t" + this.unicastMaxThreadPoolSize + "\n");
        strBuffer.append("Multicast Min Thread Pool Size -\t" + this.multicastMinThreadPoolSize + "\n");
        strBuffer.append("Multicast Max Thread Pool Size -\t" + this.multicastMaxThreadPoolSize + "\n");
        strBuffer.append("Todo Queue Timeout -\t" + this.todoQueueTimeout + "\n");
        strBuffer.append("Async One Way Heart Beat Interval -\t" + this.asyncOneWayHeartBeatInterval + "\n");
        strBuffer.append("Is Adaptive Multicast -\t" + this.isAdaptiveMulticast + "\n");
        strBuffer.append("Is Hold Txn Lock Until Sync Replication -\t" + this.isHoldTxnLockUntilSyncReplication + "\n");
        strBuffer.append("Multiple Operations chunk size -\t" + this.multipleOperChunkSize + "\n");
        strBuffer.append("Throttle when inactive -\t" + this.throttleWhenInactive + "\n");
        strBuffer.append("Max Throttle throughput when inactive -\t" + this.maxThrottleTPWhenInactive + "\n");
        strBuffer.append("Min Throttle throughput when active -\t" + this.minThrottleTPWhenActive + "\n");
        strBuffer.append("Target consume timeout -\t" + this.targetConsumeTimeout + "\n");
        strBuffer.append("Consistency Level -\t" + (Object)((Object)this.consistencyLevel) + "\n");
        return strBuffer.toString();
    }

    private static interface DefaultsBitMap {
        public static final int DEFAULT_RESPONSE_TIMEOUT = 1;
        public static final int DEFAULT_ACK_INTERVAL = 2;
        public static final int DEFAULT_IP_GROUP = 4;
        public static final int DEFAULT_PORT = 8;
        public static final int DEFAULT_MULTICAST_TTL = 16;
        public static final int DEFAULT_UNICAST_MIN_WORK_THREADS = 32;
        public static final int DEFAULT_UNICAST_MAX_WORK_THREADS = 64;
        public static final int DEFAULT_MULTICAST_MIN_WORK_THREADS = 128;
        public static final int DEFAULT_MULTICAST_MAX_WORK_THREADS = 256;
        public static final int DEFAULT_TODO_QUEUE_TIMEOUT = 512;
        public static final int DEFAULT_ASYNC_ONE_WAY_HEARTBEAT_INTERVAL = 1024;
        public static final int DEFAULT_ADAPTIVEMULTICAST = 2048;
        public static final int DEFAULT_HOLD_TXN = 4096;
        public static final int DEFAULT_MULTIPLE_OPERATION_CHUNK_SIZE = 8192;
        public static final int DEFAULT_ASYNC_INTERVAL_TO_CHECK = 16384;
        public static final int DEFAULT_THROTTLE_WHEN_INACTIVE = 32768;
        public static final int DEFAULT_MAX_THROTTLE_TP_WHEN_INACTIVE = 65536;
        public static final int DEFAULT_MIN_THROTTLE_TP_WHEN_ACTIVE = 131072;
        public static final int DEFAULT_TARGET_CONSUME_TIMEOUT = 262144;
        public static final int DEFAULT_CONSISTENCY_LEVEL = 524288;
    }
}

