/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.config.lrmi.nio;

import com.gigaspaces.config.lrmi.ITransportConfig;
import com.gigaspaces.lrmi.nio.PAdapter;
import com.gigaspaces.start.SystemInfo;
import com.j_spaces.kernel.TimeUnitProperty;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NIOConfiguration
implements ITransportConfig,
Cloneable,
Externalizable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(NIOConfiguration.class.getName());
    private static final int DEFAULT_MIN_THREADS = 1;
    private static final int DEFAULT_MAX_THREADS = 128;
    private static final int DEFAULT_THREAD_QUEUE_SIZE = Integer.MAX_VALUE;
    private static final int DEFAULT_MAX_CONN_POOL = 1024;
    private static final String DEFAULT_BIND_PORT = "0";
    private static final int DEFAULT_SLOW_CONSUMER_LATENCY = 500;
    private static final int DEFAULT_SLOW_CONSUMER_TP = 5000;
    private static final int DEFAULT_SLOW_CONSUMER_RETRIES = 3;
    private static final int DEFAULT_SLOW_CONSUMER_READ_TIMEOUT = 2000;
    private static final boolean DEFAULT_SLOW_CONSUMER_ENABLED = false;
    private int _minThreads = 1;
    private int _maxThreads = 128;
    private int _threadsQueueSize = Integer.MAX_VALUE;
    private int _maxConnPool = 1024;
    private String _bindPort = "0";
    private String _bindHostName;
    private boolean _blockingConnection = true;
    private int _slowConsumerLatency = 500;
    private int _slowConsumerThroughput = 5000;
    private int _slowConsumerRetries = 3;
    private int _slowConsumerReadTimeout = 2000;
    private int _readSelectorThreads = 4;
    private long _watchdogRequestTimeout = -1L;
    private long _watchdogListeningTimeout = -1L;
    private long _watchdogIdleConnectionTimeout = -1L;
    private static final long WATCHDOG_REQUEST_TIMEOUT_DEFAULT = TimeUnitProperty.getParsedValue("30s");
    private static final long WATCHDOG_LISTENING_TIMEOUT_DEFAULT = TimeUnitProperty.getParsedValue("5m");
    private static final long WATCHDOG_IDLE_CONNECTION_TIMEOUT_DEFAULT = TimeUnitProperty.getParsedValue("15m");
    private static final long LRMI_CONNECT_TIMEOUT_DEFAULT = TimeUnitProperty.getParsedValue("30s");
    private long _threadPoolIdleTimeout = 300000L;
    private long _socketConnectTimeout = -1L;
    private transient int _systemPriorityQueueCapacity = Integer.MAX_VALUE;
    private transient long _systemPriorityThreadIdleTimeout = 60000L;
    private transient int _systemPriorityMinThreads = 1;
    private transient int _systemPriorityMaxThreads = 8;
    private transient int _customQueueCapacity = Integer.MAX_VALUE;
    private transient long _customThreadIdleTimeout = 300000L;
    private transient int _customMinThreads = 1;
    private transient int _customMaxThreads = 128;
    private boolean _protocolValidationEnabled;

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        int flags = this.buildFlags();
        out.writeInt(flags);
        if (this._minThreads != 1) {
            out.writeInt(this._minThreads);
        }
        if (this._maxThreads != 128) {
            out.writeInt(this._maxThreads);
        }
        if (this._threadsQueueSize != Integer.MAX_VALUE) {
            out.writeInt(this._threadsQueueSize);
        }
        if (this._maxConnPool != 1024) {
            out.writeInt(this._maxConnPool);
        }
        if (!DEFAULT_BIND_PORT.equals(this._bindPort)) {
            out.writeUTF(this._bindPort);
        }
        if (this._bindHostName != null) {
            out.writeUTF(this._bindHostName);
        }
        if (this._slowConsumerLatency != 500) {
            out.writeInt(this._slowConsumerLatency);
        }
        if (this._slowConsumerThroughput != 5000) {
            out.writeInt(this._slowConsumerThroughput);
        }
        if (this._slowConsumerRetries != 3) {
            out.writeInt(this._slowConsumerRetries);
        }
        if (this._readSelectorThreads != 4) {
            out.writeInt(this._readSelectorThreads);
        }
        if (this._watchdogRequestTimeout != WATCHDOG_REQUEST_TIMEOUT_DEFAULT) {
            out.writeLong(this._watchdogRequestTimeout);
        }
        if (this._watchdogListeningTimeout != WATCHDOG_LISTENING_TIMEOUT_DEFAULT) {
            out.writeLong(this._watchdogListeningTimeout);
        }
        if (this._watchdogIdleConnectionTimeout != WATCHDOG_IDLE_CONNECTION_TIMEOUT_DEFAULT) {
            out.writeLong(this._watchdogIdleConnectionTimeout);
        }
        if (this._threadPoolIdleTimeout != 300000L) {
            out.writeLong(this._threadPoolIdleTimeout);
        }
        if (this._socketConnectTimeout != LRMI_CONNECT_TIMEOUT_DEFAULT) {
            out.writeLong(this._socketConnectTimeout);
        }
        if (this._slowConsumerReadTimeout != 2000) {
            out.writeInt(this._slowConsumerReadTimeout);
        }
    }

    private int buildFlags() {
        int flags = 0;
        if (this._minThreads != 1) {
            flags |= 1;
        }
        if (this._maxThreads != 128) {
            flags |= 2;
        }
        if (this._threadsQueueSize != Integer.MAX_VALUE) {
            flags |= 4;
        }
        if (this._maxConnPool != 1024) {
            flags |= 8;
        }
        if (!DEFAULT_BIND_PORT.equals(this._bindPort)) {
            flags |= 0x10;
        }
        if (this._bindHostName != null) {
            flags |= 0x20;
        }
        if (this._blockingConnection) {
            flags |= 0x40;
        }
        if (this._slowConsumerLatency != 500) {
            flags |= 0x80;
        }
        if (this._slowConsumerThroughput != 5000) {
            flags |= 0x100;
        }
        if (this._slowConsumerRetries != 3) {
            flags |= 0x200;
        }
        if (this._readSelectorThreads != 4) {
            flags |= 0x400;
        }
        if (this._watchdogRequestTimeout != WATCHDOG_REQUEST_TIMEOUT_DEFAULT) {
            flags |= 0x800;
        }
        if (this._watchdogListeningTimeout != WATCHDOG_LISTENING_TIMEOUT_DEFAULT) {
            flags |= 0x1000;
        }
        if (this._watchdogIdleConnectionTimeout != WATCHDOG_IDLE_CONNECTION_TIMEOUT_DEFAULT) {
            flags |= 0x2000;
        }
        if (this._threadPoolIdleTimeout != 300000L) {
            flags |= 0x4000;
        }
        if (this._socketConnectTimeout != LRMI_CONNECT_TIMEOUT_DEFAULT) {
            flags |= 0x8000;
        }
        if (this._slowConsumerReadTimeout != 2000) {
            flags |= 0x10000;
        }
        if (this._protocolValidationEnabled) {
            flags |= 0x20000;
        }
        return flags;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int flags = in.readInt();
        this._minThreads = (flags & 1) != 0 ? in.readInt() : 1;
        this._maxThreads = (flags & 2) != 0 ? in.readInt() : 128;
        this._threadsQueueSize = (flags & 4) != 0 ? in.readInt() : Integer.MAX_VALUE;
        this._maxConnPool = (flags & 8) != 0 ? in.readInt() : 1024;
        this._bindPort = (flags & 0x10) != 0 ? in.readUTF() : DEFAULT_BIND_PORT;
        if ((flags & 0x20) != 0) {
            this._bindHostName = in.readUTF();
        }
        this._blockingConnection = (flags & 0x40) != 0;
        this._slowConsumerLatency = (flags & 0x80) != 0 ? in.readInt() : 500;
        this._slowConsumerThroughput = (flags & 0x100) != 0 ? in.readInt() : 5000;
        this._slowConsumerRetries = (flags & 0x200) != 0 ? in.readInt() : 3;
        this._readSelectorThreads = (flags & 0x400) != 0 ? in.readInt() : 4;
        this._watchdogRequestTimeout = (flags & 0x800) != 0 ? in.readLong() : WATCHDOG_REQUEST_TIMEOUT_DEFAULT;
        this._watchdogListeningTimeout = (flags & 0x1000) != 0 ? in.readLong() : WATCHDOG_LISTENING_TIMEOUT_DEFAULT;
        this._watchdogIdleConnectionTimeout = (flags & 0x2000) != 0 ? in.readLong() : WATCHDOG_IDLE_CONNECTION_TIMEOUT_DEFAULT;
        this._threadPoolIdleTimeout = (flags & 0x4000) != 0 ? in.readLong() : 300000L;
        this._socketConnectTimeout = (flags & 0x8000) != 0 ? in.readLong() : LRMI_CONNECT_TIMEOUT_DEFAULT;
        this._slowConsumerReadTimeout = (flags & 0x10000) != 0 ? in.readInt() : 2000;
        if ((flags & 0x20000) != 0) {
            this._protocolValidationEnabled = true;
        }
    }

    public static NIOConfiguration create() {
        String bindHost = SystemInfo.singleton().network().getHostId();
        String bindPort = System.getProperty("com.gs.transport_protocol.lrmi.bind-port", DEFAULT_BIND_PORT);
        int minThreads = Integer.parseInt(System.getProperty("com.gs.transport_protocol.lrmi.min-threads", "1"));
        int maxThreads = Integer.parseInt(System.getProperty("com.gs.transport_protocol.lrmi.max-threads", "128"));
        int maxConnPool = Integer.parseInt(System.getProperty("com.gs.transport_protocol.lrmi.max-conn-pool", "1024"));
        int readSelectorThreads = Integer.parseInt(System.getProperty("com.gs.transport_protocol.lrmi.selector.threads", String.valueOf(4)));
        String watchdogRequestTimeout = System.getProperty("com.gs.transport_protocol.lrmi.request_timeout", "30s");
        String watchdogListeningTimeout = System.getProperty("com.gs.transport_protocol.lrmi.listening_timeout", "5m");
        String watchdogIdleConnectionTimeout = System.getProperty("com.gs.transport_protocol.lrmi.idle_connection_timeout", "15m");
        long threadPoolIdleTimeout = Long.parseLong(System.getProperty("com.gs.transport_protocol.lrmi.threadpool.idle_timeout", "300000"));
        int threadPoolQueueSize = Integer.parseInt(System.getProperty("com.gs.transport_protocol.lrmi.threadpool.queue-size", Integer.toString(Integer.MAX_VALUE)));
        String socketConnectTimeout = System.getProperty("com.gs.transport_protocol.lrmi.connect_timeout", "30s");
        String slowConsumerEnabledKey = "com.gs.transport_protocol.lrmi.slow-consumer.enabled";
        boolean slowConsumerEnabled = Boolean.parseBoolean(System.getProperty(slowConsumerEnabledKey, String.valueOf(false)));
        String slowConsumerThroughputKey = "com.gs.transport_protocol.lrmi.slow-consumer.throughput";
        int slowConsumerThroughput = Integer.parseInt(System.getProperty(slowConsumerThroughputKey, slowConsumerEnabled ? String.valueOf(5000) : DEFAULT_BIND_PORT));
        if (slowConsumerEnabled && slowConsumerThroughput == 0) {
            throw new IllegalArgumentException("Contradicting slow consumer configuration: slow consumer is enabled (" + slowConsumerEnabledKey + ") but slow consumer throughput (" + slowConsumerThroughputKey + ") is explicitly set to 0");
        }
        if (!slowConsumerEnabled && slowConsumerThroughput > 0) {
            throw new IllegalArgumentException("Contradicting slow consumer configuration: slow consumer is disabled (" + slowConsumerEnabledKey + ") but slow consumer throughput (" + slowConsumerThroughputKey + ") is explicitly set to " + slowConsumerThroughput + ", this property should not be set when slow consumer is disabled");
        }
        int slowConsumerRetries = Integer.parseInt(System.getProperty("com.gs.transport_protocol.lrmi.slow-consumer.retries", String.valueOf(3)));
        int slowConsumerLatency = Integer.parseInt(System.getProperty("com.gs.transport_protocol.lrmi.slow-consumer.latency", String.valueOf(500)));
        int slowConsumerReadTimeout = Integer.parseInt(System.getProperty("com.gs.transport_protocol.lrmi.slow-consumer.read-timeout", String.valueOf(2000)));
        int systemPriorityQueueCapacity = Integer.parseInt(System.getProperty("com.gs.transport_protocol.lrmi.system-priority.threadpool.queue-size", String.valueOf(Integer.MAX_VALUE)));
        long systemPriorityThreadPoolIdleTimeout = Long.parseLong(System.getProperty("com.gs.transport_protocol.lrmi.system-priority.threadpool.idle_timeout", String.valueOf(60000)));
        int systemPriorityMinThreads = Integer.parseInt(System.getProperty("com.gs.transport_protocol.lrmi.system-priority.threadpool.min-threads", String.valueOf(1)));
        int systemPriorityMaxThreads = Integer.parseInt(System.getProperty("com.gs.transport_protocol.lrmi.system-priority.threadpool.max-threads", String.valueOf(8)));
        int customQueueCapacity = Integer.parseInt(System.getProperty("com.gs.transport_protocol.lrmi.custom.threadpool.queue-size", String.valueOf(Integer.MAX_VALUE)));
        long customThreadPoolIdleTimeout = Long.parseLong(System.getProperty("com.gs.transport_protocol.lrmi.custom.threadpool.idle_timeout", String.valueOf(300000)));
        int customMinThreads = Integer.parseInt(System.getProperty("com.gs.transport_protocol.lrmi.custom.threadpool.min-threads", String.valueOf(1)));
        int customMaxThreads = Integer.parseInt(System.getProperty("com.gs.transport_protocol.lrmi.custom.threadpool.max-threads", String.valueOf(128)));
        boolean protocolValidationEnabled = !Boolean.getBoolean("com.gs.transport_protocol.lrmi.protocol-validation-disabled");
        NIOConfiguration nioConfiguration = new NIOConfiguration(minThreads, maxThreads, maxConnPool, bindHost, bindPort, threadPoolQueueSize, slowConsumerThroughput, slowConsumerLatency, slowConsumerRetries, slowConsumerReadTimeout, readSelectorThreads, watchdogRequestTimeout, watchdogListeningTimeout, watchdogIdleConnectionTimeout, threadPoolIdleTimeout, socketConnectTimeout, systemPriorityQueueCapacity, systemPriorityThreadPoolIdleTimeout, systemPriorityMinThreads, systemPriorityMaxThreads, customQueueCapacity, customThreadPoolIdleTimeout, customMinThreads, customMaxThreads, protocolValidationEnabled);
        if (logger.isLoggable(Level.CONFIG)) {
            logger.config(String.valueOf(nioConfiguration));
        }
        return nioConfiguration;
    }

    private NIOConfiguration(int minThreads, int maxThreads, int maxConnPool, String bindHostName, String bindPort, int threadsQueueSize, int slowConsumerThroughput, int slowConsumerLatency, int slowConsumerRetries, int slowConsumerReadtimeout, int readSelectorThreads, String watchdogRequestTimeout, String watchdogListeningTimeout, String watchdogIdleConnectionTimeout, long threadPoolIdleTimeout, String socketConnectTimeout, int systemPriorityQueueCapacity, long systemPriorityThreadIdleTimeout, int systemPriorityMinThreads, int systemPriorityMaxThreads, int customQueueCapacity, long customThreadIdleTimeout, int customMinThreads, int customMaxThreads, boolean protocolValidationEnabled) {
        this();
        this._minThreads = minThreads;
        this._maxThreads = maxThreads;
        this._maxConnPool = maxConnPool;
        this._bindHostName = bindHostName;
        this._bindPort = bindPort;
        this._threadsQueueSize = threadsQueueSize;
        this._slowConsumerLatency = slowConsumerLatency;
        this._slowConsumerThroughput = slowConsumerThroughput;
        this._slowConsumerRetries = slowConsumerRetries;
        this._slowConsumerReadTimeout = slowConsumerReadtimeout;
        this._readSelectorThreads = readSelectorThreads;
        this._watchdogRequestTimeout = TimeUnitProperty.getParsedValue(watchdogRequestTimeout);
        this._watchdogListeningTimeout = TimeUnitProperty.getParsedValue(watchdogListeningTimeout);
        this._watchdogIdleConnectionTimeout = TimeUnitProperty.getParsedValue(watchdogIdleConnectionTimeout);
        this._threadPoolIdleTimeout = threadPoolIdleTimeout;
        this._socketConnectTimeout = TimeUnitProperty.getParsedValue(socketConnectTimeout);
        this._systemPriorityQueueCapacity = systemPriorityQueueCapacity;
        this._systemPriorityThreadIdleTimeout = systemPriorityThreadIdleTimeout;
        this._systemPriorityMinThreads = systemPriorityMinThreads;
        this._systemPriorityMaxThreads = systemPriorityMaxThreads;
        this._customQueueCapacity = customQueueCapacity;
        this._customThreadIdleTimeout = customThreadIdleTimeout;
        this._customMinThreads = customMinThreads;
        this._customMaxThreads = customMaxThreads;
        this._protocolValidationEnabled = protocolValidationEnabled;
    }

    public NIOConfiguration() {
    }

    @Override
    public ITransportConfig clone() {
        try {
            return (ITransportConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Failed to clone a cloneable class", e);
        }
    }

    @Override
    public String getProtocolAdaptorClass() {
        return PAdapter.class.getName();
    }

    @Override
    public int getMinThreads() {
        return this._minThreads;
    }

    public void setMinThreads(int minThreads) {
        this._minThreads = minThreads;
    }

    @Override
    public int getMaxThreads() {
        return this._maxThreads;
    }

    public void setMaxThreads(int maxThreads) {
        this._maxThreads = maxThreads;
    }

    @Override
    public int getThreadsQueueSize() {
        return this._threadsQueueSize;
    }

    public void setThreadsQueueSize(int threadsQueueSize) {
        this._threadsQueueSize = threadsQueueSize;
    }

    @Override
    public int getConnectionPoolSize() {
        return this._maxConnPool;
    }

    public void setMaxConnPool(int maxConnPool) {
        this._maxConnPool = maxConnPool;
    }

    public void setBindHost(String bindHostName) {
        this._bindHostName = bindHostName;
    }

    public void setBindPort(String bindPort) {
        this._bindPort = bindPort;
    }

    public void setBlockingConnection(boolean blockingConnection) {
        this._blockingConnection = blockingConnection;
    }

    public int getMaxConnPool() {
        return this._maxConnPool;
    }

    public String getBindPort() {
        return this._bindPort;
    }

    public String getBindHostName() {
        return this._bindHostName;
    }

    @Override
    public final String getProtocolName() {
        return "NIO";
    }

    @Override
    public boolean isBlockingConnection() {
        return this._blockingConnection;
    }

    @Override
    public int getSlowConsumerLatency() {
        return this._slowConsumerLatency;
    }

    public void setSlowConsumerLatency(int slowConsumerLatency) {
        this._slowConsumerLatency = slowConsumerLatency;
    }

    @Override
    public int getSlowConsumerRetries() {
        return this._slowConsumerRetries;
    }

    public void setSlowConsumerRetries(int slowConsumerRetries) {
        this._slowConsumerRetries = slowConsumerRetries;
    }

    public int getSlowConsumerReadTimeout() {
        return this._slowConsumerReadTimeout;
    }

    public void setSlowConsumerReadTimeout(int slowConsumerReadTimeout) {
        this._slowConsumerReadTimeout = slowConsumerReadTimeout;
    }

    @Override
    public int getSlowConsumerThroughput() {
        return this._slowConsumerThroughput;
    }

    public void setSlowConsumerThroughput(int slowConsumerThroughput) {
        this._slowConsumerThroughput = slowConsumerThroughput;
    }

    @Override
    public int getReadSelectorThreads() {
        return this._readSelectorThreads;
    }

    @Override
    public int getSystemPriorityQueueCapacity() {
        return this._systemPriorityQueueCapacity;
    }

    @Override
    public long getSystemPriorityThreadIdleTimeout() {
        return this._systemPriorityThreadIdleTimeout;
    }

    public int getSystemPriorityMinThreads() {
        return this._systemPriorityMinThreads;
    }

    public int getSystemPriorityMaxThreads() {
        return this._systemPriorityMaxThreads;
    }

    public int getCustomQueueCapacity() {
        return this._customQueueCapacity;
    }

    public long getCustomThreadIdleTimeout() {
        return this._customThreadIdleTimeout;
    }

    public int getCustomMinThreads() {
        return this._customMinThreads;
    }

    public int getCustomMaxThreads() {
        return this._customMaxThreads;
    }

    @Override
    public long getWatchdogRequestTimeout() {
        return this._watchdogRequestTimeout;
    }

    @Override
    public long getWatchdogListeningTimeout() {
        return this._watchdogListeningTimeout;
    }

    @Override
    public long getWatchdogIdleConnectionTimeout() {
        return this._watchdogIdleConnectionTimeout;
    }

    @Override
    public long getThreadPoolIdleTimeout() {
        return this._threadPoolIdleTimeout;
    }

    @Override
    public long getSocketConnectTimeout() {
        return this._socketConnectTimeout;
    }

    public boolean isProtocolValidationEnabled() {
        return this._protocolValidationEnabled;
    }

    public String toString() {
        String bindHostNameStr = this._bindHostName != null ? this._bindHostName : "*Undefined* - resolves to the localhost IP address or '-Djava.rmi.server.hostname' system property if exists";
        StringBuilder sb = new StringBuilder("NIOConfiguration{");
        sb.append("_minThreads=").append(this._minThreads);
        sb.append(", _maxThreads=").append(this._maxThreads);
        sb.append(", _threadsQueueSize=").append(this._threadsQueueSize);
        sb.append(", _maxConnPool=").append(this._maxConnPool);
        sb.append(", _bindPort='").append(this._bindPort).append('\'');
        sb.append(", _bindHostName='").append(bindHostNameStr).append('\'');
        sb.append(", _blockingConnection=").append(this._blockingConnection);
        sb.append(", _slowConsumerLatency=").append(this._slowConsumerLatency);
        sb.append(", _slowConsumerThroughput=").append(this._slowConsumerThroughput);
        sb.append(", _slowConsumerRetries=").append(this._slowConsumerRetries);
        sb.append(", _slowConsumerReadTimeout=").append(this._slowConsumerReadTimeout);
        sb.append(", _readSelectorThreads=").append(this._readSelectorThreads);
        sb.append(", _watchdogRequestTimeout=").append(this._watchdogRequestTimeout);
        sb.append(", _watchdogListeningTimeout=").append(this._watchdogListeningTimeout);
        sb.append(", _watchdogIdleConnectionTimeout=").append(this._watchdogIdleConnectionTimeout);
        sb.append(", _threadPoolIdleTimeout=").append(this._threadPoolIdleTimeout);
        sb.append(", _socketConnectTimeout=").append(this._socketConnectTimeout);
        sb.append(", _systemPriorityQueueCapacity=").append(this._systemPriorityQueueCapacity);
        sb.append(", _systemPriorityThreadIdleTimeout=").append(this._systemPriorityThreadIdleTimeout);
        sb.append(", _systemPriorityMinThreads=").append(this._systemPriorityMinThreads);
        sb.append(", _systemPriorityMaxThreads=").append(this._systemPriorityMaxThreads);
        sb.append(", _customQueueCapacity=").append(this._customQueueCapacity);
        sb.append(", _customThreadIdleTimeout=").append(this._customThreadIdleTimeout);
        sb.append(", _customMinThreads=").append(this._customMinThreads);
        sb.append(", _customMaxThreads=").append(this._customMaxThreads);
        sb.append(", _protocolValidationEnabled=").append(this._protocolValidationEnabled);
        sb.append('}');
        return sb.toString();
    }

    private static interface BitMap {
        public static final int MIN_THREADS = 1;
        public static final int MAX_THREADS = 2;
        public static final int THREAD_QUEUE_SIZE = 4;
        public static final int MAX_CONN_POOL = 8;
        public static final int BIND_PORT = 16;
        public static final int BIND_HOST_NAME = 32;
        public static final int BLOCKING_CONNECTION = 64;
        public static final int SLOW_CONSUMER_LATENCY = 128;
        public static final int SLOW_CONSUMER_TP = 256;
        public static final int SLOW_CONSUMER_RETRIES = 512;
        public static final int READ_SELECTOT_THREADS = 1024;
        public static final int WATCHDOG_REQUEST_TIMEOUT = 2048;
        public static final int WATCHDOG_LISTENING_TIMEOUT = 4096;
        public static final int WATCHDOG_IDLE_CONNECTION_TIMEOUT = 8192;
        public static final int THREAD_POOL_IDLE_TIMEOUT = 16384;
        public static final int SOCKET_CONNECT_TIMEOUT = 32768;
        public static final int SLOW_CONSUMER_READ_TIMEOUT = 65536;
        public static final int PROTOCOL_VALIDATION_ENABLED = 131072;
    }
}

