/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.datasource;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.datasource.DataSourceIdQuery;
import com.gigaspaces.datasource.DataSourceQuery;
import com.gigaspaces.datasource.DataSourceSQLQuery;
import com.gigaspaces.datasource.SQLQueryToDataSourceSQLQueryAdapter;
import com.gigaspaces.document.SpaceDocument;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.gigaspaces.metadata.SpaceTypeDescriptor;
import com.j_spaces.core.client.SQLQuery;
import com.j_spaces.sadapter.datasource.EntryAdapter;
import com.j_spaces.sadapter.datasource.SQLQueryBuilder;

@InternalApi
public class DataSourceIdQueryImpl
implements DataSourceIdQuery,
DataSourceQuery {
    private final ITypeDesc _typeDescriptor;
    private final SQLQueryBuilder _queryBuilder;
    private final EntryAdapter _entryAdapter;
    private final IEntryPacket _entryPacket;

    public DataSourceIdQueryImpl(ITypeDesc typeDescriptor, IEntryPacket entryPacket, SQLQueryBuilder queryBuilder, Class<?> dataClass, EntryAdapter entryAdapter) {
        this._typeDescriptor = typeDescriptor;
        this._entryPacket = entryPacket;
        this._queryBuilder = queryBuilder;
        this._entryAdapter = entryAdapter;
    }

    @Override
    public SpaceTypeDescriptor getTypeDescriptor() {
        return this._typeDescriptor;
    }

    @Override
    public Object getId() {
        return this._entryPacket.getID();
    }

    @Override
    public int getVersion() {
        return this._entryPacket.getVersion();
    }

    public String toString() {
        return "DataSourceIdQuery [id=" + this.getId() + ", typeName=" + this._typeDescriptor.getTypeName() + ", version=" + this.getVersion() + "]";
    }

    @Override
    public DataSourceSQLQuery getAsSQLQuery() {
        if (!this.supportsAsSQLQuery()) {
            throw new UnsupportedOperationException();
        }
        SQLQuery<?> sqlQuery = this._queryBuilder.build(this._entryPacket, this._typeDescriptor);
        return new SQLQueryToDataSourceSQLQueryAdapter(sqlQuery);
    }

    @Override
    public Object getTemplateAsObject() {
        if (!this.supportsTemplateAsObject()) {
            throw new UnsupportedOperationException();
        }
        return this._entryAdapter.toObject();
    }

    @Override
    public SpaceDocument getTemplateAsDocument() {
        if (!this.supportsTemplateAsDocument()) {
            throw new UnsupportedOperationException();
        }
        return this._entryAdapter.toDocument();
    }

    @Override
    public boolean supportsAsSQLQuery() {
        return true;
    }

    @Override
    public boolean supportsTemplateAsObject() {
        return this._typeDescriptor.getIdentifierPropertyId() != -1;
    }

    @Override
    public boolean supportsTemplateAsDocument() {
        return this.supportsTemplateAsObject();
    }

    @Override
    public int getBatchSize() {
        return 1;
    }
}

