/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.datasource;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.datasource.DataSourceIdQuery;
import com.gigaspaces.datasource.DataSourceIdQueryImpl;
import com.gigaspaces.datasource.DataSourceSQLQuery;
import com.gigaspaces.datasource.InternalDataSourceIdsQuery;
import com.gigaspaces.datasource.SQLQueryToDataSourceSQLQueryAdapter;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.server.storage.IEntryHolder;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.gigaspaces.metadata.SpaceTypeDescriptor;
import com.j_spaces.core.client.SQLQuery;
import com.j_spaces.jdbc.builder.range.InRange;
import com.j_spaces.sadapter.datasource.EntryAdapter;
import com.j_spaces.sadapter.datasource.IDataConverter;
import com.j_spaces.sadapter.datasource.SQLQueryBuilder;
import java.util.Arrays;
import java.util.LinkedHashSet;

@InternalApi
public class DataSourceIdsQueryImpl
implements InternalDataSourceIdsQuery {
    private final ITypeDesc _typeDescriptor;
    private final Object[] _ids;
    private final SQLQueryBuilder _queryBuilder;
    private final Class<?> _dataClass;
    private final IDataConverter<IEntryPacket> _converter;
    private final IEntryHolder[] _templates;

    public DataSourceIdsQueryImpl(ITypeDesc typeDescriptor, Object[] ids, IEntryHolder[] templates, SQLQueryBuilder queryBuilder, Class<?> dataClass, IDataConverter<IEntryPacket> converter) {
        this._typeDescriptor = typeDescriptor;
        this._ids = ids;
        this._templates = templates;
        this._queryBuilder = queryBuilder;
        this._dataClass = dataClass;
        this._converter = converter;
    }

    @Override
    public SpaceTypeDescriptor getTypeDescriptor() {
        return this._typeDescriptor;
    }

    @Override
    public Object[] getIds() {
        return this._ids;
    }

    @Override
    public DataSourceIdQuery getDataSourceIdQuery(int idIndex) {
        if (idIndex < 0 || idIndex >= this._ids.length) {
            throw new IllegalArgumentException("Index must match ids array. got=" + idIndex + " while ids array length=" + this._ids.length);
        }
        IEntryHolder template = this._templates[idIndex];
        EntryAdapter entryAdapter = new EntryAdapter(template, this._typeDescriptor, this._converter);
        return new DataSourceIdQueryImpl(this._typeDescriptor, entryAdapter.toEntryPacket(), this._queryBuilder, this._dataClass, entryAdapter);
    }

    @Override
    public boolean supportsAsSQLQuery() {
        return this._typeDescriptor.getIdPropertyName() != null;
    }

    @Override
    public DataSourceSQLQuery getAsSQLQuery() {
        if (!this.supportsAsSQLQuery()) {
            throw new UnsupportedOperationException();
        }
        InRange query = new InRange(this._typeDescriptor.getIdPropertyName(), new LinkedHashSet<Object>(Arrays.asList(this._ids)));
        SQLQuery sqlQuery = query.toSQLQuery(this._typeDescriptor);
        return new SQLQueryToDataSourceSQLQueryAdapter(sqlQuery);
    }
}

