/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.datasource;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.datasource.DataSourceQuery;
import com.gigaspaces.datasource.DataSourceSQLQuery;
import com.gigaspaces.datasource.SQLQueryToDataSourceSQLQueryAdapter;
import com.gigaspaces.document.SpaceDocument;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.server.storage.ITemplateHolder;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.gigaspaces.metadata.SpaceTypeDescriptor;
import com.j_spaces.core.IGSEntry;
import com.j_spaces.core.client.SQLQuery;
import com.j_spaces.sadapter.datasource.EntryAdapter;
import com.j_spaces.sadapter.datasource.SQLQueryBuilder;

@InternalApi
public class DataSourceQueryImpl
implements DataSourceQuery {
    private final ITemplateHolder _template;
    private final Class<?> _dataClass;
    private final SQLQueryBuilder _queryBuilder;
    private final EntryAdapter _entryAdapter;
    private final int _batchSize;
    private final ITypeDesc _typeDescriptor;
    private SQLQuery<?> _sqlQuery;

    public DataSourceQueryImpl(ITemplateHolder template, ITypeDesc typeDescriptor, Class<?> dataClass, SQLQueryBuilder queryBuilder, EntryAdapter entryAdapter, int batchSize) {
        this._template = template;
        this._typeDescriptor = typeDescriptor;
        this._dataClass = dataClass;
        this._queryBuilder = queryBuilder;
        this._entryAdapter = entryAdapter;
        this._batchSize = batchSize;
    }

    @Override
    public DataSourceSQLQuery getAsSQLQuery() {
        if (!this.supportsAsSQLQuery()) {
            throw new UnsupportedOperationException();
        }
        if (this._sqlQuery == null) {
            this._sqlQuery = this._queryBuilder.build(this._template, this._typeDescriptor.getTypeName(), this._typeDescriptor);
        }
        return new SQLQueryToDataSourceSQLQueryAdapter(this._sqlQuery);
    }

    @Override
    public Object getTemplateAsObject() {
        if (!this.supportsTemplateAsObject()) {
            throw new UnsupportedOperationException();
        }
        return this._entryAdapter.toObject();
    }

    @Override
    public SpaceDocument getTemplateAsDocument() {
        if (!this.supportsTemplateAsDocument()) {
            throw new UnsupportedOperationException();
        }
        return this._entryAdapter.toDocument(this._typeDescriptor.getTypeName());
    }

    @Override
    public boolean supportsAsSQLQuery() {
        return true;
    }

    @Override
    public boolean supportsTemplateAsObject() {
        if (IEntryPacket.class.isAssignableFrom(this._dataClass)) {
            return true;
        }
        if (this._template.getCustomQuery() != null) {
            return false;
        }
        if (IGSEntry.class.isAssignableFrom(this._dataClass)) {
            return true;
        }
        if (this._template.hasExtendedMatchCodes()) {
            return false;
        }
        return this._typeDescriptor.getTypeName().equals(this._template.getClassName()) && this._typeDescriptor.isConcreteType();
    }

    @Override
    public boolean supportsTemplateAsDocument() {
        if (IEntryPacket.class.isAssignableFrom(this._dataClass)) {
            return true;
        }
        if (this._template.getCustomQuery() != null) {
            return false;
        }
        if (IGSEntry.class.isAssignableFrom(this._dataClass)) {
            return true;
        }
        if (this._template.hasExtendedMatchCodes()) {
            return false;
        }
        return this._template.getClassName() != null;
    }

    @Override
    public int getBatchSize() {
        return this._batchSize;
    }

    @Override
    public SpaceTypeDescriptor getTypeDescriptor() {
        return this._typeDescriptor;
    }

    public String toString() {
        return "DataSourceQuery [typeName = " + this._typeDescriptor.getTypeName() + ", supportsTemplateAsObject=" + this.supportsTemplateAsObject() + ", supportsTemplateAsDocument=" + this.supportsTemplateAsDocument() + ", supportsTemplateAsSqlQuery=" + this.supportsAsSQLQuery() + ", batchSize=" + this._batchSize + "]";
    }
}

