/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.datasource.concurrentaccess;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.datasource.DataIterator;
import com.gigaspaces.datasource.DataSourceException;
import com.gigaspaces.datasource.concurrentaccess.ISharedDataIteratorSourceStateChangedListener;
import com.gigaspaces.datasource.concurrentaccess.ISourceDataIteratorProvider;
import com.gigaspaces.datasource.concurrentaccess.SharedDataIterator;
import com.gigaspaces.datasource.concurrentaccess.SharedDataIteratorSourceClosedException;
import com.gigaspaces.datasource.concurrentaccess.SharedDataIteratorSourceExpiredException;
import com.gigaspaces.time.SystemTime;
import java.util.ArrayList;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class SharedDataIteratorSource<T> {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.persistent.shared_iterator");
    private boolean _initialized = false;
    private DataIterator<T> _sourceDataIterator;
    private final long _createdTime;
    private final ReadWriteLock _sharedObjectListLock = new ReentrantReadWriteLock(false);
    private final ArrayList<T> _accumulatedItems = new ArrayList();
    private final long _timeToLive;
    private int _numberOfConsumers = 0;
    private boolean _sourceIteratorExhausted;
    private boolean _closed;
    private boolean _expired;
    private ISharedDataIteratorSourceStateChangedListener<T> _listener;
    private final Object _identifier;
    private final ISourceDataIteratorProvider<T> _sourceDataIteratorProvider;

    public SharedDataIteratorSource(Object identifier, ISourceDataIteratorProvider<T> sourceDataIteratorProvider, long timeToLive) {
        if (sourceDataIteratorProvider == null) {
            throw new IllegalArgumentException("sourceDataIteratorProvider cannot be null");
        }
        this._identifier = identifier;
        this._sourceDataIteratorProvider = sourceDataIteratorProvider;
        this._timeToLive = timeToLive;
        this._createdTime = SystemTime.timeMillis();
    }

    public DataIterator<T> getIterator() throws SharedDataIteratorSourceClosedException, SharedDataIteratorSourceExpiredException, DataSourceException {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("requesting a shared iterator from the shared iterator source [" + this._identifier + "]");
        }
        this._sharedObjectListLock.writeLock().lock();
        try {
            this.checkIfSourceIsValid();
            if (!this._initialized) {
                this._sourceDataIterator = this._sourceDataIteratorProvider.getSourceIterator();
                this._initialized = true;
            }
            ++this._numberOfConsumers;
            SharedDataIterator sharedDataIterator = new SharedDataIterator(this);
            return sharedDataIterator;
        }
        finally {
            this._sharedObjectListLock.writeLock().unlock();
        }
    }

    private void checkIfSourceIsValid() throws SharedDataIteratorSourceExpiredException, SharedDataIteratorSourceClosedException {
        if (SystemTime.timeMillis() - this._createdTime > this._timeToLive) {
            if (!this._expired) {
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.finest("shared iterator source is expired [" + this._identifier + "]");
                }
                this.triggerExpiredEvent();
                this._expired = true;
            }
            throw new SharedDataIteratorSourceExpiredException();
        }
        if (this._closed) {
            throw new SharedDataIteratorSourceClosedException();
        }
    }

    private void triggerExpiredEvent() {
        if (this._listener != null) {
            this._listener.onExpired(this);
        }
    }

    public void closeSharedIterator() {
        block10: {
            this._sharedObjectListLock.writeLock().lock();
            try {
                --this._numberOfConsumers;
                if (this._closed) {
                    return;
                }
                if (!this._sourceIteratorExhausted && this._numberOfConsumers != 0) break block10;
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.finest("closed shared iterator source [" + this._identifier + "]");
                }
                this.triggerClosedEvent();
                if (this._sourceDataIterator != null) {
                    this._sharedObjectListLock.writeLock().lock();
                    try {
                        this._sourceDataIterator.close();
                    }
                    finally {
                        this._sharedObjectListLock.writeLock().unlock();
                    }
                }
                this._closed = true;
            }
            finally {
                this._sharedObjectListLock.writeLock().unlock();
            }
        }
    }

    private void triggerClosedEvent() {
        if (this._listener != null) {
            this._listener.onClosed(this);
        }
    }

    private void sourceIteratorExhaushted() {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("shared iterator source wrapped iterator is exhausted [" + this._identifier + "]");
        }
        this._sourceIteratorExhausted = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean waitForNext(int iteration) {
        try {
            this._sharedObjectListLock.readLock().lock();
            if (this._accumulatedItems.size() > iteration) {
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.finest("getting next item from the shared iterator source buffer [" + this._identifier + "]");
                }
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this._sharedObjectListLock.readLock().unlock();
        }
        try {
            this._sharedObjectListLock.writeLock().lock();
            if (this._accumulatedItems.size() > iteration) {
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.finest("getting next item from the shared iterator source buffer [" + this._identifier + "]");
                }
                boolean bl = true;
                return bl;
            }
            if (this._closed) {
                boolean bl = false;
                return bl;
            }
            if (this._sourceDataIterator == null || !this._sourceDataIterator.hasNext()) {
                this.sourceIteratorExhaushted();
                boolean bl = false;
                return bl;
            }
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("getting next item from the shared iterator source wrapped iterator [" + this._identifier + "]");
            }
            Object next = this._sourceDataIterator.next();
            this._accumulatedItems.add(next);
            boolean bl = true;
            return bl;
        }
        finally {
            this._sharedObjectListLock.writeLock().unlock();
        }
    }

    public T getNext(int index) {
        this._sharedObjectListLock.readLock().lock();
        try {
            T t = this._accumulatedItems.get(index);
            return t;
        }
        finally {
            this._sharedObjectListLock.readLock().unlock();
        }
    }

    public void addStateChangedListener(ISharedDataIteratorSourceStateChangedListener<T> listener) {
        this._sharedObjectListLock.writeLock().lock();
        try {
            this._listener = listener;
        }
        finally {
            this._sharedObjectListLock.writeLock().unlock();
        }
    }
}

