/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.datasource.concurrentaccess;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.datasource.DataIterator;
import com.gigaspaces.datasource.DataSourceException;
import com.gigaspaces.datasource.SQLDataProvider;
import com.gigaspaces.datasource.concurrentaccess.ISharedDataIteratorSourceStateChangedListener;
import com.gigaspaces.datasource.concurrentaccess.ISourceDataIteratorProvider;
import com.gigaspaces.datasource.concurrentaccess.SharedDataIteratorSource;
import com.gigaspaces.datasource.concurrentaccess.SharedDataIteratorSourceClosedException;
import com.gigaspaces.datasource.concurrentaccess.SharedDataIteratorSourceExpiredException;
import com.j_spaces.core.client.SQLQuery;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class SharedIteratorSQLDataProviderDecorator<T>
implements SQLDataProvider<T>,
ISharedDataIteratorSourceStateChangedListener<T> {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.persistent.shared_iterator");
    private final SQLDataProvider<T> _sqlDataProvider;
    private final ConcurrentHashMap<SQLQuery<T>, SharedDataIteratorSource<T>> _queryToSources;
    private final ConcurrentHashMap<SharedDataIteratorSource<T>, SQLQuery<T>> _sourcesToQuery;
    private final long _timeToLive;

    public SharedIteratorSQLDataProviderDecorator(SQLDataProvider<T> sqlDataProvider, long timeToLive) {
        this._sqlDataProvider = sqlDataProvider;
        this._timeToLive = timeToLive;
        this._queryToSources = new ConcurrentHashMap();
        this._sourcesToQuery = new ConcurrentHashMap();
    }

    @Override
    public DataIterator<T> iterator(SQLQuery<T> query) throws DataSourceException {
        SharedDataIteratorSource<T> sharedDataIteratorSource = this._queryToSources.get(query);
        if (sharedDataIteratorSource == null) {
            sharedDataIteratorSource = this.createSource(query);
        }
        while (true) {
            try {
                return sharedDataIteratorSource.getIterator();
            }
            catch (SharedDataIteratorSourceClosedException e) {
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.finest("shared iterator source is already closed, creating a new one");
                }
                sharedDataIteratorSource = this.createSource(query);
                continue;
            }
            catch (SharedDataIteratorSourceExpiredException e) {
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.finest("shared iterator source is already expired, creating a new one");
                }
                sharedDataIteratorSource = this.createSource(query);
                continue;
            }
            break;
        }
    }

    @Override
    public void init(Properties prop) throws DataSourceException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("init shared iterator SQL data provider decorator");
        }
        this._sqlDataProvider.init(prop);
    }

    @Override
    public DataIterator<T> initialLoad() throws DataSourceException {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("initialLoad called on shared iterator SQL data provider decorator");
        }
        return this._sqlDataProvider.initialLoad();
    }

    @Override
    public void shutdown() throws DataSourceException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("shutdown shared iterator SQL data provider decorator");
        }
        this._queryToSources.clear();
        this._sourcesToQuery.clear();
        this._sqlDataProvider.shutdown();
    }

    private SharedDataIteratorSource<T> createSource(final SQLQuery<T> query) throws DataSourceException {
        SharedDataIteratorSource sharedDataIteratorSource = new SharedDataIteratorSource(query, new ISourceDataIteratorProvider<T>(){

            @Override
            public DataIterator<T> getSourceIterator() throws DataSourceException {
                return SharedIteratorSQLDataProviderDecorator.this._sqlDataProvider.iterator(query);
            }
        }, this._timeToLive);
        sharedDataIteratorSource.addStateChangedListener(this);
        SharedDataIteratorSource previousMediator = this._queryToSources.putIfAbsent(query, sharedDataIteratorSource);
        if (previousMediator != null) {
            sharedDataIteratorSource = previousMediator;
        } else {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("create new shared iterator source for query " + query.toString());
            }
            this._sourcesToQuery.put(sharedDataIteratorSource, query);
        }
        return sharedDataIteratorSource;
    }

    @Override
    public void onClosed(SharedDataIteratorSource<T> sender) {
        this.handleSourceStateChangedEvent(sender);
    }

    @Override
    public void onExpired(SharedDataIteratorSource<T> sender) {
        this.handleSourceStateChangedEvent(sender);
    }

    private void handleSourceStateChangedEvent(SharedDataIteratorSource<T> sender) {
        SQLQuery<T> query = this._sourcesToQuery.remove(sender);
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("shared iterator source is closed or expired, detaching from local table [" + query.toString() + "]");
        }
        if (query != null) {
            this._queryToSources.remove(query);
        }
    }
}

