/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.datasource.concurrentaccess;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.datasource.DataIterator;
import com.gigaspaces.datasource.DataSourceException;
import com.gigaspaces.datasource.DataSourceIdQuery;
import com.gigaspaces.datasource.DataSourceIdsQuery;
import com.gigaspaces.datasource.DataSourceQuery;
import com.gigaspaces.datasource.DataSourceSQLQuery;
import com.gigaspaces.datasource.SpaceDataSource;
import com.gigaspaces.datasource.SpaceDataSourceException;
import com.gigaspaces.datasource.concurrentaccess.ISharedDataIteratorSourceStateChangedListener;
import com.gigaspaces.datasource.concurrentaccess.ISourceDataIteratorProvider;
import com.gigaspaces.datasource.concurrentaccess.SharedDataIteratorSource;
import com.gigaspaces.datasource.concurrentaccess.SharedDataIteratorSourceClosedException;
import com.gigaspaces.datasource.concurrentaccess.SharedDataIteratorSourceExpiredException;
import com.gigaspaces.metadata.SpaceTypeDescriptor;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class SharedIteratorSpaceDataSourceDecorator
extends SpaceDataSource
implements ISharedDataIteratorSourceStateChangedListener<Object> {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.persistent.shared_iterator");
    private final ConcurrentHashMap<DataSourceSQLQuery, SharedDataIteratorSource<Object>> _queryToSources;
    private final ConcurrentHashMap<SharedDataIteratorSource<Object>, DataSourceSQLQuery> _sourcesToQuery;
    private final long _timeToLive;
    private final SpaceDataSource _spaceDataSource;

    public SharedIteratorSpaceDataSourceDecorator(SpaceDataSource spaceDataSource, long timeToLive) {
        this._spaceDataSource = spaceDataSource;
        this._timeToLive = timeToLive;
        this._queryToSources = new ConcurrentHashMap();
        this._sourcesToQuery = new ConcurrentHashMap();
    }

    @Override
    public DataIterator<Object> getDataIterator(DataSourceQuery query) {
        try {
            if (!query.supportsAsSQLQuery()) {
                return this._spaceDataSource.getDataIterator(query);
            }
            DataSourceSQLQuery dataSourceSQLQuery = query.getAsSQLQuery();
            SharedDataIteratorSource<Object> sharedDataIteratorSource = this._queryToSources.get(dataSourceSQLQuery);
            if (sharedDataIteratorSource == null) {
                sharedDataIteratorSource = this.createSource(query, dataSourceSQLQuery);
            }
            while (true) {
                try {
                    return sharedDataIteratorSource.getIterator();
                }
                catch (SharedDataIteratorSourceClosedException e) {
                    if (_logger.isLoggable(Level.FINEST)) {
                        _logger.finest("shared iterator source is already closed, creating a new one");
                    }
                    sharedDataIteratorSource = this.createSource(query, dataSourceSQLQuery);
                    continue;
                }
                catch (SharedDataIteratorSourceExpiredException e) {
                    if (_logger.isLoggable(Level.FINEST)) {
                        _logger.finest("shared iterator source is already expired, creating a new one");
                    }
                    sharedDataIteratorSource = this.createSource(query, dataSourceSQLQuery);
                    continue;
                }
                break;
            }
        }
        catch (DataSourceException e) {
            throw new SpaceDataSourceException(e);
        }
    }

    public void shutdown() throws DataSourceException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("shutdown shared iterator SQL data provider decorator");
        }
        this._queryToSources.clear();
        this._sourcesToQuery.clear();
    }

    private SharedDataIteratorSource<Object> createSource(final DataSourceQuery dataSourceQuery, DataSourceSQLQuery dataSourceSQLQuery) throws DataSourceException {
        SharedDataIteratorSource<Object> sharedDataIteratorSource = new SharedDataIteratorSource<Object>(dataSourceSQLQuery, new ISourceDataIteratorProvider<Object>(){

            @Override
            public DataIterator<Object> getSourceIterator() throws DataSourceException {
                return SharedIteratorSpaceDataSourceDecorator.this._spaceDataSource.getDataIterator(dataSourceQuery);
            }
        }, this._timeToLive);
        sharedDataIteratorSource.addStateChangedListener(this);
        SharedDataIteratorSource<Object> previousMediator = this._queryToSources.putIfAbsent(dataSourceSQLQuery, sharedDataIteratorSource);
        if (previousMediator != null) {
            sharedDataIteratorSource = previousMediator;
        } else {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("create new shared iterator source for query " + dataSourceSQLQuery.toString());
            }
            this._sourcesToQuery.put(sharedDataIteratorSource, dataSourceSQLQuery);
        }
        return sharedDataIteratorSource;
    }

    @Override
    public void onClosed(SharedDataIteratorSource<Object> sender) {
        this.handleSourceStateChangedEvent(sender);
    }

    @Override
    public void onExpired(SharedDataIteratorSource<Object> sender) {
        this.handleSourceStateChangedEvent(sender);
    }

    private void handleSourceStateChangedEvent(SharedDataIteratorSource<Object> sender) {
        DataSourceSQLQuery query = this._sourcesToQuery.remove(sender);
        if (_logger.isLoggable(Level.FINEST) && query != null) {
            _logger.finest("shared iterator source is closed or expired, detaching from local table [" + query.toString() + "]");
        }
        if (query != null) {
            this._queryToSources.remove(query);
        }
    }

    @Override
    public DataIterator<Object> initialDataLoad() {
        return this._spaceDataSource.initialDataLoad();
    }

    @Override
    public DataIterator<SpaceTypeDescriptor> initialMetadataLoad() {
        return this._spaceDataSource.initialMetadataLoad();
    }

    @Override
    public Object getById(DataSourceIdQuery idQuery) {
        return this._spaceDataSource.getById(idQuery);
    }

    @Override
    public DataIterator<Object> getDataIteratorByIds(DataSourceIdsQuery idsQuery) {
        return this._spaceDataSource.getDataIteratorByIds(idsQuery);
    }

    @Override
    public boolean supportsInheritance() {
        return this._spaceDataSource.supportsInheritance();
    }
}

