/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.document;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.document.DocumentProperties;
import com.gigaspaces.document.SpaceDocument;
import com.gigaspaces.internal.metadata.SpaceDocumentSupportHelper;
import com.gigaspaces.internal.metadata.SpacePropertyInfo;
import com.gigaspaces.internal.metadata.SpaceTypeInfo;
import com.gigaspaces.internal.metadata.SpaceTypeInfoRepository;
import com.gigaspaces.internal.utils.CollectionUtils;
import com.gigaspaces.metadata.SpaceDocumentSupport;
import com.gigaspaces.metadata.SpaceMetadataException;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;

@InternalApi
public class DocumentObjectConverter {
    private static final DocumentObjectConverter _instance = new DocumentObjectConverter();
    private final boolean _throwExceptionOnTypeMissing;

    public static DocumentObjectConverter instance() {
        return _instance;
    }

    public DocumentObjectConverter() {
        this(true);
    }

    protected DocumentObjectConverter(boolean throwExceptionOnTypeMissing) {
        this._throwExceptionOnTypeMissing = throwExceptionOnTypeMissing;
    }

    public SpaceDocument toSpaceDocument(Object object) {
        ToDocumentConvertionContext conversionContext = new ToDocumentConvertionContext();
        return this.toSpaceDocumentInternal(object, conversionContext);
    }

    private SpaceDocument toSpaceDocumentInternal(Object object, ToDocumentConvertionContext conversionContext) {
        if (object == null) {
            return null;
        }
        if (object instanceof SpaceDocument) {
            return (SpaceDocument)object;
        }
        SpaceTypeInfo typeInfo = SpaceTypeInfoRepository.getTypeInfo(object.getClass());
        SpaceDocument document = new SpaceDocument(typeInfo.getName());
        if (typeInfo.getNumOfSpaceProperties() != 0) {
            Object[] values = typeInfo.getSpacePropertiesValues(object, true);
            for (int i = 0; i < values.length; ++i) {
                SpacePropertyInfo property = typeInfo.getProperty(i);
                Object value = this.toDocumentIfNeededInternal(values[i], property.getDocumentSupport(), conversionContext);
                document.setProperty(property.getName(), value);
            }
        }
        if (typeInfo.getDynamicPropertiesProperty() != null) {
            document.addProperties((Map)typeInfo.getDynamicPropertiesProperty().getValue(object));
        }
        if (typeInfo.getVersionProperty() != null) {
            document.setVersion((Integer)typeInfo.getVersionProperty().getValue(object));
        }
        if (typeInfo.getPersistProperty() != null) {
            document.setTransient((Boolean)typeInfo.getPersistProperty().getValue(object) == false);
        }
        return document;
    }

    public Object toObject(SpaceDocument document) {
        FromDocumentConvertionContext conversionContext = new FromDocumentConvertionContext();
        return this.toObjectInternal(document, conversionContext);
    }

    private Object toObjectInternal(SpaceDocument document, FromDocumentConvertionContext conversionContext) {
        SpaceTypeInfo typeInfo;
        if (document == null) {
            return null;
        }
        if (this._throwExceptionOnTypeMissing) {
            typeInfo = (SpaceTypeInfo)SpaceTypeInfoRepository.getGlobalRepository().getByName(document.getTypeName());
        } else {
            typeInfo = (SpaceTypeInfo)SpaceTypeInfoRepository.getGlobalRepository().getByNameIfExists(document.getTypeName());
            if (typeInfo == null) {
                return document;
            }
        }
        int numOfSpaceProperties = typeInfo.getNumOfSpaceProperties();
        Object[] fixedProperties = numOfSpaceProperties != 0 ? new Object[numOfSpaceProperties] : null;
        DocumentProperties dynamicProperties = null;
        for (Map.Entry<String, Object> entry : document.getProperties().entrySet()) {
            String propertyName = entry.getKey();
            Object propertyValue = entry.getValue();
            SpacePropertyInfo pojoProperty = typeInfo.getProperty(propertyName);
            int position = typeInfo.indexOf(pojoProperty);
            if (position != -1) {
                fixedProperties[position] = this.fromDocumentIfNeededInternal(propertyValue, pojoProperty.getDocumentSupport(), pojoProperty.getType(), conversionContext);
                continue;
            }
            if (dynamicProperties == null) {
                dynamicProperties = new DocumentProperties();
            }
            dynamicProperties.put(propertyName, propertyValue);
        }
        if (dynamicProperties != null && typeInfo.getDynamicPropertiesProperty() == null) {
            throw new SpaceMetadataException("Cannot set dynamic properties in type '" + typeInfo.getName() + "' because it does not support dynamic properties.");
        }
        if (typeInfo.hasConstructorProperties()) {
            return typeInfo.createConstructorBasedInstance(fixedProperties, dynamicProperties, null, document.getVersion(), Long.MAX_VALUE, !document.isTransient());
        }
        Object object = typeInfo.createInstance();
        if (fixedProperties != null) {
            typeInfo.setSpacePropertiesValues(object, fixedProperties);
        }
        if (dynamicProperties != null) {
            typeInfo.getDynamicPropertiesProperty().setValue(object, dynamicProperties);
        }
        if (typeInfo.getVersionProperty() != null) {
            typeInfo.getVersionProperty().setValue(object, document.getVersion());
        }
        if (typeInfo.getPersistProperty() != null) {
            typeInfo.getPersistProperty().setValue(object, !document.isTransient());
        }
        return object;
    }

    public Object toDocumentIfNeeded(Object object, SpaceDocumentSupport documentSupport) {
        return this.toDocumentIfNeededInternal(object, documentSupport, null);
    }

    private Object toDocumentIfNeededInternal(Object object, SpaceDocumentSupport documentSupport, ToDocumentConvertionContext conversionContext) {
        if (object == null) {
            return null;
        }
        if (object instanceof List && object instanceof RandomAccess) {
            return this.toDocumentListIfNeeded((List)object, documentSupport, conversionContext);
        }
        if (object instanceof Collection) {
            return this.toDocumentCollectionIfNeeded((Collection)object, documentSupport, conversionContext);
        }
        if (object instanceof Object[]) {
            return this.toDocumentArrayIfNeeded((Object[])object, documentSupport, conversionContext);
        }
        if (object instanceof Map) {
            return this.toDocumentMapIfNeeded((Map)object, documentSupport, conversionContext);
        }
        switch (documentSupport) {
            case COPY: {
                return object;
            }
            case CONVERT: {
                return this.convertObjectToDocument(object, conversionContext);
            }
            case DEFAULT: {
                documentSupport = SpaceDocumentSupportHelper.getDefaultDocumentSupport(object.getClass());
                if (documentSupport == SpaceDocumentSupport.CONVERT) {
                    return this.convertObjectToDocument(object, conversionContext);
                }
                return object;
            }
        }
        throw new IllegalArgumentException("Unsupported SpaceDocumentSupport - " + (Object)((Object)documentSupport));
    }

    private SpaceDocument convertObjectToDocument(Object object, ToDocumentConvertionContext conversionContext) {
        if (conversionContext == null) {
            return this.toSpaceDocument(object);
        }
        SpaceDocument document = conversionContext.getConvertedDocument(object);
        if (document != null) {
            return document;
        }
        conversionContext.initConvertionState(object);
        document = this.toSpaceDocumentInternal(object, conversionContext);
        conversionContext.setConvertedDocument(object, document);
        return conversionContext.getConvertedDocument(object);
    }

    protected Object fromDocumentIfNeeded(Object object, SpaceDocumentSupport documentSupport, Class<?> expectedType) {
        return this.fromDocumentIfNeededInternal(object, documentSupport, expectedType, null);
    }

    private Object fromDocumentIfNeededInternal(Object object, SpaceDocumentSupport documentSupport, Class<?> expectedType, FromDocumentConvertionContext conversionContext) {
        if (object == null) {
            return null;
        }
        if (object instanceof List && object instanceof RandomAccess) {
            return this.fromDocumentListIfNeeded((List)object, documentSupport, expectedType, conversionContext);
        }
        if (object instanceof Collection) {
            return this.fromDocumentCollectionIfNeeded((Collection)object, documentSupport, expectedType, conversionContext);
        }
        if (object instanceof Object[]) {
            return this.fromDocumentArrayIfNeeded((Object[])object, documentSupport, expectedType, conversionContext);
        }
        if (object instanceof Map) {
            return this.fromDocumentMapIfNeeded((Map)object, documentSupport, conversionContext);
        }
        switch (documentSupport) {
            case COPY: {
                return object;
            }
            case CONVERT: {
                if (object instanceof SpaceDocument) {
                    return this.convertDocumentToObject((SpaceDocument)object, expectedType, conversionContext);
                }
                if (object.getClass().equals(expectedType) || expectedType.isInstance(object)) {
                    return object;
                }
                throw new IllegalArgumentException("Cannot convert from document to '" + expectedType.getName() + "' - type '" + object.getClass() + "' is not a document.");
            }
            case DEFAULT: {
                if (object instanceof SpaceDocument) {
                    return this.convertDocumentToObject((SpaceDocument)object, expectedType, conversionContext);
                }
                return object;
            }
        }
        throw new IllegalArgumentException("Unsupported SpaceDocumentSupport - " + (Object)((Object)documentSupport));
    }

    private Object convertDocumentToObject(SpaceDocument document, Class<?> expectedType, FromDocumentConvertionContext conversionContext) {
        if (conversionContext == null) {
            return this.toObject(document);
        }
        Object object = conversionContext.getConvertedObject(document);
        if (object != null) {
            return object;
        }
        conversionContext.initConvertionState(document);
        object = this.toObjectInternal(document, conversionContext);
        conversionContext.setConvertedObject(document, object);
        return conversionContext.getConvertedObject(document);
    }

    private Object toDocumentMapIfNeeded(Map<Object, Object> map, SpaceDocumentSupport documentSupport, ToDocumentConvertionContext conversionContext) {
        if (documentSupport == SpaceDocumentSupport.COPY) {
            return map;
        }
        Map<Object, Object> result = null;
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            Object convertedKey = this.toDocumentIfNeededInternal(key, documentSupport, conversionContext);
            Object convertedValue = this.toDocumentIfNeededInternal(value, documentSupport, conversionContext);
            if (key != convertedKey) {
                if (result == null) {
                    result = CollectionUtils.cloneMap(map);
                }
                result.remove(key);
                result.put(convertedKey, convertedValue);
                continue;
            }
            if (value == convertedValue) continue;
            if (result == null) {
                result = CollectionUtils.cloneMap(map);
            }
            result.put(key, convertedValue);
        }
        return result != null ? result : map;
    }

    private Object fromDocumentMapIfNeeded(Map<Object, Object> map, SpaceDocumentSupport documentSupport, FromDocumentConvertionContext conversionContext) {
        if (documentSupport == SpaceDocumentSupport.COPY) {
            return map;
        }
        Map<Object, Object> result = null;
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            Object convertedKey = this.fromDocumentIfNeededInternal(key, documentSupport, Object.class, conversionContext);
            Object convertedValue = this.fromDocumentIfNeededInternal(value, documentSupport, Object.class, conversionContext);
            if (key != convertedKey) {
                if (result == null) {
                    result = CollectionUtils.cloneMap(map);
                }
                result.remove(key);
                result.put(convertedKey, convertedValue);
                continue;
            }
            if (value == convertedValue) continue;
            if (result == null) {
                result = CollectionUtils.cloneMap(map);
            }
            result.put(key, convertedValue);
        }
        return result != null ? result : map;
    }

    private Object toDocumentListIfNeeded(List<Object> list, SpaceDocumentSupport documentSupport, ToDocumentConvertionContext conversionContext) {
        if (documentSupport == SpaceDocumentSupport.COPY) {
            return list;
        }
        List<Object> result = null;
        int length = list.size();
        for (int i = 0; i < length; ++i) {
            Object convertedItem;
            Object item = list.get(i);
            if (item == (convertedItem = this.toDocumentIfNeededInternal(item, documentSupport, conversionContext))) continue;
            if (result == null) {
                result = CollectionUtils.cloneList(list);
            }
            result.set(i, convertedItem);
        }
        return result != null ? result : list;
    }

    private Object fromDocumentListIfNeeded(List<Object> list, SpaceDocumentSupport documentSupport, Class<?> expectedType, FromDocumentConvertionContext conversionContext) {
        if (documentSupport == SpaceDocumentSupport.COPY) {
            return list;
        }
        List<Object> result = null;
        int length = list.size();
        for (int i = 0; i < length; ++i) {
            Object convertedItem;
            Object item = list.get(i);
            if (item == (convertedItem = this.fromDocumentIfNeededInternal(item, documentSupport, Object.class, conversionContext))) continue;
            if (result == null) {
                result = CollectionUtils.cloneList(list);
            }
            result.set(i, convertedItem);
        }
        return result != null ? result : list;
    }

    private Object toDocumentCollectionIfNeeded(Collection<?> collection, SpaceDocumentSupport documentSupport, ToDocumentConvertionContext conversionContext) {
        if (documentSupport == SpaceDocumentSupport.COPY) {
            return collection;
        }
        SpaceTypeInfo collectionInfo = SpaceTypeInfoRepository.getTypeInfo(collection.getClass());
        Collection result = (Collection)collectionInfo.createInstance();
        for (Object item : collection) {
            result.add(this.toDocumentIfNeededInternal(item, documentSupport, conversionContext));
        }
        return result;
    }

    private Object fromDocumentCollectionIfNeeded(Collection<?> collection, SpaceDocumentSupport documentSupport, Class<?> expectedType, FromDocumentConvertionContext conversionContext) {
        if (documentSupport == SpaceDocumentSupport.COPY) {
            return collection;
        }
        SpaceTypeInfo collectionInfo = SpaceTypeInfoRepository.getTypeInfo(collection.getClass());
        Collection result = (Collection)collectionInfo.createInstance();
        for (Object item : collection) {
            result.add(this.fromDocumentIfNeededInternal(item, documentSupport, Object.class, conversionContext));
        }
        return result;
    }

    private Object toDocumentArrayIfNeeded(Object[] array, SpaceDocumentSupport documentSupport, ToDocumentConvertionContext conversionContext) {
        if (documentSupport == SpaceDocumentSupport.COPY) {
            return array;
        }
        int arrayLength = array.length;
        Object[] tempArray = new Object[arrayLength];
        int documentCount = 0;
        for (int i = 0; i < arrayLength; ++i) {
            tempArray[i] = this.toDocumentIfNeededInternal(array[i], documentSupport, conversionContext);
            if (!(tempArray[i] instanceof SpaceDocument)) continue;
            ++documentCount;
        }
        Object[] result = null;
        result = documentCount == 0 ? Array.newInstance(array.getClass().getComponentType(), arrayLength) : (documentCount == arrayLength ? new SpaceDocument[arrayLength] : new Object[arrayLength]);
        System.arraycopy(tempArray, 0, result, 0, arrayLength);
        return result;
    }

    private Object fromDocumentArrayIfNeeded(Object[] array, SpaceDocumentSupport documentSupport, Class<?> expectedType, FromDocumentConvertionContext conversionContext) {
        if (documentSupport == SpaceDocumentSupport.COPY) {
            return array;
        }
        Class componentType = expectedType.isArray() ? expectedType.getComponentType() : Object.class;
        Object[] result = (Object[])Array.newInstance(componentType, array.length);
        for (int i = 0; i < array.length; ++i) {
            result[i] = this.fromDocumentIfNeededInternal(array[i], documentSupport, componentType, conversionContext);
        }
        return result;
    }

    private static class ObjectHolder {
        Object object;

        private ObjectHolder() {
        }

        public Object getObject() {
            return this.object;
        }

        public void setObject(Object object) {
            this.object = object;
        }
    }

    private static class SpaceDocumentHolder {
        SpaceDocument document = new SpaceDocument();

        private SpaceDocumentHolder() {
        }

        public SpaceDocument getSpaceDocument() {
            return this.document;
        }

        public void setDocument(SpaceDocument otherDocument) {
            this.document.initFromDocument(otherDocument);
        }
    }

    private static class FromDocumentConvertionContext {
        private IdentityHashMap<SpaceDocument, ObjectHolder> convertedDocumentsMap = null;

        public void setConvertedObject(SpaceDocument document, Object object) {
            if (this.convertedDocumentsMap.get(document) != null) {
                this.convertedDocumentsMap.get(document).setObject(object);
            }
        }

        public void initConvertionState(SpaceDocument document) {
            if (this.convertedDocumentsMap == null) {
                this.convertedDocumentsMap = new IdentityHashMap();
            }
            this.convertedDocumentsMap.put(document, new ObjectHolder());
        }

        public Object getConvertedObject(SpaceDocument document) {
            if (this.convertedDocumentsMap != null && this.convertedDocumentsMap.containsKey(document)) {
                return this.convertedDocumentsMap.get(document).getObject();
            }
            return null;
        }
    }

    private static class ToDocumentConvertionContext {
        private IdentityHashMap<Object, SpaceDocumentHolder> convertedObjectsMap = null;

        public void setConvertedDocument(Object object, SpaceDocument document) {
            if (this.convertedObjectsMap.get(object) != null) {
                this.convertedObjectsMap.get(object).setDocument(document);
            }
        }

        public void initConvertionState(Object object) {
            if (this.convertedObjectsMap == null) {
                this.convertedObjectsMap = new IdentityHashMap();
            }
            this.convertedObjectsMap.put(object, new SpaceDocumentHolder());
        }

        public SpaceDocument getConvertedDocument(Object object) {
            if (this.convertedObjectsMap != null && this.convertedObjectsMap.containsKey(object)) {
                return this.convertedObjectsMap.get(object).getSpaceDocument();
            }
            return null;
        }
    }
}

