/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.document;

import com.gigaspaces.internal.collections.CollectionsFactory;
import com.gigaspaces.internal.collections.MapProcedure;
import com.gigaspaces.internal.io.IOUtils;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class DocumentProperties
implements Map<String, Object>,
Externalizable {
    private static final long serialVersionUID = 1L;
    private Map<String, Object> _map;
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private static final Map<String, Object> EMPTY_PROPERTIES = CollectionsFactory.getInstance().createMap();

    public DocumentProperties() {
        this(16, 0.75f);
    }

    public DocumentProperties(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public DocumentProperties(int initialCapacity, float loadFactor) {
        this._map = CollectionsFactory.getInstance().createMap(initialCapacity, loadFactor);
    }

    public DocumentProperties(Map<String, Object> properties) {
        this._map = CollectionsFactory.getInstance().createMap(properties != null ? properties : EMPTY_PROPERTIES);
    }

    public <T> T getProperty(String name) {
        return (T)this._map.get(name);
    }

    public DocumentProperties setProperty(String name, Object value) {
        this._map.put(name, value);
        return this;
    }

    @Override
    public int size() {
        return this._map.size();
    }

    @Override
    public boolean isEmpty() {
        return this._map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this._map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this._map.containsValue(value);
    }

    @Override
    public Object get(Object key) {
        return this._map.get(key);
    }

    @Override
    public Object put(String key, Object value) {
        return this._map.put(key, value);
    }

    @Override
    public Object remove(Object key) {
        return this._map.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> t) {
        this._map.putAll(t);
    }

    @Override
    public void clear() {
        this._map.clear();
    }

    @Override
    public Set<String> keySet() {
        return this._map.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this._map.values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this._map.entrySet();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        int size = this._map.size();
        out.writeInt(size);
        if (size != 0) {
            SerializationProcedure.execute(this._map, out);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        this._map = CollectionsFactory.getInstance().createMap(size);
        if (size != 0) {
            for (int i = 0; i < size; ++i) {
                String name = IOUtils.readRepetitiveString(in);
                Object value = IOUtils.readObject(in);
                this._map.put(name, value);
            }
        }
    }

    public String toString() {
        return "DocumentProperties " + this._map;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        return this._map.equals(obj);
    }

    @Override
    public int hashCode() {
        return this._map.hashCode();
    }

    private static class SerializationProcedure
    implements MapProcedure<String, Object> {
        private final ObjectOutput _out;
        private IOException _ioException;

        private SerializationProcedure(ObjectOutput out) {
            this._out = out;
        }

        public static boolean execute(Map<String, Object> map, ObjectOutput out) throws IOException {
            SerializationProcedure procedure = new SerializationProcedure(out);
            boolean result = CollectionsFactory.getInstance().forEachEntry(map, procedure);
            if (procedure._ioException != null) {
                throw procedure._ioException;
            }
            return result;
        }

        @Override
        public boolean execute(String key, Object value) {
            try {
                IOUtils.writeRepetitiveString(this._out, key);
                IOUtils.writeObject(this._out, value);
                return true;
            }
            catch (IOException e) {
                this._ioException = e;
                return false;
            }
        }
    }
}

