/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.document;

import com.gigaspaces.document.DocumentProperties;
import com.gigaspaces.entry.VirtualEntry;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.utils.ObjectUtils;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Map;

public class SpaceDocument
implements VirtualEntry,
Externalizable {
    private static final long serialVersionUID = 1L;
    private static final byte _classVersion = 1;
    private static final String _defaultTypeName = Object.class.getName();
    private String _typeName;
    private int _version;
    private boolean _transient;
    private DocumentProperties _properties;
    private transient Map<String, Object> _propertiesView;

    public SpaceDocument() {
        this(_defaultTypeName, null);
    }

    public SpaceDocument(String typeName) {
        this(typeName, null);
    }

    public SpaceDocument(String typeName, Map<String, Object> properties) {
        this.setTypeName(typeName);
        this._properties = new DocumentProperties(properties);
        this.initialize();
    }

    protected void initialize() {
        this._propertiesView = Collections.unmodifiableMap(this._properties);
    }

    @Override
    public String getTypeName() {
        return this._typeName;
    }

    @Override
    public SpaceDocument setTypeName(String typeName) {
        if (typeName == null || typeName.length() == 0) {
            throw new IllegalArgumentException("Argument cannot be null or empty - 'typeName'.");
        }
        this._typeName = typeName;
        return this;
    }

    @Override
    public boolean containsProperty(String name) {
        return this._properties.containsKey(name);
    }

    @Override
    public <T> T getProperty(String name) {
        return (T)this._properties.get(name);
    }

    @Override
    public SpaceDocument setProperty(String name, Object value) {
        this._properties.put(name, value);
        return this;
    }

    @Override
    public <T> T removeProperty(String name) {
        return (T)this._properties.remove(name);
    }

    @Override
    public Map<String, Object> getProperties() {
        return this._propertiesView;
    }

    @Override
    public SpaceDocument addProperties(Map<String, Object> properties) {
        if (properties != null) {
            this._properties.putAll((Map<? extends String, ? extends Object>)properties);
        }
        return this;
    }

    @Override
    public int getVersion() {
        return this._version;
    }

    @Override
    public SpaceDocument setVersion(int version) {
        this._version = version;
        return this;
    }

    @Override
    public boolean isTransient() {
        return this._transient;
    }

    @Override
    public SpaceDocument setTransient(boolean isTransient) {
        this._transient = isTransient;
        return this;
    }

    public String toString() {
        return "SpaceDocument [typeName=" + this._typeName + ", version=" + this._version + ", transient=" + this._transient + ", properties=" + this._properties + "]";
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpaceDocument)) {
            return false;
        }
        SpaceDocument other = (SpaceDocument)obj;
        if (!ObjectUtils.equals(this._typeName, other._typeName)) {
            return false;
        }
        if (this._transient != other._transient) {
            return false;
        }
        if (this._version != other._version) {
            return false;
        }
        return ObjectUtils.equals(this._properties, other._properties);
    }

    public int hashCode() {
        return this._typeName.hashCode() * 31 + this._properties.hashCode();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        boolean classVersion = true;
        out.writeByte(1);
        this.writeExternalV1(out);
    }

    private void writeExternalV1(ObjectOutput out) throws IOException {
        IOUtils.writeRepetitiveString(out, this._typeName);
        out.writeBoolean(this._transient);
        out.writeInt(this._version);
        IOUtils.writeObject(out, this._properties);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte classVersion = in.readByte();
        if (classVersion != 1) {
            throw new IOException("Failed to deserialize SpaceDocument: unsupported class version  " + classVersion + ".");
        }
        this.readExternalV1(in);
    }

    public void readExternalV1(ObjectInput in) throws IOException, ClassNotFoundException {
        this._typeName = IOUtils.readRepetitiveString(in);
        this._transient = in.readBoolean();
        this._version = in.readInt();
        this._properties = (DocumentProperties)IOUtils.readObject(in);
        this.initialize();
    }

    public void initFromDocument(SpaceDocument document) {
        this.setTypeName(document._typeName);
        this.setTransient(document._transient);
        this.setVersion(document._version);
        this.addProperties((Map)document._properties);
        this.initialize();
    }
}

