/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.events;

import com.gigaspaces.events.DataEventSession;
import com.gigaspaces.events.EventSessionConfig;
import com.gigaspaces.events.NotifyActionType;
import com.gigaspaces.events.NotifyInfo;
import com.gigaspaces.internal.client.spaceproxy.IDirectSpaceProxy;
import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.client.INotifyDelegatorFilter;
import java.rmi.MarshalledObject;
import java.rmi.RemoteException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.event.EventRegistration;
import net.jini.core.event.RemoteEventListener;

public abstract class AbstractDataEventSession
implements DataEventSession {
    private static final long DEFAULT_LEASE = Long.MAX_VALUE;
    private static final NotifyActionType DEFAULT_NOTIFY_TYPE = NotifyActionType.NOTIFY_ALL;
    private final ISpaceProxy _space;
    private final IDirectSpaceProxy _notificationsSpace;
    private final EventSessionConfig _config;
    private final Logger _logger;

    protected AbstractDataEventSession(IJSpace space, EventSessionConfig config) {
        this._space = (ISpaceProxy)space;
        this._notificationsSpace = this._space.getNotificationsDirectProxy();
        this._config = config;
        this._logger = this._notificationsSpace.getDataEventsManager().getLogger();
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, "DataEventSession created - " + config.toString());
        }
    }

    @Override
    public IJSpace getSpace() {
        return this._space;
    }

    protected IDirectSpaceProxy getNotificationsSpace() {
        return this._notificationsSpace;
    }

    @Override
    public EventSessionConfig getSessionConfig() {
        return this._config;
    }

    @Override
    public void close() throws RemoteException {
    }

    @Override
    public EventRegistration addListener(Object template, RemoteEventListener listener) throws RemoteException {
        return this.addListener(template, listener, Long.MAX_VALUE, DEFAULT_NOTIFY_TYPE);
    }

    @Override
    public EventRegistration addListener(Object template, RemoteEventListener listener, NotifyActionType actionTypes) throws RemoteException {
        return this.addListener(template, listener, Long.MAX_VALUE, actionTypes);
    }

    @Override
    public EventRegistration addListener(Object template, RemoteEventListener listener, long lease, NotifyActionType actionTypes) throws RemoteException {
        return this.addListener(template, listener, lease, null, null, actionTypes);
    }

    @Override
    public EventRegistration addListener(Object template, RemoteEventListener listener, NotifyActionType notifyType, MarshalledObject handback, INotifyDelegatorFilter filter) throws RemoteException {
        return this.addListener(template, listener, Long.MAX_VALUE, handback, filter, notifyType);
    }

    @Override
    public EventRegistration addListener(Object template, RemoteEventListener listener, long lease, MarshalledObject handback, INotifyDelegatorFilter filter, NotifyActionType notifyType) throws RemoteException {
        return this.addListener(template, lease, new NotifyInfo(listener, notifyType, this._config, handback, filter));
    }

    public EventRegistration addListener(Object template, long lease, NotifyInfo notifyInfo) throws RemoteException {
        this._space.applyNotifyInfoDefaults(notifyInfo);
        notifyInfo.validateModifiers();
        return this.addListenerInternal(template, lease, notifyInfo);
    }

    protected abstract EventRegistration addListenerInternal(Object var1, long var2, NotifyInfo var4) throws RemoteException;

    public NotifyInfo createNotifyInfo(RemoteEventListener listener, NotifyActionType notifyType) {
        return new NotifyInfo(listener, notifyType, this._config, null, null);
    }

    @Override
    public void removeListener(EventRegistration registration) throws RemoteException {
    }
}

