/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.events;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.events.AbstractDataEventSession;
import com.gigaspaces.events.EventSessionConfig;
import com.gigaspaces.events.NotifyInfo;
import com.gigaspaces.events.lease.EventLeaseRenewalManager;
import com.gigaspaces.events.lease.JiniEventLeaseRenewalManager;
import com.gigaspaces.internal.client.spaceproxy.events.SpaceProxyDataEventsManager;
import com.gigaspaces.internal.utils.collections.ConcurrentHashSet;
import com.j_spaces.core.IJSpace;
import java.rmi.RemoteException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.event.EventRegistration;
import net.jini.core.lease.UnknownLeaseException;
import net.jini.lease.LeaseListener;
import net.jini.lease.LeaseRenewalEvent;

@InternalApi
public class DefaultDataEventSession
extends AbstractDataEventSession {
    private static final LeaseListener DEFAULT_LEASE_LISTENER = new DefaultLeaseListener();
    private final Logger logger;
    private final SpaceProxyDataEventsManager eventsManager = this.getNotificationsSpace().getDataEventsManager();
    private final Set<EventRegistration> events;
    private final boolean isMultiplex;
    private final EventLeaseRenewalManager renewalManager;
    private final LeaseListener leaseListener;

    DefaultDataEventSession(IJSpace space, EventSessionConfig config) {
        super(space, config);
        this.logger = this.eventsManager.getLogger();
        this.events = new ConcurrentHashSet<EventRegistration>();
        this.isMultiplex = true;
        this.renewalManager = this.initRenewalManager(config);
        this.leaseListener = config.getLeaseListener() != null ? config.getLeaseListener() : DEFAULT_LEASE_LISTENER;
    }

    private EventLeaseRenewalManager initRenewalManager(EventSessionConfig config) {
        if (!config.isAutoRenew()) {
            return null;
        }
        if (!this.isMultiplex) {
            return new JiniEventLeaseRenewalManager(config);
        }
        if (EventSessionConfig.USE_OLD_LEASE_RENEWAL_MANAGER) {
            if (this.logger.isLoggable(Level.WARNING)) {
                this.logger.log(Level.WARNING, "Multiplex auto-renew is disabled because com.gs.core.notify.old-lease-renewal-manager is set to true.");
            }
            return new JiniEventLeaseRenewalManager(config);
        }
        if (config.getRenewDuration() != 20000L) {
            if (this.logger.isLoggable(Level.WARNING)) {
                this.logger.log(Level.WARNING, "Multiplex auto-renew is disabled because renewDuration has been modified.");
            }
            return new JiniEventLeaseRenewalManager(config);
        }
        if (config.getRenewExpiration() != Long.MAX_VALUE) {
            if (this.logger.isLoggable(Level.WARNING)) {
                this.logger.log(Level.WARNING, "Multiplex auto-renew is disabled because renewExpiration has been modified.");
            }
            return new JiniEventLeaseRenewalManager(config);
        }
        if (config.getRenewRTT() != 10000L) {
            if (this.logger.isLoggable(Level.WARNING)) {
                this.logger.log(Level.WARNING, "Multiplex auto-renew is disabled because renewRTT has been modified.");
            }
            return new JiniEventLeaseRenewalManager(config);
        }
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("Multiplex auto-renew is enabled.");
        }
        return this.eventsManager.getRenewalManager();
    }

    @Override
    protected EventRegistration addListenerInternal(Object template, long lease, NotifyInfo info) throws RemoteException {
        if (this.renewalManager != null && !this.renewalManager.supportsCustomLease()) {
            if (lease != Long.MAX_VALUE && lease != this.renewalManager.getRenewalDuration()) {
                this.logger.warning("Custom lease is ignored when using a multiplex data event session with auto-renew - the session's renewalDuration (" + this.renewalManager.getRenewalDuration() + ") is used instead.");
            }
            lease = this.renewalManager.getRenewalDuration();
        }
        EventRegistration registration = this.eventsManager.addListener(template, lease, info, this.isMultiplex);
        this.events.add(registration);
        if (this.renewalManager != null) {
            this.renewalManager.registerAutoRenew(registration, this.leaseListener);
        }
        return registration;
    }

    @Override
    public void removeListener(EventRegistration registration) throws RemoteException {
        if (this.renewalManager != null) {
            this.renewalManager.unregisterAutoRenew(registration);
        }
        this.events.remove(registration);
        try {
            registration.getLease().cancel();
        }
        catch (UnknownLeaseException unknownLeaseException) {
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public void close() throws RemoteException {
        for (EventRegistration registration : this.events) {
            this.removeListener(registration);
        }
        if (this.renewalManager != null && this.renewalManager != this.eventsManager.getRenewalManager()) {
            this.renewalManager.close();
        }
        super.close();
    }

    private static class DefaultLeaseListener
    implements LeaseListener {
        private static final Logger _logger = Logger.getLogger("com.gigaspaces.client");

        private DefaultLeaseListener() {
        }

        @Override
        public void notify(LeaseRenewalEvent e) {
            _logger.log(Level.FINE, "Cannot renew lease", e.getException());
        }
    }
}

