/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.events;

import com.gigaspaces.internal.utils.Textualizable;
import com.gigaspaces.internal.utils.Textualizer;
import java.io.IOException;
import java.io.Serializable;
import java.util.Properties;
import java.util.Set;
import net.jini.lease.LeaseListener;

public class EventSessionConfig
implements Serializable,
Textualizable {
    private static final long serialVersionUID = 4035209046639421771L;
    public static final String USE_OLD_LEASE_RENEWAL_MANAGER_PROPERTY = "com.gs.core.notify.old-lease-renewal-manager";
    public static final boolean USE_OLD_GUARANTEED_NOTIFICATIONS = Boolean.getBoolean("com.gs.core.notify.old-guaranteed-notifications");
    public static final boolean USE_OLD_LEASE_RENEWAL_MANAGER = Boolean.getBoolean("com.gs.core.notify.old-lease-renewal-manager");
    @Deprecated
    public static final long DEFAULT_RENEW_EXPIRATION = Long.MAX_VALUE;
    public static final long DEFAULT_RENEW_DURATION = 20000L;
    public static final long DEFAULT_RENEW_RTT = 10000L;
    private static final int DEFAULT_BATCH_SIZE = 0;
    private static final long DEFAULT_BATCH_TIME = 0L;
    private static final int DEFAULT_BATCH_PENDING_THRESHOLD = 0;
    public static final int DEFAULT_DURABLE_BATCH_SIZE = 5000;
    public static final int DEFAULT_DURABLE_BATCH_PENDING_THRESHOLD = 100;
    public static final long DEFAULT_DURABLE_BATCH_TIME = 10L;
    private boolean fifo = false;
    private boolean batch = false;
    private int batchSize = 0;
    private long batchTime = 0L;
    private int batchPendingThreshold = 0;
    private boolean renew = false;
    private boolean durable = false;
    private Boolean triggerNotifyTemplate;
    private Boolean replicateNotifyTemplate;
    private LeaseListener leaseListener = null;
    private long renewExpiration = Long.MAX_VALUE;
    private long renewDuration = 20000L;
    private long renewRTT = 10000L;
    private boolean _guaranteedNotifications = false;

    public EventSessionConfig() {
    }

    @Deprecated
    public EventSessionConfig(Properties props) {
        this.loadFromProps(props);
    }

    @Deprecated
    public EventSessionConfig(String schemaName) throws IOException {
        if (schemaName == null) {
            return;
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = this.getClass().getClassLoader();
        }
        Properties props = new Properties();
        props.load(cl.getResourceAsStream("config/" + schemaName + ".properties"));
        this.loadFromProps(props);
    }

    private void loadFromProps(Properties props) {
        Set<Object> keys = props.keySet();
        for (Object key : keys) {
            String value = props.getProperty((String)key);
            if (key.equals("fifo")) {
                this.fifo = Boolean.parseBoolean(value);
                continue;
            }
            if (key.equals("batchSize")) {
                this.batch = true;
                this.batchSize = Integer.parseInt(value);
                continue;
            }
            if (key.equals("batchTime")) {
                this.batch = true;
                this.batchTime = Integer.parseInt(value);
                continue;
            }
            if (key.equals("batchPendingThreshold")) {
                this.batch = true;
                this.batchPendingThreshold = Integer.parseInt(value);
                continue;
            }
            if (key.equals("autoRenew")) {
                this.renew = Boolean.parseBoolean(value);
                continue;
            }
            if (key.equals("durable")) {
                this.durable = Boolean.parseBoolean(value);
                this.setDurableNotifications(this.durable);
                continue;
            }
            if (key.equals("triggerNotifyTemplate")) {
                this.triggerNotifyTemplate = Boolean.parseBoolean(value);
                continue;
            }
            if (key.equals("replicateNotifyTemplate")) {
                this.replicateNotifyTemplate = Boolean.parseBoolean(value);
                continue;
            }
            if (key.equals("renewExpiration")) {
                this.renewExpiration = Long.parseLong(value);
                continue;
            }
            if (key.equals("renewDuration")) {
                this.renewDuration = Long.parseLong(value);
                continue;
            }
            if (key.equals("renewRTT")) {
                this.renewRTT = Long.parseLong(value);
                continue;
            }
            if (!key.equals("guaranteedNotifications")) continue;
            this._guaranteedNotifications = Boolean.parseBoolean(value);
        }
    }

    public boolean isFifo() {
        return this.fifo;
    }

    public EventSessionConfig setFifo(boolean fifo) {
        this.fifo = fifo;
        return this;
    }

    public boolean isBatching() {
        return this.batch;
    }

    public void setBatch(int size, long time) {
        this.setBatch(size, time, size);
    }

    public void setBatch(int size, long time, int pendingThreshold) {
        this.batch = size > 0 && time > 0L && pendingThreshold > 0;
        this.batchSize = size;
        this.batchTime = time;
        this.batchPendingThreshold = pendingThreshold;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public long getBatchTime() {
        return this.batchTime;
    }

    public int getBatchPendingThreshold() {
        return this.batchPendingThreshold;
    }

    public boolean isAutoRenew() {
        return this.renew;
    }

    public EventSessionConfig setAutoRenew(boolean renew, LeaseListener listener) {
        this.renew = renew;
        if (renew) {
            this.leaseListener = listener;
        }
        return this;
    }

    @Deprecated
    public void setAutoRenew(boolean renew, LeaseListener listener, long renewExpiration, long renewDuration, long renewRTT) {
        this.renew = renew;
        if (renew) {
            this.leaseListener = listener;
            this.renewRTT = renewRTT;
            this.renewDuration = renewDuration;
            this.renewExpiration = renewExpiration;
        }
    }

    public LeaseListener getLeaseListener() {
        return this.leaseListener;
    }

    public boolean isDurableNotifications() {
        return this.durable;
    }

    public EventSessionConfig setDurableNotifications(boolean durable) {
        this.durable = durable;
        if (durable) {
            if (this.batchSize <= 0) {
                this.batchSize = 5000;
            }
            if (this.batchTime <= 0L) {
                this.batchTime = 10L;
            }
            if (this.batchPendingThreshold <= 0) {
                this.batchTime = 100L;
            }
            this.batch = true;
        }
        return this;
    }

    public Boolean isTriggerNotifyTemplate() {
        return this.triggerNotifyTemplate;
    }

    public EventSessionConfig setTriggerNotifyTemplate(boolean triggerNotifyTemplate) {
        this.triggerNotifyTemplate = triggerNotifyTemplate;
        return this;
    }

    public Boolean isReplicateNotifyTemplate() {
        return this.replicateNotifyTemplate;
    }

    public EventSessionConfig setReplicateNotifyTemplate(boolean replicateNotifyTemplate) {
        this.replicateNotifyTemplate = replicateNotifyTemplate;
        return this;
    }

    public long getRenewDuration() {
        return this.renewDuration;
    }

    public long getRenewExpiration() {
        return this.renewExpiration;
    }

    public long getRenewRTT() {
        return this.renewRTT;
    }

    public boolean isGuaranteedNotifications() {
        if (USE_OLD_GUARANTEED_NOTIFICATIONS) {
            return this._guaranteedNotifications;
        }
        return this.isDurableNotifications();
    }

    @Deprecated
    public void setGuaranteedNotifications(boolean guaranteedNotifications) {
        if (USE_OLD_GUARANTEED_NOTIFICATIONS) {
            this._guaranteedNotifications = guaranteedNotifications;
        } else {
            this.setDurableNotifications(guaranteedNotifications);
        }
    }

    public void validate() {
        if (USE_OLD_GUARANTEED_NOTIFICATIONS && this.isGuaranteedNotifications() && this.isFifo()) {
            throw new UnsupportedOperationException("Notify delivery in case of a server failure can not be guaranteed for FIFO notifications.");
        }
        if (this.isDurableNotifications()) {
            if (this.triggerNotifyTemplate != null && this.triggerNotifyTemplate.booleanValue()) {
                throw new UnsupportedOperationException("Notify template cannot be triggered at backup space in durable notifications");
            }
            if (this.replicateNotifyTemplate != null && !this.replicateNotifyTemplate.booleanValue()) {
                throw new UnsupportedOperationException("Notify template is always replicated in durable notifications");
            }
        } else if (this.isBatching() && this.getBatchSize() != this.getBatchPendingThreshold()) {
            throw new UnsupportedOperationException("Batch pending threshold cannot be different than batch size in non-durable notification");
        }
    }

    public String toString() {
        return Textualizer.toString(this);
    }

    @Override
    public void toText(Textualizer textualizer) {
        textualizer.append("fifo", this.isFifo());
        textualizer.append("durable", this.isDurableNotifications());
        textualizer.append("guaranteed", this.isGuaranteedNotifications());
        textualizer.appendIfNotNull("triggerNotifyTemplate", this.isTriggerNotifyTemplate());
        textualizer.appendIfNotNull("replicateNotifyTemplate", this.isReplicateNotifyTemplate());
        textualizer.append("batch", this.isBatching());
        if (this.isBatching()) {
            textualizer.append("batchSize", this.getBatchSize());
            textualizer.append("batchTime", this.getBatchTime());
            textualizer.append("batchPendingThreshold", this.getBatchPendingThreshold());
        }
        textualizer.append("autoRenew", this.isAutoRenew());
        if (this.isAutoRenew()) {
            textualizer.append("leaseListener", this.getLeaseListener());
            textualizer.append("renewExpiration", this.getRenewExpiration());
            textualizer.append("renewDuration", this.getRenewDuration());
            textualizer.append("renewRTT", this.getRenewRTT());
        }
    }
}

