/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.events;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.utils.Textualizable;
import com.gigaspaces.internal.utils.Textualizer;
import java.util.HashMap;
import java.util.Map;
import net.jini.core.event.EventRegistration;
import net.jini.core.lease.Lease;
import net.jini.id.Uuid;

@InternalApi
public class GSEventRegistration
extends EventRegistration
implements Textualizable {
    private static final long serialVersionUID = -432048121117103185L;
    private final String _templateID;
    private final Uuid _spaceUID;
    private Map<Uuid, Long> _sequenceNumbers;

    public GSEventRegistration(long eventID, Object source, Lease lease, long seqNum) {
        this(eventID, source, lease, seqNum, null, null);
    }

    public GSEventRegistration(long eventID, Object source, Lease lease, long seqNum, String templateID, Uuid spaceUID) {
        super(eventID, source, lease, seqNum);
        this._templateID = templateID;
        this._spaceUID = spaceUID;
    }

    public void setLease(Lease lease) {
        this.lease = lease;
    }

    public String getTemplateID() {
        return this._templateID;
    }

    public Uuid getSpaceUID() {
        return this._spaceUID;
    }

    public String getKey() {
        if (this._templateID != null) {
            return this._templateID;
        }
        return Long.toString(this.getID());
    }

    public void addSequenceNumber(GSEventRegistration registration) {
        if (this._sequenceNumbers == null) {
            this._sequenceNumbers = new HashMap<Uuid, Long>();
        }
        this._sequenceNumbers.put(registration.getSpaceUID(), registration.getSequenceNumber());
    }

    public Map<Uuid, Long> getSequenceNumbers() {
        if (this._sequenceNumbers != null) {
            return this._sequenceNumbers;
        }
        HashMap<Uuid, Long> map = new HashMap<Uuid, Long>();
        map.put(this.getSpaceUID(), this.getSequenceNumber());
        return map;
    }

    public String toString() {
        return Textualizer.toString(this);
    }

    @Override
    public void toText(Textualizer textualizer) {
        textualizer.append("eventID", this.eventID);
        textualizer.append("source", this.source);
        textualizer.append("lease", this.lease);
        textualizer.append("seqNum", this.seqNum);
        textualizer.append("templateID", this._templateID);
        textualizer.append("spaceUID", this._spaceUID);
    }
}

