/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.events;

import com.gigaspaces.internal.collections.CollectionsFactory;
import com.gigaspaces.internal.collections.IntegerObjectMap;
import com.j_spaces.core.client.NotifyModifiers;

public class NotifyActionType {
    private static final IntegerObjectMap<NotifyActionType> values = CollectionsFactory.getInstance().createIntegerObjectMap();
    private int modifier;
    public static final NotifyActionType NOTIFY_NONE = new NotifyActionType(0);
    public static final NotifyActionType NOTIFY_UPDATE = new NotifyActionType(2);
    public static final NotifyActionType NOTIFY_WRITE = new NotifyActionType(1);
    public static final NotifyActionType NOTIFY_TAKE = new NotifyActionType(4);
    public static final NotifyActionType NOTIFY_LEASE_EXPIRATION = new NotifyActionType(8);
    public static final NotifyActionType NOTIFY_UNMATCHED = new NotifyActionType(32);
    public static final NotifyActionType NOTIFY_MATCHED_UPDATE = new NotifyActionType(64);
    public static final NotifyActionType NOTIFY_REMATCHED_UPDATE = new NotifyActionType(128);
    public static final NotifyActionType NOTIFY_WRITE_OR_UPDATE = NOTIFY_WRITE.or(NOTIFY_UPDATE);
    @Deprecated
    public static final NotifyActionType NOTIFY_ALL = new NotifyActionType(15);
    public static final NotifyActionType NOTIFY_MATCH_BY_ID = new NotifyActionType(16);

    private NotifyActionType(int modifier) {
        this(modifier, true);
    }

    private NotifyActionType(int modifier, boolean basic) {
        this.modifier = modifier;
        if (basic) {
            values.put(modifier, this);
        }
    }

    public static NotifyActionType fromModifier(int modifier) {
        NotifyActionType type = values.get(modifier);
        if (type == null) {
            type = new Set(modifier);
        }
        return type;
    }

    protected void setModifier(int modifier) {
        this.modifier = modifier;
    }

    public int getModifier() {
        return this.modifier;
    }

    public NotifyActionType or(NotifyActionType type) {
        Set set = new Set(this);
        set.or(type);
        return set;
    }

    public String toString() {
        return NotifyModifiers.toString(this.modifier);
    }

    public boolean isUpdate() {
        return this.isModifierSet(NOTIFY_UPDATE);
    }

    public boolean isUnmatched() {
        return this.isModifierSet(NOTIFY_UNMATCHED);
    }

    public boolean isMatchedUpdate() {
        return this.isModifierSet(NOTIFY_MATCHED_UPDATE);
    }

    public boolean isRematchedUpdate() {
        return this.isModifierSet(NOTIFY_REMATCHED_UPDATE);
    }

    public boolean isWrite() {
        return this.isModifierSet(NOTIFY_WRITE);
    }

    public boolean isTake() {
        return this.isModifierSet(NOTIFY_TAKE);
    }

    public boolean isMatchByID() {
        return this.isModifierSet(NOTIFY_MATCH_BY_ID);
    }

    public boolean isLeaseExpiration() {
        return this.isModifierSet(NOTIFY_LEASE_EXPIRATION);
    }

    private boolean isModifierSet(NotifyActionType modifier) {
        return (this.getModifier() & modifier.getModifier()) == modifier.getModifier();
    }

    private static class Set
    extends NotifyActionType {
        public Set(int modifier) {
            super(modifier, false);
        }

        private Set(NotifyActionType action) {
            this(action.getModifier());
        }

        @Override
        public Set or(NotifyActionType actionType) {
            this.setModifier(this.getModifier() | actionType.getModifier());
            return this;
        }
    }
}

