/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.events;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.events.EventSessionConfig;
import com.gigaspaces.events.NotifyActionType;
import com.gigaspaces.internal.client.cache.CustomInfo;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.server.space.redolog.storage.bytebuffer.ISwapExternalizable;
import com.gigaspaces.internal.utils.Textualizable;
import com.gigaspaces.internal.utils.Textualizer;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import com.gigaspaces.lrmi.LRMIInvocationContext;
import com.j_spaces.core.client.INotifyDelegatorFilter;
import com.j_spaces.core.client.Modifiers;
import com.j_spaces.core.client.NotifyModifiers;
import com.j_spaces.core.cluster.ClusterPolicy;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.rmi.MarshalledObject;
import net.jini.core.event.RemoteEventListener;
import net.jini.id.UuidFactory;

@InternalApi
public class NotifyInfo
implements Externalizable,
ISwapExternalizable,
Textualizable {
    private static final long serialVersionUID = 9213790201720650891L;
    private Boolean _replicateTemplate;
    private Boolean _triggerNotifyTemplate;
    private boolean _guaranteedNotifications;
    private boolean _broadcast;
    private boolean _returnOnlyUids;
    private Integer _batchSize;
    private Integer _batchPendingThreshold;
    private Long _batchTime;
    private int _notifyType;
    private int _modifiers;
    private String _templateUID;
    private RemoteEventListener _listener;
    private INotifyDelegatorFilter _filter;
    private MarshalledObject<?> _handback;
    private CustomInfo _customInfo;
    private static final short FLAG_IS_REPLICATE_SET = 1;
    private static final short FLAG_REPLICATE_NOTIFY = 2;
    private static final short FLAG_TRIGGER_NOTIFY_TEMPLATE = 4;
    private static final short FLAG_BATCH = 8;
    private static final short FLAG_MODIFIERS = 16;
    private static final short FLAG_HAND_BACK = 32;
    private static final short FLAG_FILTER = 64;
    private static final short FLAG_BROADCAST = 128;
    private static final short FLAG_TEMPLATE_UID = 256;
    private static final short FLAG_IS_TRIGGER_SET = 512;
    private static final short FLAG_GUARANTEED_NOTIFY = 1024;
    private static final short FLAG_RETURN_ONLY_UIDS = 2048;
    private static final short FLAG_CUSTOM_INFO = 4096;
    private static final short FLAG_FIFO = 16;

    public NotifyInfo() {
    }

    public NotifyInfo(RemoteEventListener listener, int notifyType) {
        this(listener, notifyType, false, null);
    }

    public NotifyInfo(RemoteEventListener listener, int notifyType, boolean fifo) {
        this(listener, notifyType, fifo, null);
    }

    public NotifyInfo(RemoteEventListener listener, int notifyType, boolean fifo, MarshalledObject<?> handback) {
        this._listener = listener;
        this._notifyType = notifyType;
        this.setFifo(fifo);
        this._handback = handback;
    }

    public NotifyInfo(RemoteEventListener listener, NotifyActionType notifyType, EventSessionConfig config, MarshalledObject<?> handback, INotifyDelegatorFilter filter) {
        this(listener, notifyType.getModifier(), config.isFifo(), handback);
        this._filter = filter;
        this._replicateTemplate = config.isReplicateNotifyTemplate();
        this._triggerNotifyTemplate = config.isTriggerNotifyTemplate();
        this._guaranteedNotifications = config.isGuaranteedNotifications();
        if (config.isBatching()) {
            this._batchSize = config.getBatchSize();
            this._batchTime = config.getBatchTime();
            this._batchPendingThreshold = config.getBatchPendingThreshold();
        }
    }

    public NotifyInfo(RemoteEventListener listener, NotifyInfo notifyInfo) {
        this._replicateTemplate = notifyInfo._replicateTemplate;
        this._triggerNotifyTemplate = notifyInfo._triggerNotifyTemplate;
        this._guaranteedNotifications = notifyInfo._guaranteedNotifications;
        this._broadcast = notifyInfo._broadcast;
        this._returnOnlyUids = notifyInfo._returnOnlyUids;
        this._modifiers = notifyInfo._modifiers;
        this._batchSize = notifyInfo._batchSize;
        this._batchPendingThreshold = notifyInfo._batchPendingThreshold;
        this._batchTime = notifyInfo._batchTime;
        this._notifyType = notifyInfo._notifyType;
        this._templateUID = notifyInfo._templateUID;
        this._listener = listener;
        this._filter = notifyInfo._filter;
        this._handback = notifyInfo._handback;
    }

    public String toString() {
        return Textualizer.toString(this);
    }

    @Override
    public void toText(Textualizer textualizer) {
        textualizer.append("notifyType", this._notifyType);
        textualizer.append("templateUid", this._templateUID);
        textualizer.append("broadcast", this._broadcast);
        textualizer.append("fifo", this.isFifo());
        textualizer.append("returnOnlyUids", this._returnOnlyUids);
        textualizer.append("batchSize", this._batchSize);
        textualizer.append("batchPendingThreshold", this._batchPendingThreshold);
        textualizer.append("batchTime", this._batchTime);
        textualizer.append("replicateTemplate", this._replicateTemplate);
        textualizer.append("triggerNotifyTemplate", this._triggerNotifyTemplate);
        textualizer.append("guaranteed", this._guaranteedNotifications);
        textualizer.append("handback", this._handback);
        textualizer.append("returnPrevValue", this.isReturnPrevValue());
    }

    public Boolean getReplicateTemplate() {
        return this._replicateTemplate;
    }

    public void setReplicateTemplate(Boolean replicateTemplate) {
        this._replicateTemplate = replicateTemplate;
    }

    public Boolean getNotifyTemplate() {
        return this._triggerNotifyTemplate;
    }

    public void setNotifyTemplate(Boolean notifyTemplate) {
        this._triggerNotifyTemplate = notifyTemplate;
    }

    public boolean isGuaranteedNotifications() {
        return this._guaranteedNotifications;
    }

    public void setGuaranteedNotifications(boolean guaranteedNotifications) {
        this._guaranteedNotifications = guaranteedNotifications;
    }

    public boolean isBroadcast() {
        return this._broadcast;
    }

    public void setBroadcast(boolean broadcast) {
        this._broadcast = broadcast;
    }

    public boolean isReturnOnlyUids() {
        return this._returnOnlyUids;
    }

    public NotifyInfo setReturnOnlyUids(boolean returnOnlyUids) {
        this._returnOnlyUids = returnOnlyUids;
        return this;
    }

    public boolean isFifo() {
        return Modifiers.contains(this._modifiers, 2048);
    }

    public void setFifo(boolean fifo) {
        this._modifiers = fifo ? Modifiers.add(this._modifiers, 2048) : Modifiers.remove(this._modifiers, 2048);
    }

    public boolean isReturnPrevValue() {
        return Modifiers.contains(this._modifiers, 0x8000000);
    }

    public void setReturnPrevValue(boolean returnPrevValue) {
        this._modifiers = returnPrevValue ? Modifiers.add(this._modifiers, 0x8000000) : Modifiers.remove(this._modifiers, 0x8000000);
    }

    public int getNotifyType() {
        return this._notifyType;
    }

    public void setNotifyType(int notifyType) {
        this._notifyType = notifyType;
    }

    public int getModifiers() {
        return this._modifiers;
    }

    public void setModifiers(int modifiers) {
        this._modifiers = modifiers;
    }

    public String getTemplateUID() {
        return this._templateUID;
    }

    public void setTemplateUID(String templateUID) {
        this._templateUID = templateUID;
    }

    public String getOrInitTemplateUID() {
        if (this._templateUID == null) {
            this._templateUID = UuidFactory.generate().toString();
        }
        return this._templateUID;
    }

    public RemoteEventListener getListener() {
        return this._listener;
    }

    public void setListener(RemoteEventListener listener) {
        this._listener = listener;
    }

    public INotifyDelegatorFilter getFilter() {
        return this._filter;
    }

    public void setFilter(INotifyDelegatorFilter filter) {
        this._filter = filter;
    }

    public MarshalledObject<?> getHandback() {
        return this._handback;
    }

    public void setHandback(MarshalledObject<?> handback) {
        this._handback = handback;
    }

    public CustomInfo getCustomInfo() {
        return this._customInfo;
    }

    public NotifyInfo setCustomInfo(CustomInfo customInfo) {
        this._customInfo = customInfo;
        return this;
    }

    public boolean isBatching() {
        return this._batchSize != null && this._batchTime != null && this._batchPendingThreshold != null;
    }

    public int getBatchSize() {
        return this._batchSize != null ? this._batchSize : -1;
    }

    public long getBatchTime() {
        return this._batchTime != null ? this._batchTime : -1L;
    }

    public int getBatchPendingThreshold() {
        return this._batchPendingThreshold != null ? this._batchPendingThreshold : -1;
    }

    public void setBatchParams(int size, long time, int pendingThreshold) {
        this._batchSize = size;
        this._batchTime = time;
        this._batchPendingThreshold = pendingThreshold;
    }

    public void applyDefaults(ClusterPolicy clusterPolicy) {
        if (this._triggerNotifyTemplate == null) {
            this._triggerNotifyTemplate = clusterPolicy != null && clusterPolicy.m_ReplicationPolicy != null ? Boolean.valueOf(clusterPolicy.m_ReplicationPolicy.m_TriggerNotifyTemplates) : Boolean.valueOf(false);
        }
        if (this._replicateTemplate == null) {
            this._replicateTemplate = clusterPolicy != null && clusterPolicy.m_ReplicationPolicy != null ? Boolean.valueOf(clusterPolicy.m_ReplicationPolicy.m_ReplicateNotifyTemplates) : Boolean.valueOf(false);
        }
    }

    public void validateModifiers() {
        if ((NotifyModifiers.isRematchedUpdate(this._notifyType) || NotifyModifiers.isMatchedUpdate(this._notifyType)) && NotifyModifiers.isUpdate(this._notifyType)) {
            throw new IllegalArgumentException(NotifyActionType.NOTIFY_MATCHED_UPDATE + " or " + NotifyActionType.NOTIFY_REMATCHED_UPDATE + " modifiers cannot be used with " + NotifyActionType.NOTIFY_UPDATE + " modifier for the same notify template");
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        PlatformLogicalVersion version = LRMIInvocationContext.getEndpointLogicalVersion();
        if (version.greaterOrEquals(PlatformLogicalVersion.v9_5_0)) {
            this.serialize(out, false);
        } else {
            this.writeExternalV9_0_2(out);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        PlatformLogicalVersion version = LRMIInvocationContext.getEndpointLogicalVersion();
        if (version.greaterOrEquals(PlatformLogicalVersion.v9_5_0)) {
            this.deserialize(in, false);
        } else {
            this.readExternalV9_0_2(in);
        }
    }

    public void writeToSwap(ObjectOutput out) throws IOException {
        this.serialize(out, true);
    }

    public void readFromSwap(ObjectInput in) throws IOException, ClassNotFoundException {
        this.deserialize(in, true);
    }

    private void serialize(ObjectOutput out, boolean swap) throws IOException {
        this.writeExternalV9_5_0(out);
    }

    private void writeExternalV9_5_0(ObjectOutput out) throws IOException {
        short flags = this.buildFlagsV9_5_0();
        out.writeShort(flags);
        out.writeInt(this._notifyType);
        out.writeObject(this._listener);
        if (this._modifiers != 0) {
            out.writeInt(this._modifiers);
        }
        if (this._templateUID != null) {
            IOUtils.writeString(out, this._templateUID);
        }
        if (this._filter != null) {
            out.writeObject(this._filter);
        }
        if (this._handback != null) {
            if (out instanceof ObjectOutputStream) {
                ((ObjectOutputStream)out).writeUnshared(this._handback);
            } else {
                out.writeObject(this._handback);
            }
        }
        if ((flags & 8) != 0) {
            out.writeInt(this._batchSize);
            out.writeLong(this._batchTime);
            out.writeInt(this._batchPendingThreshold);
        }
        if (this._customInfo != null) {
            IOUtils.writeObject(out, this._customInfo);
        }
    }

    private void writeExternalV9_0_2(ObjectOutput out) throws IOException {
        short flags = this.buildFlagsV9_0_2();
        out.writeShort(flags);
        out.writeInt(this._notifyType);
        out.writeObject(this._listener);
        if (this._modifiers != 0) {
            out.writeInt(this._modifiers);
        }
        if (this._templateUID != null) {
            IOUtils.writeString(out, this._templateUID);
        }
        if (this._filter != null) {
            out.writeObject(this._filter);
        }
        if (this._handback != null) {
            if (out instanceof ObjectOutputStream) {
                ((ObjectOutputStream)out).writeUnshared(this._handback);
            } else {
                out.writeObject(this._handback);
            }
        }
        if ((flags & 8) != 0) {
            out.writeInt(this._batchSize);
            out.writeLong(this._batchTime);
            out.writeInt(this._batchPendingThreshold);
        }
    }

    private void deserialize(ObjectInput in, boolean swap) throws IOException, ClassNotFoundException {
        this.readExternalV9_5_0(in);
    }

    private void readExternalV9_5_0(ObjectInput in) throws IOException, ClassNotFoundException {
        short flags = in.readShort();
        this._notifyType = in.readInt();
        this._listener = (RemoteEventListener)in.readObject();
        if ((flags & 0x10) != 0) {
            this._modifiers = in.readInt();
        }
        if ((flags & 0x100) != 0) {
            this._templateUID = IOUtils.readString(in);
        }
        if ((flags & 0x40) != 0) {
            this._filter = (INotifyDelegatorFilter)in.readObject();
        }
        if ((flags & 0x20) != 0) {
            this._handback = in instanceof ObjectInputStream ? (MarshalledObject)((ObjectInputStream)in).readUnshared() : (MarshalledObject)in.readObject();
        }
        if ((flags & 8) != 0) {
            this._batchSize = in.readInt();
            this._batchTime = in.readLong();
            this._batchPendingThreshold = in.readInt();
        }
        if ((flags & 0x1000) != 0) {
            this._customInfo = (CustomInfo)IOUtils.readObject(in);
        }
        this._broadcast = (flags & 0x80) != 0;
        this._guaranteedNotifications = (flags & 0x400) != 0;
        boolean bl = this._returnOnlyUids = (flags & 0x800) != 0;
        if ((flags & 1) != 0) {
            this._replicateTemplate = (flags & 2) != 0;
        }
        if ((flags & 0x200) != 0) {
            this._triggerNotifyTemplate = (flags & 4) != 0;
        }
    }

    private void readExternalV9_0_2(ObjectInput in) throws IOException, ClassNotFoundException {
        short flags = in.readShort();
        this._notifyType = in.readInt();
        this._listener = (RemoteEventListener)in.readObject();
        if ((flags & 0x10) != 0) {
            this._modifiers = in.readInt();
        }
        if ((flags & 0x100) != 0) {
            this._templateUID = IOUtils.readString(in);
        }
        if ((flags & 0x40) != 0) {
            this._filter = (INotifyDelegatorFilter)in.readObject();
        }
        if ((flags & 0x20) != 0) {
            this._handback = in instanceof ObjectInputStream ? (MarshalledObject)((ObjectInputStream)in).readUnshared() : (MarshalledObject)in.readObject();
        }
        if ((flags & 8) != 0) {
            this._batchSize = in.readInt();
            this._batchTime = in.readLong();
            this._batchPendingThreshold = in.readInt();
        }
        this._broadcast = (flags & 0x80) != 0;
        this._guaranteedNotifications = (flags & 0x400) != 0;
        boolean bl = this._returnOnlyUids = (flags & 0x800) != 0;
        if ((flags & 1) != 0) {
            this._replicateTemplate = (flags & 2) != 0;
        }
        if ((flags & 0x200) != 0) {
            this._triggerNotifyTemplate = (flags & 4) != 0;
        }
    }

    private short buildFlagsV9_5_0() {
        short flags = 0;
        if (this._replicateTemplate != null) {
            flags = (short)(flags | 1);
            if (this._replicateTemplate.booleanValue()) {
                flags = (short)(flags | 2);
            }
        }
        if (this._triggerNotifyTemplate != null) {
            flags = (short)(flags | 0x200);
            if (this._triggerNotifyTemplate.booleanValue()) {
                flags = (short)(flags | 4);
            }
        }
        if (this._batchSize != null && this._batchTime != null && this._batchPendingThreshold != null) {
            flags = (short)(flags | 8);
        }
        if (this._modifiers != 0) {
            flags = (short)(flags | 0x10);
        }
        if (this._returnOnlyUids) {
            flags = (short)(flags | 0x800);
        }
        if (this._handback != null) {
            flags = (short)(flags | 0x20);
        }
        if (this._filter != null) {
            flags = (short)(flags | 0x40);
        }
        if (this._broadcast) {
            flags = (short)(flags | 0x80);
        }
        if (this._templateUID != null) {
            flags = (short)(flags | 0x100);
        }
        if (this._guaranteedNotifications) {
            flags = (short)(flags | 0x400);
        }
        if (this._customInfo != null) {
            flags = (short)(flags | 0x1000);
        }
        return flags;
    }

    private short buildFlagsV9_0_2() {
        short flags = 0;
        if (this._replicateTemplate != null) {
            flags = (short)(flags | 1);
            if (this._replicateTemplate.booleanValue()) {
                flags = (short)(flags | 2);
            }
        }
        if (this._triggerNotifyTemplate != null) {
            flags = (short)(flags | 0x200);
            if (this._triggerNotifyTemplate.booleanValue()) {
                flags = (short)(flags | 4);
            }
        }
        if (this._batchSize != null && this._batchTime != null && this._batchPendingThreshold != null) {
            flags = (short)(flags | 8);
        }
        if (this._modifiers != 0) {
            flags = (short)(flags | 0x10);
        }
        if (this._returnOnlyUids) {
            flags = (short)(flags | 0x800);
        }
        if (this._handback != null) {
            flags = (short)(flags | 0x20);
        }
        if (this._filter != null) {
            flags = (short)(flags | 0x40);
        }
        if (this._broadcast) {
            flags = (short)(flags | 0x80);
        }
        if (this._templateUID != null) {
            flags = (short)(flags | 0x100);
        }
        if (this._guaranteedNotifications) {
            flags = (short)(flags | 0x400);
        }
        return flags;
    }

    private short buildFlagsV9_0_0() {
        short flags = 0;
        if (this._replicateTemplate != null) {
            flags = (short)(flags | 1);
            if (this._replicateTemplate.booleanValue()) {
                flags = (short)(flags | 2);
            }
        }
        if (this._triggerNotifyTemplate != null) {
            flags = (short)(flags | 0x200);
            if (this._triggerNotifyTemplate.booleanValue()) {
                flags = (short)(flags | 4);
            }
        }
        if (this._batchSize != null && this._batchTime != null && this._batchPendingThreshold != null) {
            flags = (short)(flags | 8);
        }
        if (this.isFifo()) {
            flags = (short)(flags | 0x10);
        }
        if (this._returnOnlyUids) {
            flags = (short)(flags | 0x800);
        }
        if (this._handback != null) {
            flags = (short)(flags | 0x20);
        }
        if (this._filter != null) {
            flags = (short)(flags | 0x40);
        }
        if (this._broadcast) {
            flags = (short)(flags | 0x80);
        }
        if (this._templateUID != null) {
            flags = (short)(flags | 0x100);
        }
        if (this._guaranteedNotifications) {
            flags = (short)(flags | 0x400);
        }
        return flags;
    }
}

