/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.events.batching;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.client.EntryArrivedRemoteEvent;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import net.jini.core.event.RemoteEvent;

@InternalApi
public class BatchRemoteEvent
extends EntryArrivedRemoteEvent {
    private static final long serialVersionUID = 224729391815755896L;
    private RemoteEvent[] _events;

    public BatchRemoteEvent() {
    }

    public BatchRemoteEvent(RemoteEvent[] events) {
        this._events = events;
        EntryArrivedRemoteEvent firstEvent = (EntryArrivedRemoteEvent)events[0];
        this._templateUID = firstEvent.getTemplateUID();
        this.eventID = firstEvent.getID();
        this.setSpaceProxyUuid(firstEvent.getSpaceUuid());
    }

    public RemoteEvent[] getEvents() {
        return this._events;
    }

    @Override
    public void setSpaceProxy(IJSpace spaceProxy) {
        this._spaceProxy = spaceProxy;
        for (int i = 0; i < this._events.length; ++i) {
            EntryArrivedRemoteEvent event = (EntryArrivedRemoteEvent)this._events[i];
            event.setSpaceProxy(spaceProxy);
        }
    }

    @Override
    protected void writeExternal(ObjectOutput out, PlatformLogicalVersion version) throws IOException {
        super.writeExternal(out, version);
        if (this._events != null) {
            out.writeInt(this._events.length);
            for (RemoteEvent event : this._events) {
                out.writeObject(event);
            }
        } else {
            out.writeInt(-1);
        }
    }

    @Override
    protected void readExternal(ObjectInput in, PlatformLogicalVersion version) throws IOException, ClassNotFoundException {
        super.readExternal(in, version);
        int size = in.readInt();
        if (size > -1) {
            this._events = new RemoteEvent[size];
            for (int i = 0; i < size; ++i) {
                this._events[i] = (RemoteEvent)in.readObject();
            }
        }
    }

    @Override
    public String getLRMIMethodTrackingId() {
        return "notify batch";
    }
}

