/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.events.fifo;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.events.NotifyInfo;
import com.gigaspaces.events.batching.BatchRemoteEvent;
import com.gigaspaces.events.batching.BatchRemoteEventListener;
import com.gigaspaces.internal.backport.java.util.concurrent.FastConcurrentSkipListMap;
import com.gigaspaces.internal.utils.concurrent.RunnableContextClassLoaderDecorator;
import com.j_spaces.core.client.EntryArrivedRemoteEvent;
import com.j_spaces.kernel.SizeConcurrentHashMap;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.LockSupport;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.event.RemoteEvent;
import net.jini.core.event.RemoteEventListener;
import net.jini.core.event.UnknownEventException;
import net.jini.id.Uuid;

@InternalApi
public class BlockedOrderedQueue {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.client");
    private final ConcurrentHashMap<Uuid, SingleProducer> _producers = new ConcurrentHashMap();
    private volatile ConcurrentLinkedQueue<Uuid> _readyEvents = new ConcurrentLinkedQueue();
    private volatile AtomicBoolean _inProgress = new AtomicBoolean(false);
    private final ExecutorService _pool;
    private final long _maxCapacity;
    private Map<Uuid, Long> _initialSeqNumbers = null;
    private volatile boolean _interrupted = false;
    private final NotifyFifoTask _notifyFifoTask;

    public BlockedOrderedQueue(RemoteEventListener listener, ExecutorService threadPool, long maxCapacity, NotifyInfo info) {
        this._notifyFifoTask = info.getBatchSize() > 0 && listener instanceof BatchRemoteEventListener ? new BatchNotifyFifoTask((BatchRemoteEventListener)listener, info.getBatchSize()) : new NotifyFifoTask(listener);
        this._maxCapacity = maxCapacity;
        this._pool = threadPool;
    }

    private long getInitialSequenceNumber(Uuid uuid) {
        if (this._initialSeqNumbers == null) {
            return 0L;
        }
        Long initialSeqNum = this._initialSeqNumbers.get(uuid);
        if (initialSeqNum == null) {
            initialSeqNum = 0L;
            this._initialSeqNumbers.put(uuid, initialSeqNum);
        }
        return initialSeqNum;
    }

    public void enqueue(RemoteEvent theEvent) {
        EntryArrivedRemoteEvent event = (EntryArrivedRemoteEvent)theEvent;
        SingleProducer producer = this.getProducer(event);
        while (!this._interrupted && !this.tryInsert(event)) {
            Thread currentThread = Thread.currentThread();
            producer.orderedThreadEventsMap.put(theEvent.getSequenceNumber(), currentThread);
            if (this.tryInsert(event)) {
                producer.orderedThreadEventsMap.remove(theEvent.getSequenceNumber());
                break;
            }
            if (this._interrupted) continue;
            LockSupport.park();
        }
    }

    private SingleProducer getProducer(EntryArrivedRemoteEvent event) {
        Uuid uuid = event.getSpaceUuid();
        return this.getProducer(uuid);
    }

    private SingleProducer getProducer(Uuid uuid) {
        SingleProducer prev;
        SingleProducer producer = this._producers.get(uuid);
        long initialSeqNumber = this.getInitialSequenceNumber(uuid);
        if (producer == null && (prev = this._producers.putIfAbsent(uuid, producer = new SingleProducer(initialSeqNumber))) != null) {
            producer = prev;
        }
        return producer;
    }

    private boolean tryInsert(EntryArrivedRemoteEvent theEvent) {
        SingleProducer producer = this.getProducer(theEvent);
        long max = producer.maxInQueue.get();
        long sequenceNumber = theEvent.getSequenceNumber();
        if (sequenceNumber < max || (long)producer.orderedEventsMap.size() < this._maxCapacity) {
            boolean updateMax = false;
            while (!updateMax && ((updateMax = producer.maxInQueue.compareAndSet(max, Math.max(max, sequenceNumber))) || sequenceNumber >= (max = producer.maxInQueue.get()))) {
            }
            producer.orderedEventsMap.put(sequenceNumber, theEvent);
            boolean isNextInOrder = producer.nextInProducerOrder.compareAndSet(sequenceNumber, sequenceNumber + 1L);
            if (isNextInOrder) {
                this.handleReadyEvent(producer, theEvent.getSpaceUuid());
                for (long i = sequenceNumber + 1L; i <= producer.maxInQueue.get() && producer.orderedEventsMap.containsKey(i); ++i) {
                    boolean succeeded = producer.nextInProducerOrder.compareAndSet(i, i + 1L);
                    if (!succeeded) continue;
                    this.handleReadyEvent(producer, theEvent.getSpaceUuid());
                }
            }
            return true;
        }
        return false;
    }

    public RemoteEvent dequeue() {
        Uuid uuid = this._readyEvents.poll();
        if (uuid == null) {
            return null;
        }
        SingleProducer producer = this.getProducer(uuid);
        return producer.popNextReadyEvent();
    }

    private boolean hasReadyEvents() {
        return !this._readyEvents.isEmpty();
    }

    private void submitNewTask() {
        this._pool.execute(new RunnableContextClassLoaderDecorator(Thread.currentThread().getContextClassLoader(), this._notifyFifoTask));
    }

    private void handleReadyEvent(SingleProducer producer, Uuid uuid) {
        Map.Entry<Long, Thread> entry;
        this._readyEvents.offer(uuid);
        if (this._inProgress.compareAndSet(false, true)) {
            this.submitNewTask();
        }
        if (this._maxCapacity < Long.MAX_VALUE && (entry = producer.orderedThreadEventsMap.pollFirstEntry()) != null) {
            LockSupport.unpark(entry.getValue());
        }
    }

    public void interrupt() {
        this._interrupted = true;
        for (SingleProducer producer : this._producers.values()) {
            Iterator<Thread> threads = producer.orderedThreadEventsMap.values().iterator();
            while (threads.hasNext()) {
                LockSupport.unpark(threads.next());
                threads.remove();
            }
        }
    }

    public void setInitialSeqNumbers(Map<Uuid, Long> initialSeqNumbers) {
        this._initialSeqNumbers = initialSeqNumbers;
    }

    private class BatchNotifyFifoTask
    extends NotifyFifoTask {
        private final BatchRemoteEventListener _batchListener;
        private final int _batchMaxSize;

        BatchNotifyFifoTask(BatchRemoteEventListener listener, int batchMaxSize) {
            super(listener);
            this._batchListener = listener;
            this._batchMaxSize = batchMaxSize;
        }

        @Override
        protected void dequeueAndTrigger() {
            RemoteEvent theEvent;
            ArrayList<RemoteEvent> eventsList = new ArrayList<RemoteEvent>();
            for (int i = 0; i < this._batchMaxSize && (theEvent = BlockedOrderedQueue.this.dequeue()) != null; ++i) {
                eventsList.add(theEvent);
            }
            if (eventsList.size() > 0) {
                try {
                    this._batchListener.notifyBatch(new BatchRemoteEvent(eventsList.toArray(new RemoteEvent[eventsList.size()])));
                }
                catch (UnknownEventException e) {
                    _logger.log(Level.FINE, "Cant deliver notification to listener", e);
                }
                catch (RemoteException e) {
                    _logger.log(Level.FINE, "Cant deliver notification to listener", e);
                }
                catch (Throwable e) {
                    _logger.log(Level.SEVERE, "Notification was send but user listener throws exception", e);
                }
            }
        }
    }

    private class NotifyFifoTask
    implements Runnable {
        private final RemoteEventListener _listener;

        public NotifyFifoTask(RemoteEventListener listener) {
            this._listener = listener;
        }

        @Override
        public void run() {
            this.dequeueAndTrigger();
            if (BlockedOrderedQueue.this.hasReadyEvents()) {
                BlockedOrderedQueue.this.submitNewTask();
            } else {
                BlockedOrderedQueue.this._inProgress.set(false);
                if (BlockedOrderedQueue.this.hasReadyEvents() && BlockedOrderedQueue.this._inProgress.compareAndSet(false, true)) {
                    BlockedOrderedQueue.this.submitNewTask();
                }
            }
        }

        protected void dequeueAndTrigger() {
            RemoteEvent theEvent = BlockedOrderedQueue.this.dequeue();
            if (theEvent != null) {
                try {
                    this._listener.notify(theEvent);
                }
                catch (UnknownEventException e) {
                    _logger.log(Level.FINE, "Cant deliver notification to listener", e);
                }
                catch (RemoteException e) {
                    _logger.log(Level.FINE, "Cant deliver notification to listener", e);
                }
                catch (Throwable e) {
                    _logger.log(Level.SEVERE, "Notification was send but user listener throws exception", e);
                }
            }
        }
    }

    private static class SingleProducer {
        public final SizeConcurrentHashMap<Long, RemoteEvent> orderedEventsMap = new SizeConcurrentHashMap();
        public final FastConcurrentSkipListMap<Long, Thread> orderedThreadEventsMap = new FastConcurrentSkipListMap();
        public final AtomicLong nextInProducerOrder;
        public final AtomicLong nextInConsumerOrder;
        public final AtomicLong maxInQueue = new AtomicLong(Long.MIN_VALUE);

        public SingleProducer(long initialSeqNumber) {
            this.nextInProducerOrder = new AtomicLong(initialSeqNumber);
            this.nextInConsumerOrder = new AtomicLong(initialSeqNumber);
        }

        public RemoteEvent popNextReadyEvent() {
            return this.orderedEventsMap.remove(this.nextInConsumerOrder.getAndIncrement());
        }
    }
}

