/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.events.lease;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.events.EventSessionConfig;
import com.gigaspaces.events.lease.EventLeaseRenewalManager;
import com.gigaspaces.time.SystemTime;
import net.jini.core.event.EventRegistration;
import net.jini.core.lease.UnknownLeaseException;
import net.jini.lease.LeaseListener;
import net.jini.lease.LeaseRenewalManager;

@InternalApi
public class JiniEventLeaseRenewalManager
implements EventLeaseRenewalManager {
    private final EventSessionConfig config;
    private final LeaseRenewalManager leaseRenewalManager;

    public JiniEventLeaseRenewalManager(EventSessionConfig config) {
        this.config = config;
        this.leaseRenewalManager = new LeaseRenewalManager(config.getRenewRTT(), 2L);
    }

    @Override
    public boolean supportsCustomLease() {
        return true;
    }

    @Override
    public void close() {
        this.leaseRenewalManager.terminate();
    }

    @Override
    public long getRenewalDuration() {
        return this.config.getRenewDuration();
    }

    @Override
    public void registerAutoRenew(EventRegistration eventRegistration, LeaseListener listener) {
        long systemTime = SystemTime.timeMillis();
        long desiredExpiration = systemTime < Long.MAX_VALUE - this.config.getRenewExpiration() ? systemTime + this.config.getRenewExpiration() : Long.MAX_VALUE;
        this.leaseRenewalManager.renewUntil(eventRegistration.getLease(), desiredExpiration, this.config.getRenewDuration(), listener);
    }

    @Override
    public void unregisterAutoRenew(EventRegistration eventRegistration) {
        try {
            this.leaseRenewalManager.remove(eventRegistration.getLease());
        }
        catch (UnknownLeaseException unknownLeaseException) {
            // empty catch block
        }
    }
}

