/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.grid.zone;

import com.gigaspaces.api.InternalApi;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.StringTokenizer;

@InternalApi
public class ZoneHelper {
    private static final String ZONE_PROPERTY = "com.gs.zones";

    public static String[] getSystemZones() {
        String zones = System.getProperty(ZONE_PROPERTY);
        if (zones == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(zones, ",");
        ArrayList<String> zonesList = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String zone = st.nextToken();
            if (zone == null || zone.length() <= 0) continue;
            zonesList.add(zone);
        }
        return zonesList.toArray(new String[zonesList.size()]);
    }

    public static boolean zoneExists(String zoneToFind, String[] zones) {
        if (zones == null) {
            return false;
        }
        for (String zone : zones) {
            if (!zone.equals(zoneToFind)) continue;
            return true;
        }
        return false;
    }

    public static String unparse(Map<String, Integer> maxInstancesPerZone) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Integer> entry : maxInstancesPerZone.entrySet()) {
            sb.append(entry.getKey()).append("/").append(entry.getValue()).append(',');
        }
        return sb.toString();
    }

    public static Map<String, Integer> parse(String maxInstancesPerZone) {
        if (maxInstancesPerZone == null) {
            return null;
        }
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        StringTokenizer st = new StringTokenizer(maxInstancesPerZone, ",");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token == null || token.length() <= 0) continue;
            int index = token.indexOf(47);
            if (index == -1) {
                result.put(token, 1);
                continue;
            }
            result.put(token.substring(0, index), Integer.parseInt(token.substring(index + 1)));
        }
        return result;
    }

    public static LinkedHashSet<String> parseZones(String zone) {
        LinkedHashSet<String> zones = new LinkedHashSet<String>();
        if (zone != null) {
            String[] zonesArr;
            for (String z : zonesArr = zone.split(",")) {
                zones.add(z.trim());
            }
        }
        return zones;
    }
}

