/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.classloader;

import com.gigaspaces.internal.classloader.ClassLoaderCache;
import com.gigaspaces.internal.classloader.IClassLoaderCacheStateListener;
import com.gigaspaces.internal.exceptions.IllegalArgumentNullException;
import com.gigaspaces.internal.utils.collections.CopyOnUpdateMap;
import com.gigaspaces.metadata.SpaceMetadataException;
import com.j_spaces.kernel.ClassLoaderHelper;
import java.util.Map;

public abstract class AbstractClassRepository<T>
implements IClassLoaderCacheStateListener {
    private final CopyOnUpdateMap<Long, Map<String, T>> _cache = new CopyOnUpdateMap();

    protected AbstractClassRepository() {
        ClassLoaderCache.getCache().registerCacheStateListener(this);
    }

    @Override
    public void onClassLoaderRemoved(Long classLoaderKey, boolean explicit) {
        this._cache.remove(classLoaderKey);
    }

    public T getByType(Class<?> type) {
        if (type == null) {
            throw new IllegalArgumentNullException("type");
        }
        return this.get(type, type.getName(), null, true, true);
    }

    public T getByName(String typeName) {
        return this.get(null, typeName, null, true, false);
    }

    public T getByName(String typeName, Object context) {
        return this.get(null, typeName, context, false, false);
    }

    public T getByNameIfExists(String typeName) {
        return this.get(null, typeName, null, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T get(Class<?> type, String typeName, Object context, boolean throwIfNotExists, boolean localOnly) {
        T result;
        CopyOnUpdateMap temp;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Long classLoaderKey = classLoader != null ? ClassLoaderCache.getCache().putClassLoader(classLoader) : -1L;
        CopyOnUpdateMap classLoaderMap = this._cache.get(classLoaderKey);
        if (classLoaderMap == null && (classLoaderMap = (CopyOnUpdateMap)this._cache.putIfAbsent(classLoaderKey, temp = new CopyOnUpdateMap())) == null) {
            classLoaderMap = temp;
        }
        if ((result = classLoaderMap.get(typeName)) != null) {
            return result;
        }
        CopyOnUpdateMap copyOnUpdateMap = classLoaderMap;
        synchronized (copyOnUpdateMap) {
            return (T)this.safeGet(type, typeName, context, classLoaderMap, throwIfNotExists, localOnly);
        }
    }

    private T safeGet(Class<?> type, String typeName, Object context, Map<String, T> classLoaderMap, boolean throwIfNotExists, boolean localOnly) {
        Class<?> superType;
        T result = classLoaderMap.get(typeName);
        if (result != null) {
            return result;
        }
        if (type == null) {
            try {
                type = ClassLoaderHelper.loadClass(typeName, localOnly);
            }
            catch (ClassNotFoundException e) {
                if (throwIfNotExists) {
                    throw new SpaceMetadataException("Unable to load type [" + typeName + "]", e);
                }
                return null;
            }
        }
        T superTypeInfo = (superType = type.getSuperclass()) != null ? (T)this.safeGet(superType, superType.getName(), context, classLoaderMap, true, localOnly) : null;
        result = this.create(type, superTypeInfo, context);
        classLoaderMap.put(typeName, result);
        return result;
    }

    protected abstract T create(Class<?> var1, T var2, Object var3);
}

