/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.classloader;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.classloader.IClassLoaderCacheStateListener;
import com.gigaspaces.internal.utils.collections.CopyOnUpdateMap;
import com.gigaspaces.internal.utils.collections.SelfCleaningTable;
import com.gigaspaces.time.SystemTime;
import com.j_spaces.kernel.ClassLoaderHelper;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class ClassLoaderCache
implements SelfCleaningTable.ICleanerListener<Long> {
    private static final ClassLoaderCache _cache = new ClassLoaderCache(60000L);
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.core.classloadercache");
    private final CopyOnUpdateMap<Long, ClassLoaderContext> _classLoaders;
    private final SelfCleaningTable<ClassLoader, Long> _classLoaderToIdMap;
    private final CopyOnWriteArraySet<WeakReference<IClassLoaderCacheStateListener>> _listeners;
    private final AtomicLong _classLoaderKeyGenerator = new AtomicLong();
    private final Object _lock = new Object();
    private final long _removedRelevantWindow;

    protected ClassLoaderCache(long removedRelevantWindow) {
        this._removedRelevantWindow = removedRelevantWindow;
        this._classLoaders = new CopyOnUpdateMap();
        this._classLoaderToIdMap = new SelfCleaningTable("ClassLoaderCache", this, new CopyOnUpdateMap());
        this._listeners = new CopyOnWriteArraySet();
    }

    public static ClassLoaderCache getCache() {
        return _cache;
    }

    public void shutdown() {
        this._classLoaderToIdMap.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long putClassLoader(ClassLoader classLoader) {
        if (classLoader == null) {
            throw new IllegalArgumentException("Argument cannot be null - 'classLoader'.");
        }
        Long previousId = this._classLoaderToIdMap.get(classLoader);
        if (previousId != null) {
            return previousId;
        }
        Object object = this._lock;
        synchronized (object) {
            previousId = this._classLoaderToIdMap.get(classLoader);
            if (previousId != null) {
                return previousId;
            }
            this.removeMarkers();
            long id = this.generateClassLoaderKey();
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("introducing new class loader to cache [" + ClassLoaderHelper.getClassLoaderLogName(classLoader) + "] to the class provider, class loader designated id is " + id);
            }
            this._classLoaders.put(id, new ClassLoaderContext(classLoader, Represent.REGULAR));
            this._classLoaderToIdMap.put(classLoader, id);
            return id;
        }
    }

    private void removeMarkers() {
        long currentTime = SystemTime.timeMillis();
        for (Map.Entry<Long, ClassLoaderContext> entry : this._classLoaders.entrySet()) {
            if (currentTime - entry.getValue().getTimeStamp() <= this._removedRelevantWindow || entry.getValue().getRepresents() != Represent.REMOVED_EXPLICIT && entry.getValue().getRepresents() != Represent.REMOVED_IMPLICIT) continue;
            this._classLoaders.remove(entry.getKey());
        }
    }

    public ClassLoader getClassLoader(Long key) {
        ClassLoaderContext classLoaderContext = this._classLoaders.get(key);
        if (classLoaderContext == null) {
            return null;
        }
        WeakReference<ClassLoader> weakReference = classLoaderContext.getClassLoaderRef();
        ClassLoader classLoader = (ClassLoader)weakReference.get();
        if (classLoader == null) {
            this._classLoaders.remove(key);
        }
        return classLoader;
    }

    public void removeClassLoader(ClassLoader classLoader) {
        Long removedClassLoadedId;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("removing class loader from cache [" + ClassLoaderHelper.getClassLoaderLogName(classLoader) + "]");
        }
        if ((removedClassLoadedId = this._classLoaderToIdMap.remove(classLoader)) != null) {
            ClassLoaderContext removedContext = this._classLoaders.put(removedClassLoadedId, new ClassLoaderContext(null, Represent.REMOVED_EXPLICIT));
            if (removedContext.getRepresents() == Represent.REMOVED_EXPLICIT || removedContext.getRepresents() == Represent.REMOVED_IMPLICIT) {
                return;
            }
            this.dispatchClassLoaderRemovedEvent(removedClassLoadedId, removedContext, true);
        } else {
            _logger.fine("class loader [" + ClassLoaderHelper.getClassLoaderLogName(classLoader) + "] is not present in cache");
        }
    }

    private long generateClassLoaderKey() {
        return this._classLoaderKeyGenerator.incrementAndGet();
    }

    @Override
    public void weakEntryRemoved(Long value) {
        ClassLoaderContext removedContext;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("class loader with key " + value + " is removed because it has no more active references");
        }
        if ((removedContext = this._classLoaders.put(value, new ClassLoaderContext(null, Represent.REMOVED_IMPLICIT))).getRepresents() == Represent.REMOVED_EXPLICIT || removedContext.getRepresents() == Represent.REMOVED_IMPLICIT) {
            return;
        }
        this.dispatchClassLoaderRemovedEvent(value, removedContext, false);
    }

    public Long getClassLoaderKey(ClassLoader classLoader) {
        return this._classLoaderToIdMap.get(classLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerCacheStateListener(IClassLoaderCacheStateListener listener) {
        WeakReference<IClassLoaderCacheStateListener> weakListener = new WeakReference<IClassLoaderCacheStateListener>(listener);
        this._listeners.add(weakListener);
        HashSet<Long> alreadyRemovedExplicitListeners = new HashSet<Long>();
        HashSet<Long> alreadyRemovedImplicitListeners = new HashSet<Long>();
        Object object = this._lock;
        synchronized (object) {
            long currentTime = SystemTime.timeMillis();
            for (Map.Entry<Long, ClassLoaderContext> entry : this._classLoaders.entrySet()) {
                if (currentTime - entry.getValue().getTimeStamp() > this._removedRelevantWindow) continue;
                if (entry.getValue().getRepresents() == Represent.REMOVED_EXPLICIT) {
                    alreadyRemovedExplicitListeners.add(entry.getKey());
                }
                if (entry.getValue().getRepresents() != Represent.REMOVED_IMPLICIT) continue;
                alreadyRemovedImplicitListeners.add(entry.getKey());
            }
        }
        this.dispatchRemovedHelper(listener, weakListener, alreadyRemovedExplicitListeners, true);
        this.dispatchRemovedHelper(listener, weakListener, alreadyRemovedImplicitListeners, false);
    }

    private void dispatchRemovedHelper(IClassLoaderCacheStateListener listener, WeakReference<IClassLoaderCacheStateListener> weakListener, Set<Long> alreadyRemovedExplicitListeners, boolean explicit) {
        for (Long removedClKey : alreadyRemovedExplicitListeners) {
            try {
                listener.onClassLoaderRemoved(removedClKey, explicit);
            }
            catch (Exception e) {
                if (_logger.isLoggable(Level.SEVERE)) {
                    _logger.log(Level.SEVERE, "received exception while dispatching class loader removed event, class loader id" + removedClKey, e);
                }
                this._listeners.remove(weakListener);
            }
        }
    }

    public boolean registerClassLoaderStateListener(Long classLoaderKey, IClassLoaderCacheStateListener listener) {
        ClassLoaderContext classLoaderContext = this._classLoaders.get(classLoaderKey);
        if (classLoaderContext == null) {
            return false;
        }
        if (classLoaderContext.getRepresents() != Represent.REGULAR) {
            return false;
        }
        return classLoaderContext.addListener(listener);
    }

    private void dispatchClassLoaderRemovedEvent(Long classLoaderKey, ClassLoaderContext removedContext, boolean explicit) {
        for (WeakReference<IClassLoaderCacheStateListener> weakListener : this._listeners) {
            IClassLoaderCacheStateListener listener = (IClassLoaderCacheStateListener)weakListener.get();
            if (listener == null) {
                this._listeners.remove(weakListener);
                continue;
            }
            try {
                listener.onClassLoaderRemoved(classLoaderKey, explicit);
            }
            catch (Exception e) {
                if (_logger.isLoggable(Level.SEVERE)) {
                    _logger.log(Level.SEVERE, "received exception while dispatching class loader removed event, class loader id" + classLoaderKey, e);
                }
                this._listeners.remove(weakListener);
            }
        }
        removedContext.dispatchRemoved(classLoaderKey, explicit);
    }

    public void removeClassLoaderStateListener(Long classLoaderKey, IClassLoaderCacheStateListener listener) {
        ClassLoaderContext classLoaderContext = this._classLoaders.get(classLoaderKey);
        if (classLoaderContext == null) {
            return;
        }
        classLoaderContext.removeListener(listener);
    }

    private static class ClassLoaderContext {
        private final WeakReference<ClassLoader> _classLoaderRef;
        private final CopyOnWriteArraySet<WeakReference<IClassLoaderCacheStateListener>> _specificListeners;
        private volatile boolean _dispatchingRemoved;
        private final long _timeStamp;
        private final Represent _represents;

        public ClassLoaderContext(ClassLoader classLoader, Represent represents) {
            this._represents = represents;
            this._classLoaderRef = new WeakReference<ClassLoader>(classLoader);
            this._specificListeners = new CopyOnWriteArraySet();
            this._timeStamp = SystemTime.timeMillis();
        }

        public WeakReference<ClassLoader> getClassLoaderRef() {
            return this._classLoaderRef;
        }

        public boolean addListener(IClassLoaderCacheStateListener listener) {
            this._specificListeners.add(new WeakReference<IClassLoaderCacheStateListener>(listener));
            return !this._dispatchingRemoved;
        }

        public void removeListener(IClassLoaderCacheStateListener listener) {
            for (WeakReference<IClassLoaderCacheStateListener> weakListener : this._specificListeners) {
                IClassLoaderCacheStateListener actualListener = (IClassLoaderCacheStateListener)weakListener.get();
                if (actualListener == null) {
                    this._specificListeners.remove(weakListener);
                    continue;
                }
                if (actualListener != listener) continue;
                this._specificListeners.remove(weakListener);
                break;
            }
        }

        public void dispatchRemoved(Long classLoaderKey, boolean explicit) {
            this._dispatchingRemoved = true;
            for (WeakReference<IClassLoaderCacheStateListener> weakListener : this._specificListeners) {
                try {
                    IClassLoaderCacheStateListener listener = (IClassLoaderCacheStateListener)weakListener.get();
                    if (listener == null) continue;
                    listener.onClassLoaderRemoved(classLoaderKey, explicit);
                }
                catch (Exception e) {
                    if (!_logger.isLoggable(Level.SEVERE)) continue;
                    _logger.log(Level.SEVERE, "received exception while dispatching class loader removed event, class loader id" + classLoaderKey, e);
                }
            }
        }

        public Represent getRepresents() {
            return this._represents;
        }

        public long getTimeStamp() {
            return this._timeStamp;
        }
    }

    private static enum Represent {
        REGULAR,
        REMOVED_EXPLICIT,
        REMOVED_IMPLICIT;

    }
}

