/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.client;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.client.ChangeResult;
import com.gigaspaces.client.ChangedEntryDetails;
import com.gigaspaces.internal.io.IOUtils;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Collections;

@InternalApi
public class ChangeDetailedResultImpl<T>
implements ChangeResult<T>,
Externalizable {
    private static final long serialVersionUID = 1L;
    public static final ChangeDetailedResultImpl<?> EMPTY = new ChangeDetailedResultImpl();
    private ChangedEntryDetails<T> _singleChangeEntryResult;
    private Collection<ChangedEntryDetails<T>> _multipleBatchResults;

    public ChangeDetailedResultImpl() {
    }

    public ChangeDetailedResultImpl(ChangedEntryDetails<T> singleChangeEntryResult) {
        this._singleChangeEntryResult = singleChangeEntryResult;
    }

    public ChangeDetailedResultImpl(Collection<ChangedEntryDetails<T>> multipleBatchResults) {
        this._multipleBatchResults = multipleBatchResults;
    }

    @Override
    public Collection<ChangedEntryDetails<T>> getResults() {
        if (this._multipleBatchResults != null) {
            return this._multipleBatchResults;
        }
        if (this._singleChangeEntryResult == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.singletonList(this._singleChangeEntryResult);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeBoolean(this._multipleBatchResults != null);
        if (this._multipleBatchResults != null) {
            IOUtils.writeObject(out, this._multipleBatchResults);
        } else {
            IOUtils.writeObject(out, this._singleChangeEntryResult);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        if (in.readBoolean()) {
            this._multipleBatchResults = (Collection)IOUtils.readObject(in);
        } else {
            this._singleChangeEntryResult = (ChangedEntryDetails)IOUtils.readObject(in);
        }
    }

    @Override
    public int getNumberOfChangedEntries() {
        return this._multipleBatchResults != null ? this._multipleBatchResults.size() : (this._singleChangeEntryResult == null ? 0 : 1);
    }
}

