/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.client;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.client.ChangeOperationResult;
import com.gigaspaces.client.ChangedEntryDetails;
import com.gigaspaces.client.mutators.SpaceEntryMutator;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.utils.Textualizable;
import com.gigaspaces.internal.utils.Textualizer;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import com.gigaspaces.lrmi.LRMIInvocationContext;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

@InternalApi
public class ChangeEntryDetailsImpl<T>
implements ChangedEntryDetails<T>,
Externalizable,
Textualizable {
    private static final long serialVersionUID = 1L;
    private String _typeName;
    private Object _id;
    private int _version;
    private List<Serializable> _results;
    private transient Collection<SpaceEntryMutator> _mutators;

    public ChangeEntryDetailsImpl() {
    }

    public ChangeEntryDetailsImpl(String typeName, Object id, int version, List<Serializable> results) {
        this._typeName = typeName;
        this._id = id;
        this._version = version;
        this._results = results;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        IOUtils.writeRepetitiveString(out, this._typeName);
        IOUtils.writeObject(out, this._id);
        out.writeInt(this._version);
        if (LRMIInvocationContext.getEndpointLogicalVersion().greaterOrEquals(PlatformLogicalVersion.v9_7_0)) {
            IOUtils.writeObject(out, this._results);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._typeName = IOUtils.readRepetitiveString(in);
        this._id = IOUtils.readObject(in);
        this._version = in.readInt();
        if (LRMIInvocationContext.getEndpointLogicalVersion().greaterOrEquals(PlatformLogicalVersion.v9_7_0)) {
            this._results = (List)IOUtils.readObject(in);
        }
    }

    @Override
    public String getTypeName() {
        return this._typeName;
    }

    @Override
    public Object getId() {
        return this._id;
    }

    @Override
    public int getVersion() {
        return this._version;
    }

    @Override
    public void toText(Textualizer textualizer) {
        textualizer.append("typeName", this._typeName);
        textualizer.append("id", this._id);
        textualizer.append("version", this._version);
    }

    public String toString() {
        return Textualizer.toString(this);
    }

    public void setMutators(Collection<SpaceEntryMutator> mutators) {
        this._mutators = mutators;
    }

    @Override
    public List<ChangeOperationResult> getChangeOperationsResults() {
        if (this._results == null) {
            ArrayList<ChangeOperationResult> changeOperationResults = new ArrayList<ChangeOperationResult>(this._mutators.size());
            for (SpaceEntryMutator mutator : this._mutators) {
                changeOperationResults.add(mutator.getChangeOperationResult(null));
            }
            return changeOperationResults;
        }
        if (this._mutators == null || this._mutators.size() != this._results.size()) {
            throw new IllegalStateException("Mutators size does not match change operation results size [mutators=" + this._mutators + ", results=" + this._results + "]");
        }
        ArrayList<ChangeOperationResult> changeOperationResults = new ArrayList<ChangeOperationResult>(this._results.size());
        Iterator<Serializable> iterator = this._results.iterator();
        for (SpaceEntryMutator mutator : this._mutators) {
            changeOperationResults.add(mutator.getChangeOperationResult(iterator.next()));
        }
        return changeOperationResults;
    }
}

