/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.client;

import com.gigaspaces.internal.metadata.EntryType;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.gigaspaces.internal.transport.TransportPacketType;
import com.gigaspaces.internal.version.PlatformLogicalVersion;

public enum QueryResultTypeInternal {
    NOT_SET(0, null),
    DOCUMENT_ENTRY(1, EntryType.DOCUMENT_JAVA),
    OBJECT_JAVA(2, EntryType.OBJECT_JAVA),
    EXTERNAL_ENTRY(4, EntryType.EXTERNAL_ENTRY),
    PBS_OLD(5, EntryType.DOCUMENT_JAVA),
    OBJECT_DOTNET(6, EntryType.OBJECT_DOTNET),
    DOCUMENT_DOTNET(7, EntryType.DOCUMENT_DOTNET),
    CPP(8, EntryType.CPP);

    private static final int MAX = 8;
    private static final QueryResultTypeInternal[] _values;
    private final byte _code;
    private final EntryType _entryType;

    private QueryResultTypeInternal(int code, EntryType entryType) {
        this._code = (byte)code;
        this._entryType = entryType;
    }

    public byte getCode() {
        return this._code;
    }

    public byte getCode(PlatformLogicalVersion version) {
        return this._code;
    }

    public static QueryResultTypeInternal fromCode(byte code) {
        return _values[code];
    }

    public EntryType getEntryType() {
        return this._entryType;
    }

    public boolean isPbs() {
        return this == OBJECT_DOTNET || this == DOCUMENT_DOTNET || this == CPP || this == PBS_OLD;
    }

    public static QueryResultTypeInternal fromEntryType(EntryType entryType) {
        if (entryType == null) {
            return NOT_SET;
        }
        switch (entryType) {
            case OBJECT_JAVA: {
                return OBJECT_JAVA;
            }
            case DOCUMENT_JAVA: {
                return DOCUMENT_ENTRY;
            }
            case CPP: {
                return DOCUMENT_ENTRY;
            }
            case OBJECT_DOTNET: {
                return DOCUMENT_ENTRY;
            }
            case DOCUMENT_DOTNET: {
                return DOCUMENT_ENTRY;
            }
            case EXTERNAL_ENTRY: {
                return EXTERNAL_ENTRY;
            }
        }
        throw new IllegalArgumentException("Unsupported entry type: " + (Object)((Object)entryType));
    }

    public static QueryResultTypeInternal getUpdateResultType(IEntryPacket packet) {
        EntryType entryType = packet.getEntryType();
        if (entryType == null) {
            return NOT_SET;
        }
        switch (entryType) {
            case OBJECT_JAVA: {
                return OBJECT_JAVA;
            }
            case DOCUMENT_JAVA: {
                if (packet.getPacketType() == TransportPacketType.PBS) {
                    return PBS_OLD;
                }
                return DOCUMENT_ENTRY;
            }
            case OBJECT_DOTNET: {
                return OBJECT_DOTNET;
            }
            case DOCUMENT_DOTNET: {
                return DOCUMENT_DOTNET;
            }
            case CPP: {
                return CPP;
            }
            case EXTERNAL_ENTRY: {
                if (packet.getPacketType() == TransportPacketType.PBS) {
                    return PBS_OLD;
                }
                return EXTERNAL_ENTRY;
            }
        }
        throw new IllegalArgumentException("Unsupported entry type: " + (Object)((Object)entryType));
    }

    static {
        _values = new QueryResultTypeInternal[9];
        QueryResultTypeInternal._values[QueryResultTypeInternal.NOT_SET._code] = NOT_SET;
        QueryResultTypeInternal._values[QueryResultTypeInternal.DOCUMENT_ENTRY._code] = DOCUMENT_ENTRY;
        QueryResultTypeInternal._values[QueryResultTypeInternal.OBJECT_JAVA._code] = OBJECT_JAVA;
        QueryResultTypeInternal._values[3] = OBJECT_JAVA;
        QueryResultTypeInternal._values[QueryResultTypeInternal.EXTERNAL_ENTRY._code] = EXTERNAL_ENTRY;
        QueryResultTypeInternal._values[QueryResultTypeInternal.PBS_OLD._code] = PBS_OLD;
        QueryResultTypeInternal._values[QueryResultTypeInternal.OBJECT_DOTNET._code] = OBJECT_DOTNET;
        QueryResultTypeInternal._values[QueryResultTypeInternal.DOCUMENT_DOTNET._code] = DOCUMENT_DOTNET;
        QueryResultTypeInternal._values[QueryResultTypeInternal.CPP._code] = CPP;
    }
}

