/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.client.mutators;

import com.gigaspaces.internal.client.mutators.CollectionChangeSpaceEntryMutatorResult;
import com.gigaspaces.internal.client.mutators.SpaceEntryPathMutator;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.utils.CollectionUtils;
import com.gigaspaces.internal.utils.Textualizer;
import com.gigaspaces.server.MutableServerEntry;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Collection;

public final class AddAllToCollectionSpaceEntryMutator
extends SpaceEntryPathMutator {
    private static final long serialVersionUID = 1L;
    private Collection<? extends Serializable> _items;

    public AddAllToCollectionSpaceEntryMutator() {
    }

    public AddAllToCollectionSpaceEntryMutator(String path, Collection<? extends Serializable> items) {
        super(path);
        this._items = items;
    }

    @Override
    public CollectionChangeSpaceEntryMutatorResult change(MutableServerEntry entry) {
        Collection oldValue = (Collection)entry.getPathValue(this.getPath());
        if (oldValue == null) {
            throw new IllegalStateException("No collection instance exists under the given path '" + this.getPath() + "', in order to add items a collection instance must exists");
        }
        Collection newValue = CollectionUtils.cloneCollection(oldValue);
        boolean changed = newValue.addAll(this._items);
        int size = newValue.size();
        entry.setPathValue(this.getPath(), newValue);
        return new CollectionChangeSpaceEntryMutatorResult(changed, size);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        IOUtils.writeObject(out, this._items);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this._items = (Collection)IOUtils.readObject(in);
    }

    @Override
    public void toText(Textualizer textualizer) {
        super.toText(textualizer);
        textualizer.appendIterable("items", this._items);
    }

    @Override
    public String getName() {
        return "addAllToCollection";
    }

    public Collection<? extends Serializable> getItems() {
        return this._items;
    }
}

