/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.client.mutators;

import com.gigaspaces.internal.client.mutators.SpaceEntryPathMutator;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.utils.Textualizer;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import com.gigaspaces.lrmi.LRMIInvocationContext;
import com.gigaspaces.server.MutableServerEntry;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.math.BigDecimal;
import java.math.BigInteger;

public final class IncrementSpaceEntryMutator
extends SpaceEntryPathMutator {
    private static final long serialVersionUID = 1L;
    private Number _delta;
    private static final byte FLAG_BYTE = 1;
    private static final byte FLAG_SHORT = 2;
    private static final byte FLAG_INT = 4;
    private static final byte FLAG_LONG = 8;
    private static final byte FLAG_FLOAT = 16;
    private static final byte FLAG_DOUBLE = 32;

    public IncrementSpaceEntryMutator() {
    }

    public IncrementSpaceEntryMutator(String path, Number delta) {
        super(path);
        if (delta == null) {
            throw new IllegalArgumentException("delta cannot be null");
        }
        this._delta = delta;
    }

    @Override
    public Object change(MutableServerEntry entry) {
        Number oldValue = (Number)entry.getPathValue(this.getPath());
        Number newValue = this._delta;
        if (oldValue != null && !oldValue.getClass().equals(newValue.getClass())) {
            throw new IllegalArgumentException("attempting to increment old value [" + oldValue + "," + oldValue.getClass() + "] with incompatible number type [" + newValue + "," + newValue.getClass() + "]");
        }
        if (oldValue instanceof Byte) {
            newValue = oldValue.byteValue() + this._delta.byteValue();
        } else if (oldValue instanceof Short) {
            newValue = oldValue.shortValue() + this._delta.shortValue();
        } else if (oldValue instanceof Integer) {
            newValue = oldValue.intValue() + this._delta.intValue();
        } else if (oldValue instanceof Long) {
            newValue = oldValue.longValue() + this._delta.longValue();
        } else if (oldValue instanceof Float) {
            newValue = Float.valueOf(oldValue.floatValue() + this._delta.floatValue());
        } else if (oldValue instanceof Double) {
            newValue = oldValue.doubleValue() + this._delta.doubleValue();
        } else if (oldValue instanceof BigInteger) {
            newValue = ((BigInteger)oldValue).add((BigInteger)newValue);
        } else if (oldValue instanceof BigDecimal) {
            newValue = ((BigDecimal)oldValue).add((BigDecimal)newValue);
        } else if (oldValue != null) {
            throw new IllegalStateException("old value is of unknown number type - " + oldValue.getClass());
        }
        entry.setPathValue(this.getPath(), newValue);
        return newValue;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        if (LRMIInvocationContext.getEndpointLogicalVersion().greaterOrEquals(PlatformLogicalVersion.v9_7_0)) {
            IOUtils.writeObject(out, this._delta);
        } else if (this._delta instanceof Integer) {
            out.writeByte(4);
            out.writeInt(this._delta.intValue());
        } else if (this._delta instanceof Long) {
            out.writeByte(8);
            out.writeLong(this._delta.longValue());
        } else if (this._delta instanceof Double) {
            out.writeByte(32);
            out.writeDouble(this._delta.doubleValue());
        } else if (this._delta instanceof Float) {
            out.writeByte(16);
            out.writeFloat(this._delta.floatValue());
        } else if (this._delta instanceof Byte) {
            out.writeByte(1);
            out.writeByte(this._delta.byteValue());
        } else if (this._delta instanceof Short) {
            out.writeByte(2);
            out.writeShort(this._delta.shortValue());
        } else {
            throw new UnsupportedOperationException("Illegal delta type - " + this._delta.getClass());
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        if (LRMIInvocationContext.getEndpointLogicalVersion().greaterOrEquals(PlatformLogicalVersion.v9_7_0)) {
            this._delta = (Number)IOUtils.readObject(in);
        } else {
            byte flag = in.readByte();
            if ((flag & 1) != 0) {
                this._delta = in.readByte();
            }
            if ((flag & 2) != 0) {
                this._delta = in.readShort();
            }
            if ((flag & 4) != 0) {
                this._delta = in.readInt();
            }
            if ((flag & 8) != 0) {
                this._delta = in.readLong();
            }
            if ((flag & 0x10) != 0) {
                this._delta = Float.valueOf(in.readFloat());
            }
            if ((flag & 0x20) != 0) {
                this._delta = in.readDouble();
            }
        }
    }

    @Override
    public void toText(Textualizer textualizer) {
        super.toText(textualizer);
        textualizer.append("delta", this._delta);
    }

    @Override
    public String getName() {
        return "increment";
    }

    public Number getDelta() {
        return this._delta;
    }
}

