/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.client.mutators;

import com.gigaspaces.internal.client.mutators.MapChangeSpaceEntryMutatorResult;
import com.gigaspaces.internal.client.mutators.SpaceEntryPathMutator;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.utils.CollectionUtils;
import com.gigaspaces.internal.utils.Textualizer;
import com.gigaspaces.server.MutableServerEntry;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Map;

public final class PutInMapSpaceEntryMutator
extends SpaceEntryPathMutator {
    private static final long serialVersionUID = 1L;
    private Serializable _key;
    private Serializable _value;

    public PutInMapSpaceEntryMutator() {
    }

    public PutInMapSpaceEntryMutator(String path, Serializable key, Serializable value) {
        super(path);
        this._key = key;
        this._value = value;
    }

    @Override
    public Object change(MutableServerEntry entry) {
        Map oldValue = (Map)entry.getPathValue(this.getPath());
        if (oldValue == null) {
            throw new IllegalStateException("No map instance exists under the given path '" + this.getPath() + "', in order to put a key value pair a map instance must exists");
        }
        Map<Serializable, Serializable> newValue = CollectionUtils.cloneMap(oldValue);
        Serializable previousValue = newValue.put(this._key, this._value);
        int size = newValue.size();
        entry.setPathValue(this.getPath(), newValue);
        return new MapChangeSpaceEntryMutatorResult(previousValue, size);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        IOUtils.writeObject(out, this._key);
        IOUtils.writeObject(out, this._value);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this._key = (Serializable)IOUtils.readObject(in);
        this._value = (Serializable)IOUtils.readObject(in);
    }

    @Override
    public void toText(Textualizer textualizer) {
        super.toText(textualizer);
        textualizer.append("key", this._key);
        textualizer.append("value", this._value);
    }

    @Override
    public String getName() {
        return "putInMap";
    }

    public Serializable getKey() {
        return this._key;
    }

    public Serializable getValue() {
        return this._value;
    }
}

