/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.client.mutators;

import com.gigaspaces.internal.client.mutators.MapChangeSpaceEntryMutatorResult;
import com.gigaspaces.internal.client.mutators.SpaceEntryPathMutator;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.utils.CollectionUtils;
import com.gigaspaces.internal.utils.Textualizer;
import com.gigaspaces.server.MutableServerEntry;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Map;

public final class RemoveFromMapSpaceEntryMutator
extends SpaceEntryPathMutator {
    private static final long serialVersionUID = 1L;
    private Serializable _key;

    public RemoveFromMapSpaceEntryMutator() {
    }

    public RemoveFromMapSpaceEntryMutator(String path, Serializable key) {
        super(path);
        this._key = key;
    }

    @Override
    public Object change(MutableServerEntry entry) {
        Map oldValue = (Map)entry.getPathValue(this.getPath());
        if (oldValue == null) {
            throw new IllegalStateException("No map instance exists under the given path '" + this.getPath() + "', in order to remove a map instance must exists");
        }
        Map newValue = CollectionUtils.cloneMap(oldValue);
        Object removedValue = newValue.remove(this._key);
        int size = newValue.size();
        entry.setPathValue(this.getPath(), newValue);
        return new MapChangeSpaceEntryMutatorResult((Serializable)removedValue, size);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        IOUtils.writeObject(out, this._key);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this._key = (Serializable)IOUtils.readObject(in);
    }

    @Override
    public void toText(Textualizer textualizer) {
        super.toText(textualizer);
        textualizer.append("key", this._key);
    }

    @Override
    public String getName() {
        return "removeFromMap";
    }

    public Serializable getKey() {
        return this._key;
    }
}

