/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.client.mutators;

import com.gigaspaces.client.mutators.SpaceEntryMutator;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.utils.Textualizable;
import com.gigaspaces.internal.utils.Textualizer;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import com.gigaspaces.lrmi.LRMIInvocationContext;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public abstract class SpaceEntryPathMutator
extends SpaceEntryMutator
implements Externalizable,
Textualizable {
    private static final long serialVersionUID = 1L;
    private String _path;
    private boolean _disablePathCaching = false;

    protected SpaceEntryPathMutator() {
    }

    protected SpaceEntryPathMutator(String path) {
        this();
        this._path = path;
    }

    public String getPath() {
        return this._path;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        PlatformLogicalVersion version = LRMIInvocationContext.getEndpointLogicalVersion();
        if (version.patchSameOrGreater(PlatformLogicalVersion.v12_3_0_PATCH4) || version.greaterOrEquals(PlatformLogicalVersion.v14_2_0)) {
            out.writeBoolean(this._disablePathCaching);
        }
        if (this._disablePathCaching) {
            IOUtils.writeString(out, this._path);
        } else {
            IOUtils.writeRepetitiveString(out, this._path);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        PlatformLogicalVersion version = LRMIInvocationContext.getEndpointLogicalVersion();
        if (version.patchSameOrGreater(PlatformLogicalVersion.v12_3_0_PATCH4) || version.greaterOrEquals(PlatformLogicalVersion.v14_2_0)) {
            this._disablePathCaching = in.readBoolean();
        }
        this._path = this._disablePathCaching ? IOUtils.readString(in) : IOUtils.readRepetitiveString(in);
    }

    @Override
    public void toText(Textualizer textualizer) {
        textualizer.append("path", this._path);
    }

    public String toString() {
        return Textualizer.toString(this);
    }

    public SpaceEntryPathMutator disablePathCaching() {
        this._disablePathCaching = true;
        return this;
    }
}

