/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.client.spaceproxy;

import com.gigaspaces.async.AsyncFuture;
import com.gigaspaces.async.AsyncFutureListener;
import com.gigaspaces.client.ChangeModifiers;
import com.gigaspaces.client.ChangeResult;
import com.gigaspaces.client.ChangeSet;
import com.gigaspaces.client.WriteMultipleException;
import com.gigaspaces.events.NotifyActionType;
import com.gigaspaces.events.NotifyInfo;
import com.gigaspaces.executor.SpaceTask;
import com.gigaspaces.internal.client.QueryResultTypeInternal;
import com.gigaspaces.internal.client.ReadTakeEntriesUidsResult;
import com.gigaspaces.internal.client.spaceproxy.IDirectSpaceProxy;
import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.gigaspaces.internal.client.spaceproxy.actioninfo.ReadTakeByIdsProxyActionInfo;
import com.gigaspaces.internal.client.spaceproxy.actioninfo.ReadTakeProxyActionInfo;
import com.gigaspaces.internal.client.spaceproxy.actions.AbstractSpaceProxyActionManager;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.transport.ITemplatePacket;
import com.gigaspaces.metadata.index.AddTypeIndexesResult;
import com.gigaspaces.metadata.index.SpaceIndex;
import com.gigaspaces.query.ISpaceQuery;
import com.gigaspaces.query.aggregators.AggregationResult;
import com.gigaspaces.query.aggregators.AggregationSet;
import com.j_spaces.core.DropClassException;
import com.j_spaces.core.LeaseContext;
import com.j_spaces.core.SpaceHealthStatus;
import com.j_spaces.core.client.EntryAlreadyInSpaceException;
import com.j_spaces.core.client.EntryNotInSpaceException;
import com.j_spaces.core.client.EntryVersionConflictException;
import com.j_spaces.core.client.Modifiers;
import com.j_spaces.core.client.OperationTimeoutException;
import com.j_spaces.core.client.UpdateModifiers;
import com.j_spaces.core.exception.internal.InterruptedSpaceException;
import java.rmi.MarshalledObject;
import java.rmi.RemoteException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.entry.Entry;
import net.jini.core.entry.UnusableEntryException;
import net.jini.core.event.EventRegistration;
import net.jini.core.event.RemoteEventListener;
import net.jini.core.lease.Lease;
import net.jini.core.transaction.Transaction;
import net.jini.core.transaction.TransactionException;

public abstract class AbstractSpaceProxy
implements ISpaceProxy {
    private static final long serialVersionUID = -7437421509223305572L;
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.client");
    private final transient AbstractSpaceProxyActionManager<?> _actionManager = this.createActionManager();
    private transient int _associatedAppDomainId;
    private transient boolean _isAppDomainAssociated;
    private transient long _dotnetProxyHandleId;
    private transient boolean _isTargetOfADotnetProxy;

    protected AbstractSpaceProxy() {
    }

    protected abstract AbstractSpaceProxyActionManager<?> createActionManager();

    @Override
    public String getContainerName() {
        return this.getDirectProxy().getProxySettings().getContainerName();
    }

    @Override
    public Lease write(Entry entry, Transaction txn, long lease) throws TransactionException, RemoteException {
        return this._actionManager.write(entry, txn, lease, 0L, this.getUpdateModifiers());
    }

    @Override
    public Entry read(Entry template, Transaction txn, long timeout) throws UnusableEntryException, TransactionException, InterruptedException, RemoteException {
        return (Entry)this._actionManager.read(template, txn, timeout, this.getReadModifiers(), false);
    }

    @Override
    public Entry readIfExists(Entry template, Transaction txn, long timeout) throws UnusableEntryException, TransactionException, InterruptedException, RemoteException {
        return (Entry)this._actionManager.read(template, txn, timeout, this.getReadModifiers(), true);
    }

    @Override
    public Entry take(Entry template, Transaction txn, long timeout) throws UnusableEntryException, TransactionException, InterruptedException, RemoteException {
        return (Entry)this._actionManager.take(template, txn, timeout, this.getReadModifiers(), false);
    }

    @Override
    public Entry takeIfExists(Entry template, Transaction txn, long timeout) throws UnusableEntryException, TransactionException, InterruptedException, RemoteException {
        return (Entry)this._actionManager.take(template, txn, timeout, this.getReadModifiers(), true);
    }

    @Override
    public EventRegistration notify(Entry template, Transaction txn, RemoteEventListener listener, long lease, MarshalledObject handback) throws TransactionException, RemoteException {
        if (txn != null) {
            throw new IllegalArgumentException("Notification registration with transaction is not supported.");
        }
        NotifyInfo notifyInfo = new NotifyInfo(listener, NotifyActionType.NOTIFY_WRITE.getModifier(), false, handback);
        return this.getDirectProxy().getDataEventsManager().addListener(template, lease, notifyInfo, false);
    }

    @Override
    public Entry snapshot(Entry e) throws RemoteException {
        return (Entry)this._actionManager.snapshot(e);
    }

    @Override
    public ITypeDesc getTypeDescriptor(String typeName) throws RemoteException {
        return this._actionManager.getTypeDescriptor(typeName);
    }

    @Override
    public void registerTypeDescriptor(ITypeDesc typeDesc) throws RemoteException {
        this._actionManager.registerTypeDescriptor(typeDesc);
    }

    @Override
    public ITypeDesc registerTypeDescriptor(Class<?> type) throws RemoteException {
        return this._actionManager.registerTypeDescriptor(type);
    }

    @Override
    public AsyncFuture<AddTypeIndexesResult> asyncAddIndexes(String typeName, SpaceIndex[] indexes, AsyncFutureListener<AddTypeIndexesResult> listener) throws RemoteException {
        return this._actionManager.asyncAddIndexes(typeName, indexes, listener);
    }

    @Override
    public void dropClass(String className) throws RemoteException, DropClassException {
        this._actionManager.dropClass(className);
    }

    @Override
    public void clear(Object template, Transaction txn) throws RemoteException, TransactionException, UnusableEntryException {
        this._actionManager.clear(template, txn, this.getReadModifiers());
    }

    @Override
    public int clear(Object template, Transaction txn, int modifiers) throws RemoteException, TransactionException, UnusableEntryException {
        return this._actionManager.clear(template, txn, modifiers);
    }

    @Override
    public int count(Object template, Transaction txn) throws RemoteException, TransactionException, UnusableEntryException {
        return this._actionManager.count(template, txn, this.getReadModifiers());
    }

    @Override
    public int count(Object template, Transaction txn, int modifiers) throws RemoteException, TransactionException, UnusableEntryException {
        return this._actionManager.count(template, txn, modifiers);
    }

    @Override
    public AsyncFuture execute(SpaceTask task, Object routing, Transaction tx, AsyncFutureListener listener) throws TransactionException, RemoteException {
        return this._actionManager.executeTask(task, routing, tx, listener);
    }

    @Override
    public void ping() throws RemoteException {
        this._actionManager.ping();
    }

    @Override
    public SpaceHealthStatus getSpaceHealthStatus() throws RemoteException {
        return this._actionManager.getSpaceHealthStatus();
    }

    @Override
    public Object read(Object template, Transaction txn, long timeout) throws UnusableEntryException, TransactionException, InterruptedException, RemoteException {
        return this._actionManager.read(template, txn, timeout, this.getReadModifiers(), false);
    }

    @Override
    public Object read(Object template, Transaction txn, long timeout, int modifiers) throws UnusableEntryException, TransactionException, InterruptedException, RemoteException {
        return this._actionManager.read(template, txn, timeout, modifiers, false);
    }

    @Override
    public Object read(Object template, Transaction txn, long timeout, int modifiers, boolean ifExists) throws UnusableEntryException, TransactionException, InterruptedException, RemoteException {
        return this._actionManager.read(template, txn, timeout, modifiers, ifExists);
    }

    @Override
    public AsyncFuture<?> asyncRead(Object template, Transaction txn, long timeout, int modifiers, AsyncFutureListener listener) throws RemoteException {
        return this._actionManager.asyncRead(template, txn, timeout, modifiers, listener);
    }

    @Override
    public Object readById(String className, Object id, Object routing, Transaction txn, long timeout, int modifiers, boolean ifExists, QueryResultTypeInternal resultType, String[] projections) throws RemoteException, UnusableEntryException, TransactionException, InterruptedException {
        return this._actionManager.readById(className, id, routing, txn, timeout, modifiers, ifExists, resultType, projections);
    }

    @Override
    public Object readById(ReadTakeProxyActionInfo actionInfo) throws RemoteException, UnusableEntryException, TransactionException, InterruptedException {
        return this._actionManager.read(actionInfo);
    }

    @Override
    public Object takeById(ReadTakeProxyActionInfo actionInfo) throws RemoteException, UnusableEntryException, TransactionException, InterruptedException {
        return this._actionManager.take(actionInfo);
    }

    @Override
    public Object readByUid(String uid, Transaction txn, int modifiers, QueryResultTypeInternal resultType, boolean returnPacket) throws RemoteException, UnusableEntryException, TransactionException, InterruptedException {
        return this._actionManager.readByUid(uid, txn, modifiers, resultType, returnPacket);
    }

    @Override
    public Object readIfExists(Object template, Transaction txn, long timeout) throws UnusableEntryException, TransactionException, InterruptedException, RemoteException {
        return this._actionManager.read(template, txn, timeout, this.getReadModifiers(), true);
    }

    @Override
    public Object readIfExists(Object template, Transaction txn, long timeout, int modifiers) throws UnusableEntryException, TransactionException, InterruptedException, RemoteException {
        return this._actionManager.read(template, txn, timeout, modifiers, true);
    }

    @Override
    public Object[] readMultiple(Object template, Transaction txn, int maxEntries) throws TransactionException, UnusableEntryException, RemoteException {
        return this._actionManager.readMultiple(template, txn, 0L, maxEntries, maxEntries, this.getReadModifiers(), false, false);
    }

    @Override
    public Object[] readMultiple(Object template, Transaction txn, int maxEntries, int modifiers) throws TransactionException, UnusableEntryException, RemoteException {
        return this._actionManager.readMultiple(template, txn, 0L, maxEntries, maxEntries, modifiers, false, false);
    }

    @Override
    public Object[] readMultiple(Object template, Transaction txn, int maxEntries, int modifiers, boolean returnOnlyUids) throws TransactionException, UnusableEntryException, RemoteException {
        return this._actionManager.readMultiple(template, txn, 0L, maxEntries, maxEntries, modifiers, returnOnlyUids, false);
    }

    @Override
    public Object[] readMultiple(Object template, Transaction txn, long timeout, int maxEntries, int minEntriesToWaitFor, int modifiers, boolean returnOnlyUids, boolean ifExist) throws TransactionException, UnusableEntryException, RemoteException {
        return this._actionManager.readMultiple(template, txn, timeout, maxEntries, minEntriesToWaitFor, modifiers, returnOnlyUids, ifExist);
    }

    @Override
    public <T> ISpaceQuery<T> snapshot(Object template) throws RemoteException {
        return this._actionManager.snapshot(template);
    }

    @Override
    public Object take(Object template, Transaction txn, long timeout) throws UnusableEntryException, TransactionException, InterruptedException, RemoteException {
        return this._actionManager.take(template, txn, timeout, this.getReadModifiers(), false);
    }

    @Override
    public Object take(Object template, Transaction txn, long timeout, int modifiers) throws UnusableEntryException, TransactionException, InterruptedException, RemoteException {
        return this._actionManager.take(template, txn, timeout, modifiers, false);
    }

    @Override
    public Object take(Object template, Transaction txn, long timeout, int modifiers, boolean ifExists) throws UnusableEntryException, TransactionException, InterruptedException, RemoteException {
        return this._actionManager.take(template, txn, timeout, modifiers, ifExists);
    }

    @Override
    public AsyncFuture<?> asyncTake(Object template, Transaction txn, long timeout, int modifiers, AsyncFutureListener listener) throws RemoteException {
        return this._actionManager.asyncTake(template, txn, timeout, modifiers, listener);
    }

    @Override
    public Object takeById(String className, Object id, Object routing, int version, Transaction txn, long timeout, int modifiers, boolean ifExists, QueryResultTypeInternal resultType, String[] projections) throws RemoteException, UnusableEntryException, TransactionException, InterruptedException {
        return this._actionManager.takeById(className, id, routing, version, txn, timeout, modifiers, ifExists, resultType, projections);
    }

    @Override
    public Object takeByUid(String uid, Transaction txn, int modifiers, QueryResultTypeInternal resultType, boolean returnPacket) throws RemoteException, UnusableEntryException, TransactionException, InterruptedException {
        return this._actionManager.takeByUid(uid, txn, modifiers, resultType, returnPacket);
    }

    @Override
    public Object takeIfExists(Object template, Transaction txn, long timeout) throws UnusableEntryException, TransactionException, InterruptedException, RemoteException {
        return this._actionManager.take(template, txn, timeout, this.getReadModifiers(), true);
    }

    public Object takeIfExists(Object template, Transaction txn, long timeout, int modifiers) throws UnusableEntryException, TransactionException, InterruptedException, RemoteException {
        return this._actionManager.take(template, txn, timeout, modifiers, true);
    }

    @Override
    public Object[] takeMultiple(Object template, Transaction txn, int maxEntries) throws TransactionException, UnusableEntryException, RemoteException {
        return this._actionManager.takeMultiple(template, txn, 0L, maxEntries, maxEntries, this.getReadModifiers(), false, false);
    }

    @Override
    public Object[] takeMultiple(Object template, Transaction txn, int maxEntries, int modifiers) throws TransactionException, UnusableEntryException, RemoteException {
        return this._actionManager.takeMultiple(template, txn, 0L, maxEntries, maxEntries, modifiers, false, false);
    }

    @Override
    public Object[] takeMultiple(Object template, Transaction txn, int maxEntries, int modifiers, boolean returnOnlyUids) throws TransactionException, UnusableEntryException, RemoteException {
        return this._actionManager.takeMultiple(template, txn, 0L, maxEntries, maxEntries, modifiers, returnOnlyUids, false);
    }

    @Override
    public Object[] takeMultiple(Object template, Transaction txn, long timeout, int maxEntries, int minEntriesToWaitFor, int modifiers, boolean returnOnlyUids, boolean ifExist) throws TransactionException, UnusableEntryException, RemoteException {
        return this._actionManager.takeMultiple(template, txn, timeout, maxEntries, minEntriesToWaitFor, modifiers, returnOnlyUids, ifExist);
    }

    @Override
    public Object update(Object updatedEntry, Transaction transaction, long lease, long timeout) throws TransactionException, UnusableEntryException, RemoteException, InterruptedException {
        return this.update(updatedEntry, transaction, lease, timeout, this.getUpdateModifiers());
    }

    @Override
    public Object update(Object entry, Transaction txn, long lease, long timeout, int modifiers) throws TransactionException, UnusableEntryException, RemoteException, InterruptedException {
        if (!UpdateModifiers.isWriteOnly(modifiers) && !UpdateModifiers.isUpdateOrWrite(modifiers)) {
            modifiers = Modifiers.add(modifiers, 8);
        }
        if (!UpdateModifiers.isNoReturnValue(modifiers)) {
            modifiers = Modifiers.add(modifiers, 0x800000);
        }
        try {
            LeaseContext<?> result = this._actionManager.write(entry, txn, lease, timeout, modifiers);
            return result == null ? null : result.getObject();
        }
        catch (RemoteException e) {
            Throwable cause = e.getCause();
            if (cause instanceof EntryNotInSpaceException) {
                throw (EntryNotInSpaceException)((Object)cause);
            }
            if (cause instanceof EntryAlreadyInSpaceException) {
                throw (EntryAlreadyInSpaceException)cause;
            }
            if (cause instanceof EntryVersionConflictException) {
                throw (EntryVersionConflictException)((Object)cause);
            }
            throw e;
        }
        catch (InterruptedSpaceException e) {
            Throwable cause = e.getCause();
            if (cause instanceof InterruptedException) {
                throw (InterruptedException)cause;
            }
            throw e;
        }
    }

    @Override
    public Object[] updateMultiple(Object[] entries, Transaction txn, long[] leases) throws UnusableEntryException, TransactionException, RemoteException {
        return this.updateMultiple(entries, txn, leases, this.getUpdateModifiers());
    }

    @Override
    public Object[] updateMultiple(Object[] entries, Transaction txn, long[] leases, int modifiers) throws UnusableEntryException, TransactionException, RemoteException {
        Object[] results;
        block7: {
            results = new Object[entries.length];
            if (!UpdateModifiers.isWriteOnly(modifiers) && !UpdateModifiers.isUpdateOrWrite(modifiers)) {
                modifiers = Modifiers.add(modifiers, 8);
            }
            if (!UpdateModifiers.isNoReturnValue(modifiers)) {
                modifiers = Modifiers.add(modifiers, 0x800000);
            }
            try {
                LeaseContext<?>[] writeResult = this._actionManager.writeMultiple(entries, txn, Long.MAX_VALUE, leases, 0L, modifiers);
                if (writeResult == null) break block7;
                for (int i = 0; i < results.length; ++i) {
                    results[i] = writeResult[i] == null ? null : writeResult[i].getObject();
                }
            }
            catch (WriteMultipleException e) {
                for (int i = 0; i < results.length; ++i) {
                    WriteMultipleException.IWriteResult result = e.getResults()[i];
                    if (result.isError()) {
                        results[i] = result.getError();
                        if (!(results[i] instanceof OperationTimeoutException)) continue;
                        results[i] = null;
                        continue;
                    }
                    results[i] = result.getLeaseContext().getObject();
                }
            }
        }
        return results;
    }

    @Override
    public LeaseContext<?> write(Object entry, Transaction txn, long lease) throws TransactionException, RemoteException {
        return this._actionManager.write(entry, txn, lease, 0L, this.getUpdateModifiers());
    }

    @Override
    public LeaseContext<?> write(Object entry, Transaction txn, long lease, long timeout, int modifiers) throws TransactionException, RemoteException {
        return this._actionManager.write(entry, txn, lease, timeout, modifiers);
    }

    public LeaseContext<?>[] writeMultiple(Object[] objects, Transaction txn, long lease) throws TransactionException, RemoteException {
        return this._actionManager.writeMultiple(objects, txn, lease, null, 0L, this.getUpdateModifiers());
    }

    public LeaseContext<?>[] writeMultiple(Object[] objects, Transaction txn, long lease, int modifiers) throws TransactionException, RemoteException {
        return this._actionManager.writeMultiple(objects, txn, lease, null, 0L, modifiers);
    }

    public LeaseContext<?>[] writeMultiple(Object[] objects, Transaction txn, long[] leases, int modifiers) throws TransactionException, RemoteException {
        return this._actionManager.writeMultiple(objects, txn, Long.MIN_VALUE, leases, 0L, modifiers);
    }

    public LeaseContext<?>[] writeMultiple(Object[] objects, Transaction txn, long lease, long[] leases, int modifiers) throws TransactionException, RemoteException {
        return this._actionManager.writeMultiple(objects, txn, lease, leases, 0L, modifiers);
    }

    public LeaseContext<?>[] writeMultiple(Object[] objects, Transaction txn, long lease, long[] leases, long timeout, int modifiers) throws TransactionException, RemoteException {
        return this._actionManager.writeMultiple(objects, txn, lease, leases, timeout, modifiers);
    }

    @Override
    public Object[] readByIds(String className, Object[] ids, Object routing, Transaction txn, int modifiers, QueryResultTypeInternal resultType, boolean returnPackets, String[] projections) throws RemoteException, UnusableEntryException, TransactionException, InterruptedException {
        return this._actionManager.readByIds(className, ids, routing, txn, modifiers, resultType, returnPackets, projections);
    }

    @Override
    public Object[] readByIds(String className, Object[] ids, Object[] routings, Transaction txn, int modifiers, QueryResultTypeInternal resultType, boolean returnPackets, String[] projections) throws RemoteException, UnusableEntryException, TransactionException, InterruptedException {
        return this._actionManager.readByIds(className, ids, routings, txn, modifiers, resultType, returnPackets, projections);
    }

    @Override
    public Object[] readByIds(ReadTakeByIdsProxyActionInfo actionInfo, boolean returnPackets) throws RemoteException, TransactionException, InterruptedException, UnusableEntryException {
        return this._actionManager.readByIds(actionInfo, returnPackets);
    }

    @Override
    public Object[] takeByIds(String className, Object[] ids, Object routing, Transaction txn, int modifiers, QueryResultTypeInternal resultType, boolean returnPackets, String[] projections) throws RemoteException, UnusableEntryException, TransactionException, InterruptedException {
        return this._actionManager.takeByIds(className, ids, routing, txn, modifiers, resultType, returnPackets, projections);
    }

    @Override
    public Object[] takeByIds(String className, Object[] ids, Object[] routings, Transaction txn, int modifiers, QueryResultTypeInternal resultType, boolean returnPackets, String[] projections) throws RemoteException, UnusableEntryException, TransactionException, InterruptedException {
        return this._actionManager.takeByIds(className, ids, routings, txn, modifiers, resultType, returnPackets, projections);
    }

    @Override
    public Object[] takeByIds(ReadTakeByIdsProxyActionInfo actionInfo, boolean returnPackets) throws RemoteException, TransactionException, InterruptedException, UnusableEntryException {
        return this._actionManager.takeByIds(actionInfo, returnPackets);
    }

    @Override
    public ReadTakeEntriesUidsResult readEntriesUids(ITemplatePacket template, Transaction transaction, int entriesLimit, int modifiers) throws RemoteException, TransactionException, UnusableEntryException {
        return this._actionManager.readEntriesUids(template, transaction, entriesLimit, modifiers);
    }

    @Override
    public <T> ChangeResult<T> change(Object template, ChangeSet changeSet, Transaction txn, long timeout, ChangeModifiers modifiers) throws RemoteException, TransactionException {
        return this._actionManager.change(template, changeSet, txn, timeout, modifiers);
    }

    @Override
    public <T> Future<ChangeResult<T>> asyncChange(Object template, ChangeSet changeSet, Transaction txn, long timeout, ChangeModifiers modifiers, AsyncFutureListener<ChangeResult<T>> listener) throws RemoteException {
        return this._actionManager.asyncChange(template, changeSet, txn, timeout, modifiers, listener);
    }

    @Override
    public AggregationResult aggregate(Object template, AggregationSet aggregationSet, Transaction txn, int readModifiers) throws RemoteException, TransactionException, InterruptedException {
        return this._actionManager.aggregate(template, aggregationSet, txn, readModifiers);
    }

    @Override
    public synchronized void setAppDomainId(int appDomainId) {
        this._associatedAppDomainId = appDomainId;
        this._isAppDomainAssociated = true;
    }

    @Override
    public boolean hasAssociatedAppDomain() {
        return this._isAppDomainAssociated;
    }

    @Override
    public int getAppDomainId() {
        if (!this._isAppDomainAssociated) {
            throw new IllegalStateException("Cannot get associated AppDomain id if the object is not associated to any AppDomain");
        }
        return this._associatedAppDomainId;
    }

    @Override
    public void setDotnetProxyHandleId(long handleId) {
        this._dotnetProxyHandleId = handleId;
        this._isTargetOfADotnetProxy = true;
    }

    @Override
    public boolean isTargetOfADotnetProxy() {
        return this._isTargetOfADotnetProxy;
    }

    @Override
    public long getDotnetProxyHandleId() {
        if (!this._isTargetOfADotnetProxy) {
            throw new IllegalStateException("Cannot get .NET target proxy id if the object is not a target of a .NET proxy");
        }
        return this._dotnetProxyHandleId;
    }

    @Override
    public void applyNotifyInfoDefaults(NotifyInfo notifyInfo) {
    }

    @Override
    public boolean checkIfConnected() {
        try {
            this.ping();
            return true;
        }
        catch (RemoteException e) {
            return false;
        }
        catch (Exception e) {
            if (_logger.isLoggable(Level.WARNING)) {
                _logger.log(Level.WARNING, " Unexpected exception during checkIfConnected.", e);
            }
            return false;
        }
    }

    public boolean isCacheContainer() {
        return false;
    }

    public IDirectSpaceProxy getLocalSpace() {
        return null;
    }

    public IDirectSpaceProxy getRemoteSpace() {
        return null;
    }

    public boolean isLocalCacheCacheContainer() {
        return false;
    }

    public boolean isLocalViewContainer() {
        return false;
    }
}

