/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.client.spaceproxy;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.client.DirectSpaceProxyFactory;
import com.gigaspaces.internal.client.spaceproxy.SpaceProxyImpl;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.server.space.IRemoteSpace;
import com.j_spaces.core.client.ProxySettings;
import com.j_spaces.core.client.SpaceSettings;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

@InternalApi
public class DirectSpaceProxyFactoryImpl
implements DirectSpaceProxyFactory,
Externalizable {
    private static final long serialVersionUID = 1L;
    private IRemoteSpace remoteSpace;
    private SpaceSettings spaceSettings;
    private boolean clustered;

    public DirectSpaceProxyFactoryImpl() {
    }

    public DirectSpaceProxyFactoryImpl(IRemoteSpace remoteSpace, SpaceSettings spaceSettings, boolean clustered) {
        this.remoteSpace = remoteSpace;
        this.spaceSettings = spaceSettings;
        this.clustered = clustered;
    }

    public DirectSpaceProxyFactoryImpl createCopy(boolean clustered) {
        return new DirectSpaceProxyFactoryImpl(this.remoteSpace, this.spaceSettings, clustered);
    }

    public DirectSpaceProxyFactoryImpl createCopyWithoutClusterPolicyIfNeeded() {
        if (this.spaceSettings.getSpaceConfig().getClusterPolicy() == null) {
            return this;
        }
        SpaceSettings spaceSettings = this.spaceSettings.clone();
        spaceSettings.getSpaceConfig().setClusterPolicy(null);
        return new DirectSpaceProxyFactoryImpl(this.remoteSpace, spaceSettings, this.clustered);
    }

    public boolean isClustered() {
        return this.clustered;
    }

    @Override
    public SpaceProxyImpl createSpaceProxy() {
        return new SpaceProxyImpl(this, new ProxySettings(this.remoteSpace, this.spaceSettings));
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        IOUtils.writeObject(out, this.remoteSpace);
        IOUtils.writeObject(out, this.spaceSettings);
        out.writeBoolean(this.clustered);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.remoteSpace = (IRemoteSpace)IOUtils.readObject(in);
        this.spaceSettings = (SpaceSettings)IOUtils.readObject(in);
        this.clustered = in.readBoolean();
    }
}

