/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.client.spaceproxy;

import com.gigaspaces.admin.demote.DemoteFailedException;
import com.gigaspaces.admin.quiesce.QuiesceToken;
import com.gigaspaces.api.InternalApi;
import com.gigaspaces.client.DirectSpaceProxyFactory;
import com.gigaspaces.internal.client.spaceproxy.AbstractDirectSpaceProxy;
import com.gigaspaces.internal.client.spaceproxy.DirectSpaceProxyFactoryImpl;
import com.gigaspaces.internal.client.spaceproxy.IDirectSpaceProxy;
import com.gigaspaces.internal.client.spaceproxy.actioninfo.CommonProxyActionInfo;
import com.gigaspaces.internal.client.spaceproxy.actioninfo.SnapshotProxyActionInfo;
import com.gigaspaces.internal.client.spaceproxy.actions.AbstractSpaceProxyActionManager;
import com.gigaspaces.internal.client.spaceproxy.actions.SpaceProxyImplActionManager;
import com.gigaspaces.internal.client.spaceproxy.events.SpaceProxyDataEventsManager;
import com.gigaspaces.internal.client.spaceproxy.metadata.ISpaceProxyTypeManager;
import com.gigaspaces.internal.client.spaceproxy.metadata.ObjectType;
import com.gigaspaces.internal.client.spaceproxy.metadata.SpaceProxyTypeManager;
import com.gigaspaces.internal.client.spaceproxy.operations.GetEntryTypeDescriptorSpaceOperationRequest;
import com.gigaspaces.internal.client.spaceproxy.operations.RegisterEntryTypeDescriptorSpaceOperationRequest;
import com.gigaspaces.internal.client.spaceproxy.operations.SpaceOperationRequest;
import com.gigaspaces.internal.client.spaceproxy.router.SpaceProxyRouter;
import com.gigaspaces.internal.client.spaceproxy.transaction.SpaceProxyTransactionManager;
import com.gigaspaces.internal.cluster.SpaceClusterInfo;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.server.space.IRemoteSpace;
import com.gigaspaces.internal.server.space.SpaceImpl;
import com.gigaspaces.internal.transport.ITemplatePacket;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import com.gigaspaces.lrmi.LRMIInvocationContext;
import com.gigaspaces.lrmi.LRMIRuntime;
import com.gigaspaces.metadata.SpaceMetadataException;
import com.gigaspaces.query.ISpaceQuery;
import com.gigaspaces.security.directory.CredentialsProvider;
import com.gigaspaces.security.service.SecurityContext;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.IJSpaceContainer;
import com.j_spaces.core.IStubHandler;
import com.j_spaces.core.OperationID;
import com.j_spaces.core.SpaceContext;
import com.j_spaces.core.admin.ContainerConfig;
import com.j_spaces.core.admin.IInternalRemoteJSpaceAdmin;
import com.j_spaces.core.admin.IJSpaceContainerAdmin;
import com.j_spaces.core.admin.JSpaceAdminProxy;
import com.j_spaces.core.client.ActionListener;
import com.j_spaces.core.client.EntrySnapshot;
import com.j_spaces.core.client.IJSpaceProxyListener;
import com.j_spaces.core.client.IProxySecurityManager;
import com.j_spaces.core.client.LookupFinder;
import com.j_spaces.core.client.Modifiers;
import com.j_spaces.core.client.NullProxySecurityManager;
import com.j_spaces.core.client.ProxySettings;
import com.j_spaces.core.client.SpaceProxySecurityManager;
import com.j_spaces.core.client.SpaceURL;
import com.j_spaces.core.client.UpdateModifiers;
import com.j_spaces.core.client.sql.IQueryManager;
import com.j_spaces.core.client.sql.QueryManager;
import com.j_spaces.jdbc.builder.SQLQueryTemplatePacket;
import com.sun.jini.proxy.DefaultProxyPivot;
import com.sun.jini.proxy.MarshalPivot;
import com.sun.jini.proxy.MarshalPivotProvider;
import com.sun.jini.start.ServiceProxyAccessor;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.rmi.RemoteException;
import java.security.SecureRandom;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.admin.Administrable;
import net.jini.core.transaction.Transaction;
import net.jini.core.transaction.TransactionException;
import net.jini.core.transaction.server.ServerTransaction;
import net.jini.core.transaction.server.TransactionParticipant;
import net.jini.id.Uuid;
import net.jini.lookup.SameProxyVersionProvider;

@InternalApi
public class SpaceProxyImpl
extends AbstractDirectSpaceProxy
implements SameProxyVersionProvider,
MarshalPivotProvider {
    private static final long serialVersionUID = 1L;
    private static final Logger _clientLogger = Logger.getLogger("com.gigaspaces.client");
    private final DirectSpaceProxyFactoryImpl _factory;
    private final long _clientID;
    private final AtomicLong _operationID;
    private final Object _spaceInitializeLock;
    private final SpaceProxyTransactionManager _transactionManager;
    private final IProxySecurityManager _securityManager;
    private final ISpaceProxyTypeManager _typeManager;
    private final IQueryManager _queryManager;
    private final SpaceProxyDataEventsManager _dataEventsManager;
    private boolean _initializedNewRouter;
    private SpaceProxyRouter _proxyRouter;
    private volatile boolean closed = false;
    private static final int SERIAL_VERSION = 1;
    private static final byte FLAG_ISCLUSTER = 2;
    private static final byte FLAG_REMOTESPACEPROXY = 32;

    public SpaceProxyImpl(DirectSpaceProxyFactoryImpl factory, ProxySettings proxySettings) {
        super(proxySettings);
        this._factory = factory;
        SecureRandom random = new SecureRandom();
        this._clientID = random.nextLong();
        this._operationID = new AtomicLong();
        this._spaceInitializeLock = new Object();
        this._transactionManager = new SpaceProxyTransactionManager();
        this._securityManager = this._proxySettings.isSecuredService() ? new SpaceProxySecurityManager(this) : new NullProxySecurityManager(this);
        this._queryManager = new QueryManager(this);
        this._typeManager = new SpaceProxyTypeManager(this);
        this._dataEventsManager = new SpaceProxyDataEventsManager(this, this._proxySettings.getExportedTransportConfig());
        this.getURL().setPropertiesForSpaceProxy(this);
        try {
            if (this._proxySettings.getTimeProvider() != null) {
                System.setProperty("com.gs.time-provider", this._proxySettings.getTimeProvider());
            }
        }
        catch (SecurityException se) {
            _clientLogger.log(Level.INFO, "Failed to set time provider system property", se);
        }
    }

    private SpaceProxyImpl getOrCreateProxy(boolean isClustered) {
        if (this.isClustered() == isClustered) {
            return this;
        }
        SpaceProxyImpl copy = new SpaceProxyImpl(this._factory.createCopy(isClustered), this._proxySettings);
        if (this.isSecured()) {
            copy.getSecurityManager().initialize(this.getSecurityManager().getCredentialsProvider());
        }
        return copy;
    }

    @Override
    public ExecutorService getThreadPool() {
        return LRMIRuntime.getRuntime().getThreadPool();
    }

    @Override
    public IDirectSpaceProxy getDirectProxy() {
        return this;
    }

    @Override
    public String getCacheTypeName() {
        return "space";
    }

    @Override
    public IDirectSpaceProxy getNotificationsDirectProxy() {
        return this;
    }

    @Override
    public IQueryManager getQueryManager() {
        return this._queryManager;
    }

    @Override
    public SpaceProxyDataEventsManager getDataEventsManager() {
        return this._dataEventsManager;
    }

    @Override
    public IProxySecurityManager getSecurityManager() {
        return this._securityManager;
    }

    @Override
    public ISpaceProxyTypeManager getTypeManager() {
        return this._typeManager;
    }

    @Override
    public void setActionListener(ActionListener actionListener) {
        this._transactionManager.setActionListener(actionListener);
    }

    @Override
    public Transaction.Created getContextTransaction() {
        return this._transactionManager.getContextTransaction();
    }

    @Override
    public Transaction.Created replaceContextTransaction(Transaction.Created txn) {
        return this._transactionManager.replaceContextTransaction(txn);
    }

    @Override
    public Transaction.Created replaceContextTransaction(Transaction.Created transaction, ActionListener actionListener, boolean delegatedXa) {
        return this._transactionManager.replaceContextTransaction(transaction, actionListener, delegatedXa);
    }

    @Override
    public Uuid getReferentUuid() {
        return this._proxySettings.getUuid();
    }

    @Override
    public String getName() {
        return this._proxySettings.getSpaceName();
    }

    @Override
    public boolean isEmbedded() {
        return this._proxySettings.isCollocated();
    }

    @Override
    public boolean isSecured() {
        return this._proxySettings.isSecuredService();
    }

    @Override
    public boolean isServiceSecured() throws RemoteException {
        return this._proxySettings.isSecuredService();
    }

    @Override
    public boolean isStartedWithinGSC() throws RemoteException {
        return ((IInternalRemoteJSpaceAdmin)this.getAdmin()).isStartedWithinGSC();
    }

    @Override
    public Object getAdmin() throws RemoteException {
        Object admin;
        IRemoteSpace rj = this.getRemoteJSpace();
        if (rj == null) {
            throw new RemoteException("Admin object is not available. Space: " + this._proxySettings.getMemberName() + " might be down.");
        }
        try {
            admin = ((Administrable)rj).getAdmin();
        }
        catch (RemoteException e) {
            rj = this.getProxyRouter().getAnyAvailableSpace();
            if (rj == null) {
                throw e;
            }
            admin = ((Administrable)rj).getAdmin();
        }
        if (admin instanceof JSpaceAdminProxy) {
            ((JSpaceAdminProxy)admin).setSpace(this);
        }
        return admin;
    }

    @Override
    public Object getPrivilegedAdmin() throws RemoteException {
        return this.getAdmin();
    }

    @Override
    public IJSpace getNonClusteredProxy() {
        return this.getOrCreateProxy(false);
    }

    @Override
    public IJSpace getClusteredProxy() {
        return this.getOrCreateProxy(true);
    }

    @Override
    public IStubHandler getStubHandler() {
        return this._proxySettings.getStubHandler();
    }

    @Override
    public IJSpaceContainer getContainer() {
        return this._proxySettings.getContainerProxy();
    }

    @Override
    public void shutdown() throws RemoteException {
        this._proxySettings.getContainerProxy().shutdown();
    }

    @Override
    public ContainerConfig getContainerConfig() throws RemoteException {
        return ((IJSpaceContainerAdmin)((Object)this._proxySettings.getContainerProxy())).getConfig();
    }

    @Override
    public SpaceURL getContainerURL() throws RemoteException {
        return this._proxySettings.getContainerProxy().getURL();
    }

    @Override
    public SpaceURL getFinderURL() {
        return this._proxySettings.getFinderURL();
    }

    public void setFinderURL(SpaceURL _finderurl) {
        this._proxySettings.setFinderURL(_finderurl);
    }

    @Override
    public SpaceURL getURL() {
        return this._proxySettings.getSpaceURL();
    }

    @Override
    public boolean isOptimisticLockingEnabled() {
        return this._proxySettings.isVersioned();
    }

    @Override
    public void setOptimisticLocking(boolean enabled) {
        this._proxySettings.setVersioned(enabled);
    }

    @Override
    public boolean isFifo() {
        return this._proxySettings.isFifo();
    }

    @Override
    public void setFifo(boolean enabled) {
        this._proxySettings.setFifo(enabled);
    }

    @Override
    public int getReadModifiers() {
        return this._proxySettings.getReadModifiers();
    }

    @Override
    public int setReadModifiers(int readModifiers) {
        int originalMode = this._proxySettings.getReadModifiers();
        this._proxySettings.setReadModifiers(readModifiers);
        return originalMode;
    }

    @Override
    public int getUpdateModifiers() {
        return this._proxySettings.getUpdateModifiers();
    }

    @Override
    public int setUpdateModifiers(int newModifiers) {
        if (UpdateModifiers.isUpdateOrWrite(newModifiers) && UpdateModifiers.isPartialUpdate(newModifiers)) {
            throw new RuntimeException("setUpdateMode:invalid update modifiers- PARTIAL Update cannot be specified with UPDATE_OR_WRITE ");
        }
        int originalMode = this._proxySettings.getUpdateModifiers();
        this._proxySettings.setUpdateModifiers(newModifiers);
        return originalMode;
    }

    @Override
    public boolean isGatewayProxy() {
        return this._proxySettings.isGatewayProxy();
    }

    public void setGatewayProxy() {
        this._proxySettings.setGatewayProxy(true);
    }

    @Override
    public Object getVersion() {
        return this._proxySettings.getUuid();
    }

    protected AbstractSpaceProxyActionManager<SpaceProxyImpl> createActionManager() {
        return new SpaceProxyImplActionManager(this);
    }

    @Override
    public OperationID createNewOperationID() {
        return new OperationID(this._clientID, this._operationID.getAndIncrement());
    }

    @Override
    public long getClientID() {
        return this._clientID;
    }

    @Override
    public void directClean() {
        this.getTypeManager().deleteAllTypeDescs();
        this.getQueryManager().clean();
    }

    public void directDropClass(String className) {
        this.getTypeManager().deleteTypeDesc(className);
    }

    @Override
    public SecurityContext login(CredentialsProvider credentialsProvider) throws RemoteException {
        return this.getSecurityManager().login(credentialsProvider);
    }

    public Transaction beforeSpaceAction() {
        return this._transactionManager.beforeSpaceAction(null);
    }

    public void beforeSpaceAction(CommonProxyActionInfo action) {
        action.txn = this._transactionManager.beforeSpaceAction(action.txn);
    }

    public Transaction beforeSpaceAction(Transaction txn) {
        return this._transactionManager.beforeSpaceAction(txn);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof SpaceProxyImpl) {
            return super.equals(obj);
        }
        return false;
    }

    @Override
    public String getRemoteMemberName() {
        return this._proxySettings.getMemberName();
    }

    @Override
    public IRemoteSpace getRemoteJSpace() {
        return this._proxySettings.getRemoteSpace();
    }

    @Override
    public SpaceImpl getSpaceImplIfEmbedded() {
        return this._proxySettings.getSpaceImplIfEmbedded();
    }

    @Override
    public boolean isClustered() {
        return this._factory.isClustered();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    @Override
    public synchronized void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this._dataEventsManager != null) {
            this._dataEventsManager.close();
        }
        if (this._typeManager != null) {
            this._typeManager.close();
        }
        if (this._proxyRouter != null) {
            this._proxyRouter.close();
        }
        LookupFinder.close();
    }

    public MarshalPivot getMarshalPivot() throws RemoteException {
        return new DefaultProxyPivot((ServiceProxyAccessor)this.getRemoteJSpace());
    }

    @Override
    public ITypeDesc getTypeDescFromServer(String typeName) {
        try {
            GetEntryTypeDescriptorSpaceOperationRequest request = new GetEntryTypeDescriptorSpaceOperationRequest(typeName);
            this.getProxyRouter().execute(request);
            return request.getFinalResult();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SpaceMetadataException("Error in getTypeDescFromServer() remote task execution. TypeName='" + typeName + "'.", e);
        }
        catch (Throwable e) {
            throw new SpaceMetadataException("Error in getTypeDescFromServer() remote task execution. TypeName='" + typeName + "'.", e);
        }
    }

    @Override
    public ITypeDesc registerTypeDescInServers(ITypeDesc typeDesc) {
        try {
            RegisterEntryTypeDescriptorSpaceOperationRequest request = new RegisterEntryTypeDescriptorSpaceOperationRequest().setTypeDesc(typeDesc).setGatewayProxy(this.isGatewayProxy());
            this.getProxyRouter().execute(request);
            request.processExecutionException();
            return typeDesc;
        }
        catch (Throwable e) {
            throw new SpaceMetadataException("Error in registerTypeDescInServers() remote task execution. TypeName=" + typeDesc.getTypeName(), e);
        }
    }

    @Override
    public Class<?> loadRemoteClass(String className) throws ClassNotFoundException {
        try {
            return this.getRemoteJSpace().loadRemoteClass(className);
        }
        catch (Exception e) {
            if (e instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)e;
            }
            throw new ClassNotFoundException("Could not locate class " + className, e);
        }
    }

    @Override
    public int initWriteModifiers(int modifiers) {
        if (modifiers == 0) {
            modifiers = 4096;
        } else if (Modifiers.contains(modifiers, 8)) {
            if (Modifiers.contains(modifiers, 4)) {
                throw new IllegalArgumentException("Illegal modifiers - cannot use UPDATE_ONLY with WRITE_ONLY.");
            }
            if (Modifiers.contains(modifiers, 4096)) {
                throw new IllegalArgumentException("Illegal modifiers - cannot use UPDATE_ONLY with UPDATE_OR_WRITE.");
            }
        } else if (Modifiers.contains(modifiers, 4)) {
            if (Modifiers.contains(modifiers, 4096)) {
                throw new IllegalArgumentException("Illegal modifiers - cannot use WRITE_ONLY with UPDATE_OR_WRITE.");
            }
            if (Modifiers.contains(modifiers, 16)) {
                throw new IllegalArgumentException("Illegal modifiers - cannot use WRITE_ONLY with PARTIAL_UPDATE.");
            }
        } else if (Modifiers.contains(modifiers, 4096)) {
            if (Modifiers.contains(modifiers, 16)) {
                throw new IllegalArgumentException("Illegal modifiers - cannot use WRITE_ONLY with PARTIAL_UPDATE.");
            }
        } else {
            modifiers = Modifiers.contains(modifiers, 16) ? Modifiers.add(modifiers, 8) : Modifiers.add(modifiers, 4096);
        }
        if (UpdateModifiers.isNoReturnValue(modifiers)) {
            modifiers |= 0x40000;
        }
        return modifiers;
    }

    @Override
    public DirectSpaceProxyFactory getFactory() {
        return this._factory;
    }

    @Override
    public SpaceClusterInfo getSpaceClusterInfo() {
        return this._proxySettings.getSpaceClusterInfo(this.isClustered());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SpaceProxyRouter getProxyRouter() {
        if (this._initializedNewRouter) {
            return this._proxyRouter;
        }
        Object object = this._spaceInitializeLock;
        synchronized (object) {
            if (this._initializedNewRouter) {
                return this._proxyRouter;
            }
            this._proxyRouter = new SpaceProxyRouter(this);
            this._initializedNewRouter = true;
            return this._proxyRouter;
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        if (LRMIInvocationContext.getEndpointLogicalVersion().greaterOrEquals(PlatformLogicalVersion.v11_0_0)) {
            throw new IllegalStateException("Class " + this.getClass().getName() + " should no longer be serialized");
        }
        super.writeExternal(out);
        out.writeInt(1);
        byte flags = this.buildFlags();
        out.writeByte(flags);
        out.writeObject(this._proxySettings.getOldProxyHolder());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        throw new IllegalStateException("This class should no longer be serialized");
    }

    private byte buildFlags() {
        byte flags = 32;
        if (this.isClustered()) {
            flags = (byte)(flags | 2);
        }
        return flags;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean beforeExecute(SpaceOperationRequest<?> spaceRequest, IRemoteSpace targetSpace, int partitionId, String clusterName, boolean isEmbedded) throws RemoteException {
        try {
            SpaceContext spaceContext = this.getProxyRouter().getDefaultSpaceContext();
            if (spaceRequest.supportsSecurity()) {
                QuiesceToken token = spaceContext != null ? spaceContext.getQuiesceToken() : null;
                spaceContext = this.getSecurityManager().acquireContext(targetSpace);
                if (spaceContext != null) {
                    spaceContext.setQuiesceToken(token);
                }
            }
            spaceRequest.setSpaceContext(spaceContext);
        }
        catch (com.gigaspaces.security.SecurityException e) {
            spaceRequest.setRemoteOperationExecutionError(e);
            return false;
        }
        if (spaceRequest.getTransaction() == null) return spaceRequest.beforeOperationExecution(isEmbedded);
        ServerTransaction transaction = (ServerTransaction)spaceRequest.getTransaction();
        try {
            if (!transaction.joinIfNeededAndEmbedded((TransactionParticipant)targetSpace, partitionId, clusterName, (Object)this)) return spaceRequest.beforeOperationExecution(isEmbedded);
        }
        catch (TransactionException e) {
            spaceRequest.setRemoteOperationExecutionError((Exception)((Object)e));
            return false;
        }
        return spaceRequest.beforeOperationExecution(isEmbedded);
    }

    public static void afterExecute(SpaceOperationRequest<?> spaceRequest, IRemoteSpace targetSpace, int partitionId, boolean isRejected) {
        ServerTransaction transaction;
        spaceRequest.afterOperationExecution(partitionId);
        if (spaceRequest.getTransaction() != null && (isRejected || !spaceRequest.hasLockedResources()) && (transaction = (ServerTransaction)spaceRequest.getTransaction()).isEmbeddedMgrInProxy()) {
            try {
                transaction.mgr.disJoin(transaction.id, (TransactionParticipant)targetSpace);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void setQuiesceToken(QuiesceToken token) {
        this.getProxyRouter().setQuiesceToken(token);
    }

    @Override
    public ISpaceQuery prepareTemplate(Object template) {
        SnapshotProxyActionInfo actionInfo = new SnapshotProxyActionInfo(this, template);
        ITemplatePacket queryPacket = actionInfo.queryPacket;
        if (actionInfo.isSqlQuery) {
            queryPacket = this.getQueryManager().getSQLTemplate((SQLQueryTemplatePacket)actionInfo.queryPacket, null);
            queryPacket = this.getTypeManager().getTemplatePacketFromObject(queryPacket, ObjectType.TEMPLATE_PACKET);
        }
        queryPacket.setSerializeTypeDesc(false);
        return new EntrySnapshot(queryPacket);
    }

    @Override
    public void demote(long maxSuspendTime, TimeUnit timeUnit, CredentialsProvider credentialsProvider) throws DemoteFailedException, RemoteException {
        IRemoteSpace remoteJSpace = this.getRemoteJSpace();
        SpaceContext spaceContext = this.getSecurityManager().acquireContext(remoteJSpace, credentialsProvider);
        remoteJSpace.demote(maxSuspendTime, timeUnit, spaceContext);
    }

    public static final class Listener
    implements IJSpaceProxyListener {
        Listener() {
        }

        @Override
        public boolean isProxyAlive() {
            return true;
        }
    }
}

