/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.client.spaceproxy.actioninfo;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.client.ChangeModifiers;
import com.gigaspaces.client.ChangeSet;
import com.gigaspaces.client.ChangeSetInternalUtils;
import com.gigaspaces.client.mutators.SpaceEntryMutator;
import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.gigaspaces.internal.client.spaceproxy.actioninfo.QueryProxyActionInfo;
import com.j_spaces.core.client.Modifiers;
import java.util.Collection;
import java.util.logging.Level;
import net.jini.core.transaction.Transaction;

@InternalApi
public class ChangeProxyActionInfo
extends QueryProxyActionInfo {
    public final long timeout;
    public final long lease;
    public final Collection<SpaceEntryMutator> mutators;

    public ChangeProxyActionInfo(ISpaceProxy spaceProxy, Object template, ChangeSet changeSet, Transaction txn, long timeout, ChangeModifiers modifiers) {
        super(spaceProxy, template, txn, modifiers.getCode(), true);
        if (template == null) {
            throw new IllegalArgumentException("change operation cannot accept null template.");
        }
        this.timeout = timeout;
        if (timeout < 0L) {
            throw new IllegalArgumentException("timeout parameter must be greater than or equal to zero.");
        }
        this.mutators = ChangeSetInternalUtils.getMutators(changeSet);
        this.lease = ChangeSetInternalUtils.getLease(changeSet);
        if (this.lease < 0L) {
            throw new IllegalArgumentException("lease parameter must be greater than or equal to zero.");
        }
        if (this.mutators.isEmpty() && this.lease == 0L) {
            throw new IllegalArgumentException("change operation cannot accept empty changeSet.");
        }
        boolean oneWay = Modifiers.contains(this.modifiers, 1);
        if (oneWay) {
            if (txn != null || spaceProxy.getContextTransaction() != null) {
                throw new UnsupportedOperationException("Oneway change is not supported when the change is being done under a transaction.");
            }
            if (Modifiers.contains(this.modifiers, 0x2000000)) {
                throw new IllegalArgumentException("Oneway change is not allowed with ChangeModifiers.RETURN_DETAILED_RESULTS modifier.");
            }
        }
        if (_devLogger.isLoggable(Level.FINEST) && this.verifyLogScannedEntriesCountParams(this.timeout)) {
            this.modifiers |= 0x4000000;
        }
    }

    public Collection<SpaceEntryMutator> getMutators() {
        return this.mutators;
    }
}

