/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.client.spaceproxy.actioninfo;

import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.gigaspaces.internal.client.spaceproxy.metadata.ISpaceProxyTypeManager;
import com.gigaspaces.internal.client.spaceproxy.metadata.ObjectType;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.gigaspaces.internal.transport.ITransportPacket;
import com.j_spaces.core.client.ReadModifiers;
import net.jini.core.transaction.Transaction;

public abstract class CommonProxyActionInfo
implements Cloneable {
    public Transaction txn;
    public int modifiers;

    protected CommonProxyActionInfo(Transaction txn, int modifiers) {
        this.txn = txn;
        this.modifiers = modifiers;
    }

    public CommonProxyActionInfo clone() {
        try {
            CommonProxyActionInfo copy = (CommonProxyActionInfo)super.clone();
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Failed to clone a cloneable class", e);
        }
    }

    protected void initOperationId(ISpaceProxy spaceProxy, ITransportPacket packet) {
        boolean forceCreateNewOpId;
        boolean bl = forceCreateNewOpId = this.txn != null;
        if (packet.getOperationID() == null || forceCreateNewOpId) {
            packet.setOperationID(spaceProxy.createNewOperationID());
        }
    }

    protected IEntryPacket toEntryPacket(ISpaceProxy spaceProxy, Object entry, ObjectType objectType) {
        ISpaceProxyTypeManager typeManager = spaceProxy.getDirectProxy().getTypeManager();
        IEntryPacket packet = typeManager.getEntryPacketFromObject(entry, objectType);
        this.initOperationId(spaceProxy, packet);
        return packet;
    }

    protected void validateReadModifiers(ISpaceProxy spaceProxy) {
        if (ReadModifiers.isExclusiveReadLock(this.modifiers) && this.txn == null && spaceProxy.getContextTransaction() == null) {
            throw new IllegalArgumentException("Using EXCLUSIVE_READ_LOCK modifier without a transaction is illegal.");
        }
    }
}

