/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.client.spaceproxy.actioninfo;

import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.gigaspaces.internal.client.spaceproxy.actioninfo.CommonProxyActionInfo;
import com.gigaspaces.internal.client.spaceproxy.metadata.ObjectType;
import com.gigaspaces.internal.transport.AbstractProjectionTemplate;
import com.gigaspaces.internal.transport.ITemplatePacket;
import com.j_spaces.core.client.ClientUIDHandler;
import com.j_spaces.core.client.Modifiers;
import com.j_spaces.core.client.ReadModifiers;
import com.j_spaces.core.client.SQLQuery;
import com.j_spaces.jdbc.builder.SQLQueryTemplatePacket;
import com.j_spaces.map.Envelope;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.transaction.Transaction;

public abstract class QueryProxyActionInfo
extends CommonProxyActionInfo {
    protected static final Logger _devLogger = Logger.getLogger("com.gigaspaces.dev");
    protected Object _query;
    protected final ObjectType _queryObjectType;
    public ITemplatePacket queryPacket;
    public final boolean isSqlQuery;

    protected QueryProxyActionInfo(ISpaceProxy spaceProxy, Transaction txn, int modifiers) {
        super(txn, modifiers);
        this._query = null;
        this._queryObjectType = null;
        this.isSqlQuery = false;
    }

    protected QueryProxyActionInfo(ISpaceProxy spaceProxy, Object query, Transaction txn, int modifiers, boolean requiresOperationId) {
        this(spaceProxy, query, txn, modifiers, requiresOperationId, false);
    }

    protected QueryProxyActionInfo(ISpaceProxy spaceProxy, Object query, Transaction txn, int modifiers, boolean requiresOperationId, boolean supportIdsQuery) {
        super(txn, modifiers);
        Object id;
        this._query = query;
        if (query instanceof SQLQuery && ((SQLQuery)query).getExplainPlan() != null) {
            this.modifiers = Modifiers.add(this.modifiers, 0x10000000);
        }
        this.isSqlQuery = this.preProcessQuery();
        this._queryObjectType = ObjectType.fromObject(this._query, supportIdsQuery);
        this.queryPacket = spaceProxy.getDirectProxy().getTypeManager().getTemplatePacketFromObject(this._query, this._queryObjectType);
        if (query instanceof Envelope && (id = this.queryPacket.getID()) != null) {
            this.queryPacket.setUID(ClientUIDHandler.createUIDFromName(id, Envelope.class.getName()));
        }
        if (requiresOperationId) {
            this.initOperationId(spaceProxy, this.queryPacket);
        }
    }

    @Override
    public QueryProxyActionInfo clone() {
        QueryProxyActionInfo copy = (QueryProxyActionInfo)super.clone();
        copy.queryPacket = this.queryPacket.clone();
        return copy;
    }

    private boolean preProcessQuery() {
        if (this._query == null) {
            return false;
        }
        if (this._query instanceof SQLQuery) {
            SQLQuery sqlQuery = (SQLQuery)this._query;
            if (sqlQuery.isNullExpression() && sqlQuery.getObject() != null) {
                this._query = sqlQuery.getObject();
                return false;
            }
            return true;
        }
        return this._query instanceof SQLQueryTemplatePacket;
    }

    protected void setFifoIfNeeded(ISpaceProxy spaceProxy) {
        boolean isFifo;
        boolean bl = isFifo = ReadModifiers.isFifo(this.modifiers) || spaceProxy.isFifo() || this.queryPacket.getTypeDescriptor() != null && this.queryPacket.getTypeDescriptor().isFifoDefault();
        if (isFifo) {
            this.modifiers = Modifiers.add(this.modifiers, 2048);
        }
    }

    public AbstractProjectionTemplate clearProjectionTemplate() {
        AbstractProjectionTemplate projectionTemplate = this.queryPacket.getProjectionTemplate();
        if (projectionTemplate != null) {
            this.queryPacket.setProjectionTemplate(null);
        }
        return projectionTemplate;
    }

    public Object getQuery() {
        return this._query;
    }

    protected boolean verifyLogScannedEntriesCountParams(long timeout) {
        if (timeout > 0L & _devLogger.isLoggable(Level.FINEST)) {
            _devLogger.finest("Logging scanned entries count is not available for blocking operations, 0 timeout must be used");
            return false;
        }
        return true;
    }
}

