/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.client.spaceproxy.actioninfo;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.client.ReadByIdsException;
import com.gigaspaces.client.ReadTakeByIdResult;
import com.gigaspaces.client.ReadTakeByIdsException;
import com.gigaspaces.client.TakeByIdsException;
import com.gigaspaces.internal.client.QueryResultTypeInternal;
import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.gigaspaces.internal.client.spaceproxy.actioninfo.CommonProxyActionInfo;
import com.gigaspaces.internal.client.spaceproxy.metadata.ISpaceProxyTypeManager;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.server.space.SpaceUidFactory;
import com.gigaspaces.internal.transport.AbstractProjectionTemplate;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.gigaspaces.internal.transport.ProjectionTemplate;
import com.gigaspaces.internal.transport.TemplatePacketFactory;
import com.gigaspaces.internal.utils.ObjectUtils;
import com.gigaspaces.metadata.SpaceMetadataException;
import com.j_spaces.core.AbstractIdsQueryPacket;
import com.j_spaces.core.UnknownTypeException;
import com.j_spaces.core.exception.internal.ProxyInternalSpaceException;
import net.jini.core.transaction.Transaction;

@InternalApi
public class ReadTakeByIdsProxyActionInfo
extends CommonProxyActionInfo {
    public final Object[] ids;
    public final Object routing;
    public Object[] routings;
    public final String className;
    public final boolean isTake;
    public AbstractIdsQueryPacket queryPacket;

    public ReadTakeByIdsProxyActionInfo(ISpaceProxy spaceProxy, String className, Object[] ids, Object routing, Object[] routings, Transaction txn, boolean isTake, int modifiers, QueryResultTypeInternal queryResultType, String[] projections, AbstractProjectionTemplate projectionTemplate) {
        super(txn, modifiers);
        try {
            this.ids = ids;
            this.className = className;
            this.isTake = isTake;
            this.routing = routing;
            this.routings = routings;
            this.queryPacket = this.initialize(spaceProxy, queryResultType, projections, projectionTemplate);
        }
        catch (SpaceMetadataException e) {
            ReadTakeByIdResult[] results = new ReadTakeByIdResult[ids.length];
            for (int i = 0; i < results.length; ++i) {
                results[i] = new ReadTakeByIdResult(ids[i], null, e);
            }
            if (isTake) {
                throw new TakeByIdsException(results);
            }
            throw new ReadByIdsException(results);
        }
    }

    @Override
    public ReadTakeByIdsProxyActionInfo clone() {
        ReadTakeByIdsProxyActionInfo copy = (ReadTakeByIdsProxyActionInfo)super.clone();
        copy.queryPacket = (AbstractIdsQueryPacket)this.queryPacket.clone();
        return copy;
    }

    private AbstractIdsQueryPacket initialize(ISpaceProxy spaceProxy, QueryResultTypeInternal queryResultType, String[] projections, AbstractProjectionTemplate projectionTemplate) {
        int i;
        boolean validateIdType;
        if (this.className == null) {
            throw new IllegalArgumentException("Class name cannot be null.");
        }
        ITypeDesc typeDesc = spaceProxy.getDirectProxy().getTypeManager().getTypeDescByName(this.className);
        if (typeDesc == null) {
            UnknownTypeException ex = new UnknownTypeException("Metadata is unknown. Execute snapshot() before working with desired Object class.", this.className);
            throw new ProxyInternalSpaceException(ex.getMessage(), ex);
        }
        if (this.ids == null) {
            throw new IllegalArgumentException("IDs array cannot be null.");
        }
        boolean bl = validateIdType = typeDesc.getIdPropertyName() == null || typeDesc.isAutoGenerateId();
        if (this.routings != null) {
            if (this.routings.length != this.ids.length) {
                throw new IllegalArgumentException("IDs array and routing array size is not the same.");
            }
            for (i = 0; i < this.routings.length; ++i) {
                if (this.ids[i] == null) {
                    throw new IllegalArgumentException("Value cannot be null - id[" + i + "].");
                }
                if (validateIdType && !(this.ids[i] instanceof String)) {
                    throw new IllegalArgumentException("Auto-generated id must be of type string - id[" + i + "].");
                }
                if (this.routings[i] != null) continue;
                throw new IllegalArgumentException("Value cannot be null - routing array at [" + i + "].");
            }
        } else {
            for (i = 0; i < this.ids.length; ++i) {
                if (this.ids[i] == null) {
                    throw new IllegalArgumentException("Value cannot be null - id[" + i + "].");
                }
                if (!validateIdType || this.ids[i] instanceof String) continue;
                throw new IllegalArgumentException("Auto-generated id must be of type string - id[" + i + "].");
            }
        }
        if (ObjectUtils.equals(typeDesc.getIdPropertyName(), typeDesc.getRoutingPropertyName())) {
            if (this.routing != null || this.routings != null && this.routings != this.ids) {
                throw new IllegalArgumentException("When the id property is used for routing, the routing argument must be null.");
            }
            if (typeDesc.isAutoGenerateRouting()) {
                this.routings = new Object[this.ids.length];
                for (i = 0; i < this.ids.length; ++i) {
                    this.routings[i] = SpaceUidFactory.extractPartitionId((String)this.ids[i]);
                }
            } else {
                this.routings = this.ids;
            }
        }
        this.validateReadModifiers(spaceProxy);
        if (projections != null && projections.length > 0) {
            projectionTemplate = ProjectionTemplate.create(projections, typeDesc);
        }
        AbstractIdsQueryPacket queryPacket = this.routings != null ? TemplatePacketFactory.createIdsPacket(this.ids, this.routings, typeDesc, queryResultType, projectionTemplate) : TemplatePacketFactory.createIdsPacket(this.ids, this.routing, typeDesc, queryResultType, projectionTemplate);
        if (this.isTake) {
            this.initOperationId(spaceProxy, queryPacket);
        }
        return queryPacket;
    }

    public Object[] convertResults(ISpaceProxy spaceProxy, IEntryPacket[] results, boolean returnPackets, AbstractProjectionTemplate projectionTemplate) {
        return spaceProxy.getDirectProxy().getTypeManager().convertQueryResults(results, this.queryPacket, returnPackets, projectionTemplate);
    }

    public ReadTakeByIdsException convertResults(ISpaceProxy spaceProxy, ReadTakeByIdsException e, boolean returnPackets, AbstractProjectionTemplate projectionTemplate) {
        ReadTakeByIdResult[] results = e.getResults();
        ISpaceProxyTypeManager typeManager = spaceProxy.getDirectProxy().getTypeManager();
        for (int i = 0; i < results.length; ++i) {
            if (results[i].isError()) continue;
            IEntryPacket packet = (IEntryPacket)results[i].getObject();
            Object entry = typeManager.convertQueryResult(packet, this.queryPacket, returnPackets, projectionTemplate);
            results[i] = new ReadTakeByIdResult(results[i].getId(), entry, results[i].getError());
        }
        return e;
    }

    public AbstractProjectionTemplate clearProjectionTemplate() {
        AbstractProjectionTemplate projectionTemplate = this.queryPacket.getProjectionTemplate();
        if (projectionTemplate != null) {
            this.queryPacket.setProjectionTemplate(null);
        }
        return projectionTemplate;
    }
}

