/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.client.spaceproxy.actioninfo;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.client.ReadMultipleException;
import com.gigaspaces.client.TakeMultipleException;
import com.gigaspaces.cluster.replication.TakeConsistencyLevelCompromisedException;
import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.gigaspaces.internal.client.spaceproxy.actioninfo.QueryProxyActionInfo;
import com.gigaspaces.internal.client.spaceproxy.metadata.SpaceProxyTypeManager;
import com.gigaspaces.internal.client.spaceproxy.operations.ReplicationLevel;
import com.gigaspaces.internal.transport.AbstractProjectionTemplate;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.gigaspaces.metadata.SpaceMetadataException;
import com.j_spaces.core.client.ReadModifiers;
import com.j_spaces.core.multiple.query.QueryMultiplePartialFailureException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import net.jini.core.transaction.Transaction;

@InternalApi
public class ReadTakeMultipleProxyActionInfo
extends QueryProxyActionInfo {
    public final int maxResults;
    public final boolean returnOnlyUids;
    public final boolean isTake;
    public final long timeout;
    public final int minEntriesToWaitFor;
    public boolean ifExist;
    private int syncReplicationLevel;
    private List<ReplicationLevel> syncReplicationLevels;

    public ReadTakeMultipleProxyActionInfo(ISpaceProxy spaceProxy, Object template, Transaction txn, long timeout, int maxEntries, int minEntriesToWaitFor, int modifiers, boolean returnOnlyUids, boolean isTake, boolean ifExist) {
        super(spaceProxy, template, txn, modifiers, isTake);
        try {
            if (this.queryPacket.getMultipleUIDs() != null) {
                this.maxResults = Math.min(maxEntries, this.queryPacket.getMultipleUIDs().length);
                this.minEntriesToWaitFor = Math.min(this.maxResults, minEntriesToWaitFor);
            } else {
                this.maxResults = maxEntries;
                this.minEntriesToWaitFor = minEntriesToWaitFor;
            }
            this.returnOnlyUids = returnOnlyUids | this.queryPacket.isReturnOnlyUids();
            this.isTake = isTake;
            this.timeout = timeout;
            this.ifExist = ifExist;
            if (ReadModifiers.isFifoGroupingPoll(modifiers)) {
                this.verifyFifoGroupsCallParams(isTake);
            }
            if (_devLogger.isLoggable(Level.FINEST) && this.verifyLogScannedEntriesCountParams(this.timeout)) {
                this.modifiers |= 0x4000000;
            }
            this.setFifoIfNeeded(spaceProxy);
        }
        catch (SpaceMetadataException e) {
            if (isTake) {
                throw new TakeMultipleException(e);
            }
            throw new ReadMultipleException(e);
        }
    }

    public Object[] convertQueryResults(ISpaceProxy spaceProxy, IEntryPacket[] results, AbstractProjectionTemplate projectionTemplate) {
        boolean returnPacket = this._query == this.queryPacket;
        Object[] returnedObjects = spaceProxy.getDirectProxy().getTypeManager().convertQueryResults(results, this.queryPacket, returnPacket, projectionTemplate);
        if (this.syncReplicationLevels == null && this.isTake) {
            this.syncReplicationLevels = new ArrayList<ReplicationLevel>(returnedObjects.length);
            for (int i = 0; i < returnedObjects.length; ++i) {
                this.syncReplicationLevels.add(i, new ReplicationLevel(i, 1, this.syncReplicationLevel));
            }
        }
        this.checkConsistencyLevel(this.syncReplicationLevels, returnedObjects);
        return returnedObjects;
    }

    private void checkConsistencyLevel(List<ReplicationLevel> levels, Object[] returnedObjects) {
        if (this.isTake && levels != null) {
            ArrayList<Object> results = new ArrayList<Object>();
            ArrayList<Throwable> errors = new ArrayList<Throwable>();
            int requiredConsistencyLevel = SpaceProxyTypeManager.requiredConsistencyLevel();
            for (int i = 0; i < returnedObjects.length; ++i) {
                int actualReplicationLevel = this.getReplicationLevelFor(i, levels);
                if (actualReplicationLevel + 1 < requiredConsistencyLevel) {
                    errors.add(new TakeConsistencyLevelCompromisedException(actualReplicationLevel + 1, returnedObjects[i]));
                    continue;
                }
                results.add(returnedObjects[i]);
            }
            if (!errors.isEmpty()) {
                throw new TakeMultipleException(results, errors);
            }
        }
    }

    private int getReplicationLevelFor(int index, List<ReplicationLevel> levels) {
        for (ReplicationLevel level : levels) {
            if (level.getStart() > index || index >= level.getStart() + level.getLength()) continue;
            return level.getLevel();
        }
        return 0;
    }

    public QueryMultiplePartialFailureException convertExceptionResults(ISpaceProxy spaceProxy, QueryMultiplePartialFailureException e, AbstractProjectionTemplate projectionTemplate) {
        if (this._query == this.queryPacket) {
            return e;
        }
        Object[] results = e.getResults();
        IEntryPacket[] packets = (IEntryPacket[])results;
        if (results != null && 0 < results.length) {
            e.setResults(this.convertQueryResults(spaceProxy, packets, projectionTemplate));
        }
        return e;
    }

    private void verifyFifoGroupsCallParams(boolean isTake) {
        if (this.txn == null) {
            throw new IllegalArgumentException(" fifo-groups operation must be under transaction");
        }
        if (!isTake && !ReadModifiers.isExclusiveReadLock(this.modifiers)) {
            throw new IllegalArgumentException(" fifo-groups read operation must be exclusive-read-lock");
        }
    }

    public int getSyncReplicationLevel() {
        return this.syncReplicationLevel;
    }

    public void setSyncReplicationLevel(int syncReplicationLevel) {
        this.syncReplicationLevel = syncReplicationLevel;
    }

    public void setSyncReplicationLevels(List<ReplicationLevel> syncReplicationLevels) {
        this.syncReplicationLevels = syncReplicationLevels;
    }

    public List<ReplicationLevel> getSyncReplicationLevels() {
        return this.syncReplicationLevels;
    }
}

