/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.client.spaceproxy.actioninfo;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.client.QueryResultTypeInternal;
import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.gigaspaces.internal.client.spaceproxy.actioninfo.QueryProxyActionInfo;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.transport.AbstractProjectionTemplate;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.gigaspaces.internal.transport.ProjectionTemplate;
import com.gigaspaces.internal.transport.TemplatePacketFactory;
import com.gigaspaces.internal.utils.ObjectUtils;
import com.j_spaces.core.UnknownTypeException;
import com.j_spaces.core.client.Modifiers;
import com.j_spaces.core.client.ReadModifiers;
import com.j_spaces.core.exception.internal.ProxyInternalSpaceException;
import java.util.logging.Level;
import net.jini.core.transaction.Transaction;

@InternalApi
public class ReadTakeProxyActionInfo
extends QueryProxyActionInfo {
    public final long timeout;
    public final boolean ifExists;
    public final boolean isTake;
    public final boolean returnOnlyUids;
    private boolean _returnPacket;

    public ReadTakeProxyActionInfo(ISpaceProxy spaceProxy, Object template, Transaction txn, long timeout, int modifiers, boolean ifExists, boolean isTake) {
        super(spaceProxy, template, txn, modifiers, isTake);
        this.timeout = timeout;
        this.ifExists = ifExists || Modifiers.contains(modifiers, 256);
        this.isTake = isTake;
        this.returnOnlyUids = this.queryPacket.isReturnOnlyUids();
        if (timeout < 0L) {
            throw new IllegalArgumentException("timeout parameter must be greater than or equal to zero.");
        }
        this.validateReadModifiers(spaceProxy);
        if (ReadModifiers.isFifoGroupingPoll(modifiers)) {
            this.verifyFifoGroupsCallParams(isTake);
        }
        if (_devLogger.isLoggable(Level.FINEST) && this.verifyLogScannedEntriesCountParams(this.timeout)) {
            this.modifiers |= 0x4000000;
        }
        this.setFifoIfNeeded(spaceProxy);
    }

    public ReadTakeProxyActionInfo(ISpaceProxy spaceProxy, String className, Object id, Object routing, int version, Transaction txn, long timeout, int modifiers, QueryResultTypeInternal resultType, boolean ifExists, boolean isTake, String[] projections, AbstractProjectionTemplate projectionTemplate) {
        super(spaceProxy, txn, modifiers);
        this.timeout = timeout;
        this.ifExists = ifExists;
        this.isTake = isTake;
        this.returnOnlyUids = false;
        if (id == null) {
            throw new IllegalArgumentException("id cannot be null.");
        }
        if (className == null) {
            throw new IllegalArgumentException("className cannot be null.");
        }
        this.validateReadModifiers(spaceProxy);
        ITypeDesc typeDesc = spaceProxy.getDirectProxy().getTypeManager().getTypeDescByName(className);
        if (typeDesc == null) {
            UnknownTypeException ute = new UnknownTypeException("Metadata is unknown. Execute snapshot() before working with desired Object class.", className);
            throw new ProxyInternalSpaceException(ute.getMessage(), ute);
        }
        if (ObjectUtils.equals(typeDesc.getIdPropertyName(), typeDesc.getRoutingPropertyName()) && routing != null && !routing.equals(id)) {
            throw new IllegalArgumentException("routing must be null or same as id if routing property and id property are the same.");
        }
        if (projections != null && projections.length > 0) {
            projectionTemplate = ProjectionTemplate.create(projections, typeDesc);
        }
        this.queryPacket = TemplatePacketFactory.createIdOrUidPacket(typeDesc, resultType, routing, id, version, projectionTemplate);
        if (isTake) {
            this.initOperationId(spaceProxy, this.queryPacket);
        }
    }

    public ReadTakeProxyActionInfo(ISpaceProxy spaceProxy, String uid, Transaction txn, int modifiers, QueryResultTypeInternal resultType, boolean returnPacket, boolean ifExists, boolean isTake) {
        super(spaceProxy, txn, modifiers);
        this.timeout = 0L;
        this.ifExists = ifExists;
        this.isTake = isTake;
        this.returnOnlyUids = false;
        this._returnPacket = returnPacket;
        if (uid == null) {
            throw new IllegalArgumentException("uid cannot be null.");
        }
        this.validateReadModifiers(spaceProxy);
        this.queryPacket = TemplatePacketFactory.createUidPacket(uid, null, 0, resultType);
        if (isTake) {
            this.initOperationId(spaceProxy, this.queryPacket);
        }
    }

    public boolean isAsync() {
        return false;
    }

    public Object convertQueryResult(ISpaceProxy spaceProxy, IEntryPacket result, AbstractProjectionTemplate projectionTemplate) {
        return spaceProxy.getDirectProxy().getTypeManager().convertQueryResult(result, this.queryPacket, this.isReturnPacket(), projectionTemplate);
    }

    public boolean isReturnPacket() {
        return this._returnPacket || this._query == this.queryPacket;
    }

    private void verifyFifoGroupsCallParams(boolean isTake) {
        if (this.txn == null) {
            throw new IllegalArgumentException("fifo grouping operation must be under transaction");
        }
        if (!isTake && !ReadModifiers.isExclusiveReadLock(this.modifiers)) {
            throw new IllegalArgumentException("fifo grouping read operation must be exclusive-read-lock");
        }
    }
}

