/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.client.spaceproxy.actioninfo;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.client.spaceproxy.IDirectSpaceProxy;
import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.gigaspaces.internal.client.spaceproxy.actioninfo.CommonProxyActionInfo;
import com.gigaspaces.internal.client.spaceproxy.metadata.ObjectType;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.j_spaces.core.LeaseContext;
import com.j_spaces.core.client.Modifiers;
import com.j_spaces.core.client.UpdateModifiers;
import net.jini.core.transaction.Transaction;

@InternalApi
public class WriteMultipleProxyActionInfo
extends CommonProxyActionInfo {
    public final Object[] entries;
    public final IEntryPacket[] entryPackets;
    public final long lease;
    public final long[] leases;
    public final long timeout;
    private static final boolean oneWaySystemProperty = Boolean.getBoolean("com.gs.onewaywrite");

    public WriteMultipleProxyActionInfo(ISpaceProxy spaceProxy, Object[] entries, Transaction txn, long lease, long[] leases, long timeout, int modifiers) {
        super(txn, spaceProxy.initWriteModifiers(modifiers));
        boolean oneWay;
        if (entries == null || entries.length == 0) {
            throw new IllegalArgumentException("Cannot write a null or empty entries array.");
        }
        if (leases != null && leases.length != entries.length) {
            throw new IllegalArgumentException("Leases array size must match entries array size.");
        }
        if (lease < 0L && lease != -1L && lease != Long.MIN_VALUE) {
            throw new IllegalArgumentException("Lease cannot be less than zero: " + lease);
        }
        if (oneWaySystemProperty) {
            modifiers |= 1;
        }
        if (oneWay = Modifiers.contains(modifiers, 1)) {
            if (txn != null || spaceProxy.getContextTransaction() != null) {
                throw new UnsupportedOperationException("Oneway write is not supported when the write is being done under a transaction.");
            }
            if (UpdateModifiers.isReturnPrevOnUpdate(modifiers)) {
                throw new UnsupportedOperationException("Oneway write is not supported with return previous value on update.");
            }
        }
        this.entries = entries;
        this.lease = lease;
        this.leases = leases;
        this.timeout = timeout;
        this.entryPackets = new IEntryPacket[entries.length];
        for (int i = 0; i < entries.length; ++i) {
            if (entries[i] == null) {
                throw new IllegalArgumentException("entry number " + i + " is null");
            }
            ObjectType objectType = ObjectType.fromObject(entries[i]);
            this.entryPackets[i] = this.toEntryPacket(spaceProxy, entries[i], objectType);
            if (this.entryPackets[i].getTypeName() == null) {
                throw new IllegalArgumentException("Cannot write null-class Entry- entry number " + i);
            }
            if (!UpdateModifiers.isPartialUpdate(this.modifiers) || this.entryPackets[i].getDynamicProperties() == null) continue;
            throw new UnsupportedOperationException("Partial update is not supported for dynamic properties.");
        }
    }

    public LeaseContext<?>[] convertWriteResults(IDirectSpaceProxy spaceProxy, LeaseContext<?>[] result) {
        if (result == null) {
            for (int i = 0; i < this.entries.length; ++i) {
                spaceProxy.getTypeManager().convertWriteResult(this.entries[i], this.entryPackets[i], null);
            }
            return null;
        }
        for (int i = 0; i < result.length; ++i) {
            result[i] = spaceProxy.getTypeManager().convertWriteOrUpdateResult(result[i], this.entries[i], this.entryPackets[i], this.modifiers);
        }
        if (UpdateModifiers.isNoReturnValue(this.modifiers)) {
            result = null;
        }
        return result;
    }
}

