/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.client.spaceproxy.actioninfo;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.client.spaceproxy.IDirectSpaceProxy;
import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.gigaspaces.internal.client.spaceproxy.actioninfo.CommonProxyActionInfo;
import com.gigaspaces.internal.client.spaceproxy.metadata.ObjectType;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.j_spaces.core.LeaseContext;
import com.j_spaces.core.client.Modifiers;
import com.j_spaces.core.client.UpdateModifiers;
import net.jini.core.transaction.Transaction;

@InternalApi
public class WriteProxyActionInfo
extends CommonProxyActionInfo {
    public final Object entry;
    public final IEntryPacket entryPacket;
    public final long lease;
    public final long timeout;
    private static final boolean oneWaySystemProperty = Boolean.getBoolean("com.gs.onewaywrite");

    public WriteProxyActionInfo(ISpaceProxy spaceProxy, Object entry, Transaction txn, long lease, long timeout, int modifiers) {
        super(txn, spaceProxy.initWriteModifiers(modifiers));
        boolean oneWay;
        if (entry == null) {
            throw new IllegalArgumentException("write() operation cannot accept null entry.");
        }
        if (lease < 0L) {
            throw new IllegalArgumentException("lease cannot be less than zero");
        }
        this.entry = entry;
        this.lease = lease;
        this.timeout = timeout;
        if (timeout < 0L) {
            throw new IllegalArgumentException("timeout parameter must be greater than or equal to zero.");
        }
        ObjectType objectType = ObjectType.fromObject(entry);
        this.entryPacket = this.toEntryPacket(spaceProxy, entry, objectType);
        if (UpdateModifiers.isPartialUpdate(modifiers) && this.entryPacket.getDynamicProperties() != null) {
            throw new UnsupportedOperationException("Partial update is not supported for dynamic properties.");
        }
        if (oneWaySystemProperty) {
            modifiers |= 1;
        }
        if (oneWay = Modifiers.contains(modifiers, 1)) {
            if (txn != null || spaceProxy.getContextTransaction() != null) {
                throw new UnsupportedOperationException("Oneway write is not supported when the write is being done under a transaction.");
            }
            if (UpdateModifiers.isReturnPrevOnUpdate(modifiers)) {
                throw new UnsupportedOperationException("Oneway write is not supported with return previous value on update.");
            }
        }
    }

    public LeaseContext<?> convertWriteResult(IDirectSpaceProxy spaceProxy, LeaseContext<?> result) {
        return spaceProxy.getTypeManager().convertWriteOrUpdateResult(result, this.entry, this.entryPacket, this.modifiers);
    }

    public boolean isUpdate() {
        if (UpdateModifiers.isUpdateOnly(this.modifiers)) {
            return true;
        }
        if (UpdateModifiers.isWriteOnly(this.modifiers)) {
            return false;
        }
        return this.entryPacket.getUID() != null;
    }
}

