/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.client.spaceproxy.actions;

import com.gigaspaces.async.AsyncFuture;
import com.gigaspaces.async.AsyncFutureListener;
import com.gigaspaces.client.ChangeModifiers;
import com.gigaspaces.client.ChangeResult;
import com.gigaspaces.client.ChangeSet;
import com.gigaspaces.client.ClearException;
import com.gigaspaces.executor.SpaceTask;
import com.gigaspaces.internal.client.QueryResultTypeInternal;
import com.gigaspaces.internal.client.ReadTakeEntriesUidsResult;
import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.gigaspaces.internal.client.spaceproxy.actioninfo.AggregateProxyActionInfo;
import com.gigaspaces.internal.client.spaceproxy.actioninfo.ChangeProxyActionInfo;
import com.gigaspaces.internal.client.spaceproxy.actioninfo.CountClearProxyActionInfo;
import com.gigaspaces.internal.client.spaceproxy.actioninfo.ReadTakeAsyncProxyActionInfo;
import com.gigaspaces.internal.client.spaceproxy.actioninfo.ReadTakeByIdsProxyActionInfo;
import com.gigaspaces.internal.client.spaceproxy.actioninfo.ReadTakeMultipleProxyActionInfo;
import com.gigaspaces.internal.client.spaceproxy.actioninfo.ReadTakeProxyActionInfo;
import com.gigaspaces.internal.client.spaceproxy.actioninfo.SnapshotProxyActionInfo;
import com.gigaspaces.internal.client.spaceproxy.actioninfo.WriteMultipleProxyActionInfo;
import com.gigaspaces.internal.client.spaceproxy.actioninfo.WriteProxyActionInfo;
import com.gigaspaces.internal.client.spaceproxy.actions.AdminProxyAction;
import com.gigaspaces.internal.client.spaceproxy.actions.AggregateProxyAction;
import com.gigaspaces.internal.client.spaceproxy.actions.ChangeProxyAction;
import com.gigaspaces.internal.client.spaceproxy.actions.CountClearProxyAction;
import com.gigaspaces.internal.client.spaceproxy.actions.ReadTakeByIdsProxyAction;
import com.gigaspaces.internal.client.spaceproxy.actions.ReadTakeEntriesUidsProxyAction;
import com.gigaspaces.internal.client.spaceproxy.actions.ReadTakeMultipleProxyAction;
import com.gigaspaces.internal.client.spaceproxy.actions.ReadTakeProxyAction;
import com.gigaspaces.internal.client.spaceproxy.actions.SnapshotProxyAction;
import com.gigaspaces.internal.client.spaceproxy.actions.WriteProxyAction;
import com.gigaspaces.internal.client.spaceproxy.executors.TypeDescriptorActionsProxyExecutor;
import com.gigaspaces.internal.client.spaceproxy.operations.ReadTakeEntriesUidsSpaceOperationRequest;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.space.actions.GetTypeDescriptorActionInfo;
import com.gigaspaces.internal.space.requests.AddTypeIndexesRequestInfo;
import com.gigaspaces.internal.space.requests.RegisterTypeDescriptorRequestInfo;
import com.gigaspaces.internal.transport.ITemplatePacket;
import com.gigaspaces.metadata.index.AddTypeIndexesResult;
import com.gigaspaces.metadata.index.SpaceIndex;
import com.gigaspaces.query.ISpaceQuery;
import com.gigaspaces.query.aggregators.AggregationResult;
import com.gigaspaces.query.aggregators.AggregationSet;
import com.j_spaces.core.DropClassException;
import com.j_spaces.core.LeaseContext;
import com.j_spaces.core.SpaceHealthStatus;
import com.j_spaces.core.client.Modifiers;
import com.j_spaces.core.exception.internal.InterruptedSpaceException;
import com.j_spaces.core.exception.internal.ProxyInternalSpaceException;
import com.j_spaces.kernel.JSpaceUtilities;
import java.rmi.RemoteException;
import java.util.concurrent.Future;
import net.jini.core.entry.UnusableEntryException;
import net.jini.core.transaction.Transaction;
import net.jini.core.transaction.TransactionException;

public abstract class AbstractSpaceProxyActionManager<TSpaceProxy extends ISpaceProxy> {
    private final TSpaceProxy _spaceProxy;
    private final TypeDescriptorActionsProxyExecutor<TSpaceProxy> _typeDescriptorActionsExecutor;
    private final AdminProxyAction<TSpaceProxy> _adminAction;
    private final CountClearProxyAction<TSpaceProxy> _countClearAction;
    private final SnapshotProxyAction<TSpaceProxy> _snapshotAction;
    private final ReadTakeProxyAction<TSpaceProxy> _readTakeAction;
    private final ReadTakeMultipleProxyAction<TSpaceProxy> _readTakeMultipleAction;
    private final ReadTakeByIdsProxyAction<TSpaceProxy> _readTakeByIdsAction;
    private final WriteProxyAction<TSpaceProxy> _writeAction;
    private final ReadTakeEntriesUidsProxyAction<TSpaceProxy> _readTakeEntriesUidsAction;
    private final ChangeProxyAction<TSpaceProxy> _changeAction;
    private final AggregateProxyAction<TSpaceProxy> _aggregationAction;

    protected AbstractSpaceProxyActionManager(TSpaceProxy spaceProxy) {
        this._spaceProxy = spaceProxy;
        this._typeDescriptorActionsExecutor = this.createTypeDescriptorActionsExecutor();
        this._adminAction = this.createAdminProxyAction();
        this._countClearAction = this.createCountClearProxyAction();
        this._snapshotAction = this.createSnapshotProxyAction();
        this._readTakeAction = this.createReadTakeProxyAction();
        this._readTakeMultipleAction = this.createReadTakeMultipleProxyAction();
        this._readTakeByIdsAction = this.createReadTakeByIdsProxyAction();
        this._readTakeEntriesUidsAction = this.createReadTakeEntriesUidsProxyAction();
        this._writeAction = this.createWriteProxyAction();
        this._changeAction = this.createChangeProxyAction();
        this._aggregationAction = this.createAggregateAction();
    }

    public ITypeDesc getTypeDescriptor(String typeName) throws RemoteException {
        GetTypeDescriptorActionInfo actionInfo = new GetTypeDescriptorActionInfo(typeName);
        return this._typeDescriptorActionsExecutor.getTypeDescriptor(this._spaceProxy, actionInfo);
    }

    public void registerTypeDescriptor(ITypeDesc typeDesc) throws RemoteException {
        RegisterTypeDescriptorRequestInfo actionInfo = new RegisterTypeDescriptorRequestInfo(typeDesc);
        this._typeDescriptorActionsExecutor.registerTypeDescriptor(this._spaceProxy, actionInfo);
    }

    public ITypeDesc registerTypeDescriptor(Class<?> type) throws RemoteException {
        return this._typeDescriptorActionsExecutor.registerTypeDescriptor(this._spaceProxy, type);
    }

    public AsyncFuture<AddTypeIndexesResult> asyncAddIndexes(String typeName, SpaceIndex[] indexes, AsyncFutureListener<AddTypeIndexesResult> listener) throws RemoteException {
        AddTypeIndexesRequestInfo requestInfo = new AddTypeIndexesRequestInfo(typeName, indexes, listener);
        if (this._spaceProxy.getDirectProxy().isGatewayProxy()) {
            requestInfo.setFromGateway(true);
        }
        return this._typeDescriptorActionsExecutor.asyncAddIndexes(this._spaceProxy, requestInfo);
    }

    public void dropClass(String className) throws RemoteException, DropClassException {
        this._adminAction.dropClass(this._spaceProxy, className);
    }

    public int clear(Object template, Transaction txn, int modifiers) throws ClearException {
        CountClearProxyActionInfo actionInfo = new CountClearProxyActionInfo((ISpaceProxy)this._spaceProxy, template, txn, modifiers, true, true);
        try {
            return this._countClearAction.execute(this._spaceProxy, actionInfo);
        }
        catch (ClearException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ClearException(ex);
        }
    }

    public int count(Object template, Transaction txn, int modifiers) throws RemoteException, TransactionException, UnusableEntryException {
        CountClearProxyActionInfo actionInfo = new CountClearProxyActionInfo((ISpaceProxy)this._spaceProxy, template, txn, modifiers, false);
        return this._countClearAction.execute(this._spaceProxy, actionInfo);
    }

    public AsyncFuture executeTask(SpaceTask task, Object routing, Transaction tx, AsyncFutureListener listener) throws RemoteException, TransactionException {
        return this._adminAction.execute(this._spaceProxy, task, routing, tx, listener);
    }

    public void ping() throws RemoteException {
        this._adminAction.ping(this._spaceProxy);
    }

    public SpaceHealthStatus getSpaceHealthStatus() throws RemoteException {
        return this._adminAction.getSpaceHealthStatus(this._spaceProxy);
    }

    public Object read(Object template, Transaction txn, long timeout, int modifiers, boolean ifExists) throws UnusableEntryException, TransactionException, InterruptedException, RemoteException {
        ReadTakeProxyActionInfo actionInfo = new ReadTakeProxyActionInfo((ISpaceProxy)this._spaceProxy, template, txn, timeout, modifiers, ifExists, false);
        return this.read(actionInfo);
    }

    public Object readById(String className, Object id, Object routing, Transaction txn, long timeout, int modifiers, boolean ifExists, QueryResultTypeInternal resultType, String[] projections) throws RemoteException, UnusableEntryException, TransactionException, InterruptedException {
        ReadTakeProxyActionInfo actionInfo = new ReadTakeProxyActionInfo((ISpaceProxy)this._spaceProxy, className, id, routing, 0, txn, timeout, modifiers, resultType, ifExists, false, projections, null);
        return this.read(actionInfo);
    }

    public Object readByUid(String uid, Transaction txn, int modifiers, QueryResultTypeInternal resultType, boolean returnPacket) throws RemoteException, UnusableEntryException, TransactionException, InterruptedException {
        ReadTakeProxyActionInfo actionInfo = new ReadTakeProxyActionInfo((ISpaceProxy)this._spaceProxy, uid, txn, modifiers, resultType, returnPacket, false, false);
        return this.read(actionInfo);
    }

    public Object read(ReadTakeProxyActionInfo actionInfo) throws UnusableEntryException, TransactionException, InterruptedException, RemoteException {
        try {
            return this._readTakeAction.read(this._spaceProxy, actionInfo);
        }
        catch (UnusableEntryException e) {
            throw e;
        }
        catch (TransactionException e) {
            throw e;
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (RemoteException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw this.processInternalException(e);
        }
    }

    public AsyncFuture<?> asyncRead(Object template, Transaction txn, long timeout, int modifiers, AsyncFutureListener<?> listener) throws RemoteException {
        try {
            ReadTakeAsyncProxyActionInfo actionInfo = new ReadTakeAsyncProxyActionInfo((ISpaceProxy)this._spaceProxy, template, txn, timeout, modifiers, false, listener);
            return this._readTakeAction.asyncRead(this._spaceProxy, actionInfo);
        }
        catch (RemoteException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw this.processInternalException(e);
        }
    }

    public Object[] readMultiple(Object template, Transaction txn, long timeout, int maxEntries, int minEntriesToWaitFor, int modifiers, boolean returnOnlyUids, boolean ifExist) throws TransactionException, UnusableEntryException, RemoteException {
        if (txn == null && Modifiers.contains(modifiers, 512)) {
            throw new IllegalArgumentException("Using EXCLUSIVE_READ_LOCK modifier without a transaction is illegal.");
        }
        ReadTakeMultipleProxyActionInfo actionInfo = new ReadTakeMultipleProxyActionInfo((ISpaceProxy)this._spaceProxy, template, txn, timeout, maxEntries, minEntriesToWaitFor, modifiers, returnOnlyUids, false, ifExist);
        try {
            return this._readTakeMultipleAction.readMultiple(this._spaceProxy, actionInfo);
        }
        catch (TransactionException e) {
            throw e;
        }
        catch (UnusableEntryException e) {
            throw e;
        }
        catch (RemoteException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw this.processInternalException(e);
        }
    }

    public Object[] readByIds(String className, Object[] ids, Object routing, Transaction txn, int modifiers, QueryResultTypeInternal resultType, boolean returnPackets, String[] projections) throws RemoteException, UnusableEntryException, TransactionException, InterruptedException {
        ReadTakeByIdsProxyActionInfo actionInfo = new ReadTakeByIdsProxyActionInfo((ISpaceProxy)this._spaceProxy, className, ids, routing, null, txn, false, modifiers, resultType, projections, null);
        return this._readTakeByIdsAction.readByIds(this._spaceProxy, actionInfo, returnPackets);
    }

    public Object[] readByIds(String className, Object[] ids, Object[] routings, Transaction txn, int modifiers, QueryResultTypeInternal resultType, boolean returnPackets, String[] projections) throws RemoteException, UnusableEntryException, TransactionException, InterruptedException {
        ReadTakeByIdsProxyActionInfo actionInfo = new ReadTakeByIdsProxyActionInfo((ISpaceProxy)this._spaceProxy, className, ids, null, routings, txn, false, modifiers, resultType, projections, null);
        return this._readTakeByIdsAction.readByIds(this._spaceProxy, actionInfo, returnPackets);
    }

    public Object[] readByIds(ReadTakeByIdsProxyActionInfo actionInfo, boolean returnPackets) throws RemoteException, TransactionException, InterruptedException, UnusableEntryException {
        return this._readTakeByIdsAction.readByIds(this._spaceProxy, actionInfo, returnPackets);
    }

    public ReadTakeEntriesUidsResult readEntriesUids(ITemplatePacket template, Transaction transaction, int entriesLimit, int modifiers) throws RemoteException, TransactionException, UnusableEntryException {
        ReadTakeEntriesUidsSpaceOperationRequest request = new ReadTakeEntriesUidsSpaceOperationRequest(template, transaction, entriesLimit, modifiers);
        return this._readTakeEntriesUidsAction.readTakeEntriesUids(this._spaceProxy, request);
    }

    public Object[] takeByIds(String className, Object[] ids, Object routing, Transaction txn, int modifiers, QueryResultTypeInternal resultType, boolean returnPackets, String[] projections) throws RemoteException, UnusableEntryException, TransactionException, InterruptedException {
        ReadTakeByIdsProxyActionInfo actionInfo = new ReadTakeByIdsProxyActionInfo((ISpaceProxy)this._spaceProxy, className, ids, routing, null, txn, true, modifiers, resultType, projections, null);
        return this._readTakeByIdsAction.takeByIds(this._spaceProxy, actionInfo, returnPackets);
    }

    public Object[] takeByIds(String className, Object[] ids, Object[] routings, Transaction txn, int modifiers, QueryResultTypeInternal resultType, boolean returnPackets, String[] projections) throws RemoteException, UnusableEntryException, TransactionException, InterruptedException {
        ReadTakeByIdsProxyActionInfo actionInfo = new ReadTakeByIdsProxyActionInfo((ISpaceProxy)this._spaceProxy, className, ids, null, routings, txn, true, modifiers, resultType, projections, null);
        return this._readTakeByIdsAction.takeByIds(this._spaceProxy, actionInfo, returnPackets);
    }

    public Object[] takeByIds(ReadTakeByIdsProxyActionInfo actionInfo, boolean returnPackets) throws RemoteException, TransactionException, InterruptedException, UnusableEntryException {
        return this._readTakeByIdsAction.takeByIds(this._spaceProxy, actionInfo, returnPackets);
    }

    public <T> ISpaceQuery<T> snapshot(Object object) throws RemoteException {
        try {
            SnapshotProxyActionInfo actionInfo = new SnapshotProxyActionInfo((ISpaceProxy)this._spaceProxy, object);
            return this._snapshotAction.snapshot(this._spaceProxy, actionInfo);
        }
        catch (UnusableEntryException e) {
            throw this.processInternalException((Exception)((Object)e));
        }
    }

    public Object take(Object template, Transaction txn, long timeout, int modifiers, boolean ifExists) throws UnusableEntryException, TransactionException, InterruptedException, RemoteException {
        ReadTakeProxyActionInfo actionInfo = new ReadTakeProxyActionInfo((ISpaceProxy)this._spaceProxy, template, txn, timeout, modifiers, ifExists, true);
        return this.take(actionInfo);
    }

    public Object takeById(String className, Object id, Object routing, int version, Transaction txn, long timeout, int modifiers, boolean ifExists, QueryResultTypeInternal resultType, String[] projections) throws RemoteException, UnusableEntryException, TransactionException, InterruptedException {
        ReadTakeProxyActionInfo actionInfo = new ReadTakeProxyActionInfo((ISpaceProxy)this._spaceProxy, className, id, routing, version, txn, timeout, modifiers, resultType, ifExists, true, projections, null);
        return this.take(actionInfo);
    }

    public Object takeByUid(String uid, Transaction txn, int modifiers, QueryResultTypeInternal resultType, boolean returnPacket) throws RemoteException, UnusableEntryException, TransactionException, InterruptedException {
        ReadTakeProxyActionInfo actionInfo = new ReadTakeProxyActionInfo((ISpaceProxy)this._spaceProxy, uid, txn, modifiers, resultType, returnPacket, false, true);
        return this.take(actionInfo);
    }

    public Object take(ReadTakeProxyActionInfo actionInfo) throws UnusableEntryException, TransactionException, InterruptedException, RemoteException {
        try {
            return this._readTakeAction.take(this._spaceProxy, actionInfo);
        }
        catch (UnusableEntryException e) {
            throw e;
        }
        catch (TransactionException e) {
            throw e;
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (RemoteException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw this.processInternalException(e);
        }
    }

    public AsyncFuture<?> asyncTake(Object template, Transaction txn, long timeout, int modifiers, AsyncFutureListener<?> listener) throws RemoteException {
        try {
            ReadTakeAsyncProxyActionInfo actionInfo = new ReadTakeAsyncProxyActionInfo((ISpaceProxy)this._spaceProxy, template, txn, timeout, modifiers, true, listener);
            return this._readTakeAction.asyncTake(this._spaceProxy, actionInfo);
        }
        catch (RemoteException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw this.processInternalException(e);
        }
    }

    public Object[] takeMultiple(Object template, Transaction txn, long timeout, int maxEntries, int minEntriesToWaitFor, int modifiers, boolean returnOnlyUids, boolean ifExist) throws TransactionException, UnusableEntryException, RemoteException {
        ReadTakeMultipleProxyActionInfo actionInfo = new ReadTakeMultipleProxyActionInfo((ISpaceProxy)this._spaceProxy, template, txn, timeout, maxEntries, minEntriesToWaitFor, modifiers, returnOnlyUids, true, ifExist);
        try {
            return this._readTakeMultipleAction.takeMultiple(this._spaceProxy, actionInfo);
        }
        catch (TransactionException e) {
            throw e;
        }
        catch (UnusableEntryException e) {
            throw e;
        }
        catch (RemoteException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw this.processInternalException(e);
        }
    }

    public LeaseContext<?> write(Object entry, Transaction txn, long lease, long timeout, int modifiers) throws TransactionException, RemoteException {
        WriteProxyActionInfo actionInfo = new WriteProxyActionInfo((ISpaceProxy)this._spaceProxy, entry, txn, lease, timeout, modifiers);
        try {
            return this._writeAction.write(this._spaceProxy, actionInfo);
        }
        catch (InterruptedException e) {
            throw new InterruptedSpaceException(e);
        }
    }

    public LeaseContext<?>[] writeMultiple(Object[] objects, Transaction txn, long lease, long[] leases, long timeout, int modifiers) throws TransactionException, RemoteException {
        WriteMultipleProxyActionInfo actionInfo = new WriteMultipleProxyActionInfo((ISpaceProxy)this._spaceProxy, objects, txn, lease, leases, timeout, modifiers);
        try {
            return this._writeAction.writeMultiple(this._spaceProxy, actionInfo);
        }
        catch (InterruptedException e) {
            throw new InterruptedSpaceException(e);
        }
    }

    public <T> ChangeResult<T> change(Object template, ChangeSet changeSet, Transaction txn, long timeout, ChangeModifiers modifiers) throws RemoteException, TransactionException {
        ChangeProxyActionInfo actionInfo = new ChangeProxyActionInfo((ISpaceProxy)this._spaceProxy, template, changeSet, txn, timeout, modifiers);
        try {
            return this._changeAction.change(this._spaceProxy, actionInfo);
        }
        catch (InterruptedException e) {
            throw new InterruptedSpaceException(e);
        }
    }

    public <T> Future<ChangeResult<T>> asyncChange(Object template, ChangeSet changeSet, Transaction txn, long timeout, ChangeModifiers modifiers, AsyncFutureListener<ChangeResult<T>> listener) throws RemoteException {
        ChangeProxyActionInfo actionInfo = new ChangeProxyActionInfo((ISpaceProxy)this._spaceProxy, template, changeSet, txn, timeout, modifiers);
        return this._changeAction.asyncChange(this._spaceProxy, actionInfo, listener);
    }

    public AggregationResult aggregate(Object query, AggregationSet aggregationSet, Transaction txn, int modifiers) throws RemoteException, TransactionException, InterruptedException {
        AggregateProxyActionInfo actionInfo = new AggregateProxyActionInfo((ISpaceProxy)this._spaceProxy, query, aggregationSet, txn, modifiers);
        return this._aggregationAction.aggregate(this._spaceProxy, actionInfo);
    }

    protected abstract TypeDescriptorActionsProxyExecutor<TSpaceProxy> createTypeDescriptorActionsExecutor();

    protected abstract AdminProxyAction<TSpaceProxy> createAdminProxyAction();

    protected abstract CountClearProxyAction<TSpaceProxy> createCountClearProxyAction();

    protected abstract ReadTakeProxyAction<TSpaceProxy> createReadTakeProxyAction();

    protected abstract ReadTakeMultipleProxyAction<TSpaceProxy> createReadTakeMultipleProxyAction();

    protected abstract ReadTakeByIdsProxyAction<TSpaceProxy> createReadTakeByIdsProxyAction();

    protected abstract ReadTakeEntriesUidsProxyAction<TSpaceProxy> createReadTakeEntriesUidsProxyAction();

    protected abstract SnapshotProxyAction<TSpaceProxy> createSnapshotProxyAction();

    protected abstract WriteProxyAction<TSpaceProxy> createWriteProxyAction();

    protected abstract ChangeProxyAction<TSpaceProxy> createChangeProxyAction();

    protected abstract AggregateProxyAction<TSpaceProxy> createAggregateAction();

    private ProxyInternalSpaceException processInternalException(Exception e) {
        return JSpaceUtilities.createProxyInternalSpaceException(e);
    }
}

