/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.client.spaceproxy.actions;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.async.AsyncFuture;
import com.gigaspaces.async.AsyncFutureListener;
import com.gigaspaces.executor.SpaceTask;
import com.gigaspaces.internal.client.spaceproxy.SpaceProxyImpl;
import com.gigaspaces.internal.client.spaceproxy.actions.AdminProxyAction;
import com.gigaspaces.internal.client.spaceproxy.operations.ExecuteTaskSpaceOperationRequest;
import com.gigaspaces.internal.server.space.IRemoteSpace;
import com.j_spaces.core.DropClassException;
import com.j_spaces.core.SpaceContext;
import com.j_spaces.core.SpaceHealthStatus;
import com.j_spaces.core.admin.IRemoteJSpaceAdmin;
import java.rmi.RemoteException;
import net.jini.core.transaction.Transaction;
import net.jini.core.transaction.TransactionException;

@InternalApi
public class SpaceProxyImplAdminAction
extends AdminProxyAction<SpaceProxyImpl> {
    @Override
    public void dropClass(SpaceProxyImpl spaceProxy, String className) throws RemoteException, DropClassException {
        IRemoteJSpaceAdmin admin = (IRemoteJSpaceAdmin)spaceProxy.getAdmin();
        SpaceContext sc = spaceProxy.getSecurityManager().acquireContext(spaceProxy.getRemoteJSpace());
        admin.dropClass(className, sc);
        spaceProxy.directDropClass(className);
    }

    @Override
    public void ping(SpaceProxyImpl spaceProxy) throws RemoteException {
        IRemoteSpace rj = spaceProxy.getRemoteJSpace();
        if (rj == null) {
            throw new RemoteException("Ping space failed. [" + spaceProxy.getName() + "] is unavailable.");
        }
        rj.ping();
    }

    @Override
    public SpaceHealthStatus getSpaceHealthStatus(SpaceProxyImpl spaceProxy) throws RemoteException {
        return spaceProxy.getRemoteJSpace().getSpaceHealthStatus();
    }

    @Override
    public AsyncFuture execute(SpaceProxyImpl spaceProxy, SpaceTask task, Object routing, Transaction txn, AsyncFutureListener listener) throws RemoteException, TransactionException {
        txn = spaceProxy.beforeSpaceAction(txn);
        ExecuteTaskSpaceOperationRequest request = new ExecuteTaskSpaceOperationRequest(task, txn, routing);
        return spaceProxy.getProxyRouter().executeAsync(request, listener);
    }
}

