/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.client.spaceproxy.actions;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.async.AsyncFuture;
import com.gigaspaces.cluster.replication.TakeConsistencyLevelCompromisedException;
import com.gigaspaces.internal.client.spaceproxy.SpaceProxyImpl;
import com.gigaspaces.internal.client.spaceproxy.actioninfo.ReadTakeAsyncProxyActionInfo;
import com.gigaspaces.internal.client.spaceproxy.actioninfo.ReadTakeProxyActionInfo;
import com.gigaspaces.internal.client.spaceproxy.actions.ReadTakeProxyAction;
import com.gigaspaces.internal.client.spaceproxy.metadata.SpaceProxyTypeManager;
import com.gigaspaces.internal.client.spaceproxy.operations.ReadTakeEntrySpaceOperationRequest;
import com.gigaspaces.internal.client.spaceproxy.operations.ReadTakeEntrySpaceOperationResult;
import com.gigaspaces.internal.transport.IEntryPacket;
import java.rmi.RemoteException;
import net.jini.core.entry.UnusableEntryException;
import net.jini.core.transaction.TransactionException;

@InternalApi
public class SpaceProxyImplReadTakeAction
extends ReadTakeProxyAction<SpaceProxyImpl> {
    @Override
    public Object read(SpaceProxyImpl spaceProxy, ReadTakeProxyActionInfo actionInfo) throws RemoteException, UnusableEntryException, TransactionException, InterruptedException {
        return this.readTake(spaceProxy, actionInfo);
    }

    @Override
    public Object take(SpaceProxyImpl spaceProxy, ReadTakeProxyActionInfo actionInfo) throws RemoteException, UnusableEntryException, TransactionException, InterruptedException {
        return this.readTake(spaceProxy, actionInfo);
    }

    private Object readTake(SpaceProxyImpl spaceProxy, ReadTakeProxyActionInfo actionInfo) throws RemoteException, UnusableEntryException, TransactionException, InterruptedException {
        IEntryPacket result;
        spaceProxy.beforeSpaceAction(actionInfo);
        if (actionInfo.isSqlQuery) {
            result = spaceProxy.getQueryManager().readTake(actionInfo);
        } else {
            ReadTakeEntrySpaceOperationRequest request = new ReadTakeEntrySpaceOperationRequest(actionInfo.queryPacket, actionInfo.txn, actionInfo.isTake, actionInfo.ifExists, actionInfo.timeout, actionInfo.modifiers, actionInfo.returnOnlyUids, actionInfo.getQuery());
            spaceProxy.getProxyRouter().execute(request);
            result = request.getFinalResult();
            if (actionInfo.isTake && ((ReadTakeEntrySpaceOperationResult)request.getRemoteOperationResult()).getSyncReplicationLevel() + 1 < SpaceProxyTypeManager.requiredConsistencyLevel()) {
                throw new TakeConsistencyLevelCompromisedException(((ReadTakeEntrySpaceOperationResult)request.getRemoteOperationResult()).getSyncReplicationLevel() + 1, actionInfo.convertQueryResult(spaceProxy, result, null));
            }
        }
        return actionInfo.convertQueryResult(spaceProxy, result, null);
    }

    @Override
    public AsyncFuture<?> asyncRead(SpaceProxyImpl spaceProxy, ReadTakeAsyncProxyActionInfo actionInfo) throws RemoteException, UnusableEntryException, TransactionException, InterruptedException {
        return this.asyncReadTake(spaceProxy, actionInfo);
    }

    @Override
    public AsyncFuture<?> asyncTake(SpaceProxyImpl spaceProxy, ReadTakeAsyncProxyActionInfo actionInfo) throws RemoteException, UnusableEntryException, TransactionException, InterruptedException {
        return this.asyncReadTake(spaceProxy, actionInfo);
    }

    private AsyncFuture<?> asyncReadTake(SpaceProxyImpl spaceProxy, ReadTakeAsyncProxyActionInfo actionInfo) throws RemoteException, UnusableEntryException, TransactionException, InterruptedException {
        spaceProxy.beforeSpaceAction(actionInfo);
        ReadTakeEntrySpaceOperationRequest request = new ReadTakeEntrySpaceOperationRequest(actionInfo.queryPacket, actionInfo.txn, actionInfo.isTake, actionInfo.ifExists, actionInfo.timeout, actionInfo.modifiers, actionInfo.returnOnlyUids, spaceProxy.getTypeManager(), actionInfo.isReturnPacket(), actionInfo.getQuery());
        return spaceProxy.getProxyRouter().executeAsync(request, actionInfo.listener);
    }
}

