/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.client.spaceproxy.actions;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.client.ReadMultipleException;
import com.gigaspaces.client.TakeMultipleException;
import com.gigaspaces.internal.client.spaceproxy.SpaceProxyImpl;
import com.gigaspaces.internal.client.spaceproxy.actioninfo.ReadTakeMultipleProxyActionInfo;
import com.gigaspaces.internal.client.spaceproxy.actions.ReadTakeMultipleProxyAction;
import com.gigaspaces.internal.client.spaceproxy.operations.ReadTakeEntriesSpaceOperationRequest;
import com.gigaspaces.internal.client.spaceproxy.operations.ReadTakeEntriesSpaceOperationResult;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.j_spaces.core.client.ReadModifiers;
import java.rmi.RemoteException;
import net.jini.core.entry.UnusableEntryException;
import net.jini.core.transaction.TransactionException;

@InternalApi
public class SpaceProxyImplReadTakeMultipleAction
extends ReadTakeMultipleProxyAction<SpaceProxyImpl> {
    @Override
    public Object[] readMultiple(SpaceProxyImpl spaceProxy, ReadTakeMultipleProxyActionInfo actionInfo) throws RemoteException, TransactionException, UnusableEntryException {
        Object[] results = null;
        try {
            results = actionInfo.convertQueryResults(spaceProxy, this.newReadTakeMultiple(spaceProxy, actionInfo), null);
        }
        catch (ReadMultipleException ex) {
            throw actionInfo.convertExceptionResults(spaceProxy, ex, null);
        }
        catch (Exception ex) {
            if (ReadModifiers.isThrowPartialFailure(actionInfo.modifiers)) {
                throw new ReadMultipleException(ex);
            }
            this.rethrowException(ex);
        }
        return results;
    }

    @Override
    public Object[] takeMultiple(SpaceProxyImpl spaceProxy, ReadTakeMultipleProxyActionInfo actionInfo) throws RemoteException, TransactionException, UnusableEntryException {
        Object[] results = null;
        try {
            results = actionInfo.convertQueryResults(spaceProxy, this.newReadTakeMultiple(spaceProxy, actionInfo), null);
        }
        catch (TakeMultipleException ex) {
            throw actionInfo.convertExceptionResults(spaceProxy, ex, null);
        }
        catch (Exception ex) {
            if (ReadModifiers.isThrowPartialFailure(actionInfo.modifiers)) {
                throw new TakeMultipleException(ex);
            }
            this.rethrowException(ex);
        }
        return results;
    }

    private IEntryPacket[] newReadTakeMultiple(SpaceProxyImpl spaceProxy, ReadTakeMultipleProxyActionInfo actionInfo) throws InterruptedException, RemoteException, TransactionException, UnusableEntryException {
        if (actionInfo.returnOnlyUids) {
            throw new IllegalArgumentException("returnOnlyUids=true is not supported in new router read/takeMultiple operation");
        }
        spaceProxy.beforeSpaceAction(actionInfo);
        if (actionInfo.maxResults < 1) {
            return new IEntryPacket[0];
        }
        if (actionInfo.isSqlQuery) {
            return spaceProxy.getQueryManager().readTakeMultiple(actionInfo);
        }
        ReadTakeEntriesSpaceOperationRequest request = new ReadTakeEntriesSpaceOperationRequest(actionInfo.queryPacket, actionInfo.txn, actionInfo.isTake, actionInfo.modifiers, actionInfo.maxResults, actionInfo.minEntriesToWaitFor, actionInfo.timeout, actionInfo.ifExist, actionInfo.getQuery());
        spaceProxy.getProxyRouter().execute(request);
        if (actionInfo.isTake && request.getRemoteOperationResult() != null) {
            actionInfo.setSyncReplicationLevel(((ReadTakeEntriesSpaceOperationResult)request.getRemoteOperationResult()).getSyncReplicationLevel());
        } else if (actionInfo.isTake && request.getLevels() != null) {
            actionInfo.setSyncReplicationLevels(request.getLevels());
        }
        return request.getFinalResult();
    }
}

