/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.client.spaceproxy.actions;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.client.spaceproxy.SpaceProxyImpl;
import com.gigaspaces.internal.client.spaceproxy.actioninfo.SnapshotProxyActionInfo;
import com.gigaspaces.internal.client.spaceproxy.actions.SnapshotProxyAction;
import com.gigaspaces.internal.client.spaceproxy.metadata.ObjectType;
import com.gigaspaces.internal.server.space.IRemoteSpace;
import com.gigaspaces.internal.transport.ITemplatePacket;
import com.gigaspaces.internal.utils.PropertiesUtils;
import com.gigaspaces.query.ISpaceQuery;
import com.gigaspaces.time.SystemTime;
import com.j_spaces.core.client.EntrySnapshot;
import com.j_spaces.jdbc.builder.SQLQueryTemplatePacket;
import java.rmi.RemoteException;
import java.util.Properties;
import net.jini.core.entry.UnusableEntryException;
import net.jini.space.InternalSpaceException;

@InternalApi
public class SpaceProxyImplSnapshotAction
extends SnapshotProxyAction<SpaceProxyImpl> {
    @Override
    public <T> ISpaceQuery<T> snapshot(SpaceProxyImpl spaceProxy, SnapshotProxyActionInfo actionInfo) throws RemoteException, UnusableEntryException {
        long lookupTimeout = this.getLookupTimeout(spaceProxy);
        long timeToEnd = SystemTime.timeMillis() + lookupTimeout;
        IRemoteSpace rj = spaceProxy.getRemoteJSpace();
        while (true) {
            try {
                ITemplatePacket queryPacket = actionInfo.queryPacket;
                if (actionInfo.isSqlQuery) {
                    queryPacket = spaceProxy.getQueryManager().getSQLTemplate((SQLQueryTemplatePacket)actionInfo.queryPacket, null);
                    queryPacket = spaceProxy.getTypeManager().getTemplatePacketFromObject(queryPacket, ObjectType.TEMPLATE_PACKET);
                    queryPacket.setSerializeTypeDesc(true);
                }
                if (queryPacket == null) {
                    throw new IllegalArgumentException("Cannot accept null Entry/Template.");
                }
                spaceProxy.beforeSpaceAction();
                try {
                    rj.snapshot(queryPacket);
                    queryPacket.setSerializeTypeDesc(false);
                    return new EntrySnapshot(queryPacket);
                }
                catch (UnusableEntryException ex) {
                    throw new InternalSpaceException(ex.toString(), ex);
                }
            }
            catch (RemoteException ex) {
                if (SystemTime.timeMillis() < timeToEnd && (rj = spaceProxy.getProxyRouter().getAnyAvailableSpace()) != null) continue;
                throw new RemoteException("Can not locate an available space...");
            }
            break;
        }
    }

    private long getLookupTimeout(SpaceProxyImpl spaceProxy) {
        Properties properties = spaceProxy.getProxySettings().getCustomProperties();
        return PropertiesUtils.getLong(properties, "space-config.proxy.router.active-server-lookup-timeout", 20000L);
    }
}

