/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.client.spaceproxy.events;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.async.AsyncFutureListener;
import com.gigaspaces.async.AsyncResult;
import com.gigaspaces.events.lease.EventLeaseRenewalManager;
import com.gigaspaces.internal.client.spaceproxy.SpaceProxyImpl;
import com.gigaspaces.internal.lease.LeaseUpdateBatch;
import com.gigaspaces.internal.lease.LeaseUpdateDetails;
import com.gigaspaces.internal.lease.LeaseUtils;
import com.gigaspaces.internal.lease.SpaceLease;
import com.gigaspaces.internal.lease.SpaceNotifyLease;
import com.gigaspaces.internal.utils.PropertiesUtils;
import com.gigaspaces.internal.utils.concurrent.AsyncCallable;
import com.gigaspaces.internal.utils.concurrent.IAsyncHandlerProvider;
import com.gigaspaces.time.SystemTime;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.event.EventRegistration;
import net.jini.core.lease.Lease;
import net.jini.core.lease.UnknownLeaseException;
import net.jini.lease.LeaseListener;
import net.jini.lease.LeaseRenewalEvent;

@InternalApi
public class BatchLeaseRenewalManager
implements EventLeaseRenewalManager {
    private final SpaceProxyImpl _spaceProxy;
    private final Logger _logger;
    private final long _renewDuration;
    private final long _renewInterval;
    private final Object _lock;
    private final Map<SpaceLease, LeaseListener> _leases;
    private final BatchLeaseRenewalTask _renewalTask;
    private LeaseUpdateBatch _batch;

    public BatchLeaseRenewalManager(SpaceProxyImpl spaceProxy, Logger logger) {
        this._spaceProxy = spaceProxy;
        this._logger = logger;
        Properties properties = spaceProxy.getProxySettings().getCustomProperties();
        this._renewDuration = PropertiesUtils.getLong(properties, "space-config.proxy.events.registration-duration", 30000L);
        this._renewInterval = PropertiesUtils.getLong(properties, "space-config.proxy.events.registration-renew-interval", 10000L);
        this._lock = new Object();
        this._renewalTask = new BatchLeaseRenewalTask();
        this._leases = new ConcurrentHashMap<SpaceLease, LeaseListener>();
        if (this._logger.isLoggable(Level.CONFIG)) {
            this._logger.log(Level.CONFIG, "BatchLeaseRenewalManager initialized (renewDuration=" + this._renewDuration + ", renewInterval=" + this._renewInterval + ")");
        }
        if (this._renewInterval > this._renewDuration) {
            throw new IllegalStateException("Renew interval (" + this._renewInterval + ") cannot exceed renew duration (" + this._renewDuration + ")");
        }
    }

    @Override
    public boolean supportsCustomLease() {
        return false;
    }

    @Override
    public long getRenewalDuration() {
        return this._renewDuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerAutoRenew(EventRegistration eventRegistration, LeaseListener listener) {
        Object object = this._lock;
        synchronized (object) {
            if (this._logger.isLoggable(Level.FINEST)) {
                this._logger.log(Level.FINEST, "lease has been registered for auto-renewal");
            }
            this._leases.put((SpaceNotifyLease)eventRegistration.getLease(), listener);
            this._batch = null;
            if (this._leases.size() == 1) {
                this._spaceProxy.getProxyRouter().getAsyncHandlerProvider().start(this._renewalTask, this._renewInterval, "BatchLeaseRenewalTask", true);
            }
        }
    }

    @Override
    public void unregisterAutoRenew(EventRegistration eventRegistration) {
        this.unregisterAutoRenew(eventRegistration.getLease());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterAutoRenew(Lease lease) {
        Object object = this._lock;
        synchronized (object) {
            this._leases.remove(lease);
            this._batch = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this._lock;
        synchronized (object) {
            this._leases.clear();
            this._batch = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LeaseUpdateBatch getBatch() {
        Object object = this._lock;
        synchronized (object) {
            if (this._batch == null && this._leases.size() > 0) {
                SpaceLease[] leases = new SpaceLease[this._leases.size()];
                LeaseUpdateDetails[] leasesUpdateDetails = new LeaseUpdateDetails[this._leases.size()];
                int index = 0;
                Iterator<SpaceLease> iterator = this._leases.keySet().iterator();
                while (iterator.hasNext()) {
                    SpaceLease lease;
                    leases[index] = lease = iterator.next();
                    leasesUpdateDetails[index] = new LeaseUpdateDetails(lease, this._renewDuration);
                    ++index;
                }
                this._batch = new LeaseUpdateBatch(leases, leasesUpdateDetails, true);
                if (this._logger.isLoggable(Level.FINEST)) {
                    this._logger.log(Level.FINEST, "Cached lease batch was modified - now contains " + this._batch.getSize() + " leases.");
                }
            }
            return this._batch;
        }
    }

    private class BatchLeaseRenewalTask
    extends AsyncCallable {
        private BatchLeaseRenewalTask() {
        }

        @Override
        public IAsyncHandlerProvider.CycleResult call() throws Exception {
            LeaseUpdateBatch batch = BatchLeaseRenewalManager.this.getBatch();
            if (batch == null) {
                if (BatchLeaseRenewalManager.this._logger.isLoggable(Level.FINEST)) {
                    BatchLeaseRenewalManager.this._logger.log(Level.FINEST, "No leases to renew.");
                }
                return IAsyncHandlerProvider.CycleResult.TERMINATE;
            }
            final long newExpiration = LeaseUtils.safeAdd(SystemTime.timeMillis(), BatchLeaseRenewalManager.this._renewDuration);
            AsyncFutureListener<Map<SpaceLease, Throwable>> listener = new AsyncFutureListener<Map<SpaceLease, Throwable>>(){

                @Override
                public void onResult(AsyncResult<Map<SpaceLease, Throwable>> result) {
                    Map<SpaceLease, Throwable> errorsMap = result.getResult();
                    if (BatchLeaseRenewalManager.this._logger.isLoggable(Level.FINEST)) {
                        BatchLeaseRenewalManager.this._logger.log(Level.FINEST, "Async batch lease renewal completed - " + (errorsMap == null ? 0 : errorsMap.size()) + " errors");
                    }
                    if (errorsMap != null) {
                        for (Map.Entry<SpaceLease, Throwable> entry : errorsMap.entrySet()) {
                            SpaceLease lease = entry.getKey();
                            LeaseListener leaseListener = (LeaseListener)BatchLeaseRenewalManager.this._leases.get(lease);
                            if (leaseListener == null) continue;
                            Throwable error = entry.getValue();
                            if (error instanceof UnknownLeaseException) {
                                BatchLeaseRenewalManager.this.unregisterAutoRenew(lease);
                            }
                            leaseListener.notify(new LeaseRenewalEvent(this, lease, newExpiration, error));
                        }
                    }
                }
            };
            if (BatchLeaseRenewalManager.this._logger.isLoggable(Level.FINEST)) {
                BatchLeaseRenewalManager.this._logger.log(Level.FINEST, "Executing async batch renewal of " + batch.getSize() + " registrations...");
            }
            LeaseUtils.updateBatchAsync(BatchLeaseRenewalManager.this._spaceProxy, batch, listener);
            return IAsyncHandlerProvider.CycleResult.IDLE_CONTINUE;
        }
    }
}

