/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.client.spaceproxy.events;

import com.gigaspaces.events.GSEventRegistration;
import com.gigaspaces.events.ManagedRemoteEventListener;
import com.gigaspaces.events.batching.BatchRemoteEvent;
import com.gigaspaces.events.batching.BatchRemoteEventListener;
import com.gigaspaces.internal.utils.concurrent.ContextClassLoaderCallable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.event.RemoteEvent;
import net.jini.core.event.RemoteEventListener;
import net.jini.core.event.UnknownEventException;

public abstract class DataEventListener
implements ManagedRemoteEventListener,
BatchRemoteEventListener {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.client");
    protected final RemoteEventListener _listener;
    protected final BatchRemoteEventListener _batchListener;
    protected final ExecutorService _threadPool;

    public DataEventListener(RemoteEventListener listener, ExecutorService threadPool) {
        this._listener = listener;
        this._batchListener = listener instanceof BatchRemoteEventListener ? (BatchRemoteEventListener)listener : null;
        this._threadPool = threadPool;
    }

    @Override
    public void init(GSEventRegistration registration) {
        if (this._listener instanceof ManagedRemoteEventListener) {
            ((ManagedRemoteEventListener)this._listener).init(registration);
        }
    }

    @Override
    public void shutdown(GSEventRegistration registration) {
        if (this._listener instanceof ManagedRemoteEventListener) {
            ((ManagedRemoteEventListener)this._listener).shutdown(registration);
        }
    }

    public void notify(RemoteEvent event) throws UnknownEventException, RemoteException {
        this._listener.notify(event);
    }

    @Override
    public void notifyBatch(BatchRemoteEvent batchEvent) throws UnknownEventException, RemoteException {
        if (this._batchListener != null) {
            this._batchListener.notifyBatch(batchEvent);
        } else {
            this.dispatchRemoteEventsConcurrently(batchEvent.getEvents());
        }
    }

    private void dispatchRemoteEventsConcurrently(RemoteEvent[] events) throws UnknownEventException, RemoteException {
        ArrayList<Future<Object>> results = new ArrayList<Future<Object>>();
        for (RemoteEvent event : events) {
            Future<Object> future = this._threadPool.submit(new BatchNotifyTask(this._listener, event));
            results.add(future);
        }
        for (Future future : results) {
            try {
                future.get();
            }
            catch (InterruptedException e) {
                _logger.log(Level.FINE, "caught exception during event delivery", e);
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof UnknownEventException) {
                    throw (UnknownEventException)cause;
                }
                if (cause instanceof RemoteException) {
                    throw (RemoteException)cause;
                }
                _logger.log(Level.FINE, "caught exception during event delivery", e);
            }
        }
    }

    private static class BatchNotifyTask
    extends ContextClassLoaderCallable<Object> {
        private final RemoteEventListener listener;
        private final RemoteEvent event;

        private BatchNotifyTask(RemoteEventListener listener, RemoteEvent event) {
            this.listener = listener;
            this.event = event;
        }

        @Override
        protected Object execute() throws Exception {
            this.listener.notify(this.event);
            return null;
        }
    }
}

