/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.client.spaceproxy.events;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.events.GSEventRegistration;
import com.gigaspaces.events.NotifyInfo;
import com.gigaspaces.events.batching.BatchRemoteEvent;
import com.gigaspaces.events.fifo.BlockedOrderedQueue;
import com.gigaspaces.internal.client.spaceproxy.events.DataEventListener;
import java.rmi.RemoteException;
import java.util.concurrent.ExecutorService;
import net.jini.core.event.RemoteEvent;
import net.jini.core.event.RemoteEventListener;
import net.jini.core.event.UnknownEventException;

@InternalApi
public class FifoDataEventListener
extends DataEventListener {
    private static final int _queueSize = Integer.getInteger("com.gs.fifo_notify.queue", Integer.MAX_VALUE);
    private final BlockedOrderedQueue _fifoQueue;

    public FifoDataEventListener(RemoteEventListener listener, ExecutorService threadPool, NotifyInfo info) {
        super(listener, threadPool);
        this._fifoQueue = new BlockedOrderedQueue(listener, threadPool, _queueSize, info);
    }

    @Override
    public void notify(RemoteEvent event) throws UnknownEventException, RemoteException {
        this._fifoQueue.enqueue(event);
    }

    @Override
    public void notifyBatch(BatchRemoteEvent batchEvent) throws UnknownEventException, RemoteException {
        for (RemoteEvent event : batchEvent.getEvents()) {
            this._fifoQueue.enqueue(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(GSEventRegistration registration) {
        super.init(registration);
        FifoDataEventListener fifoDataEventListener = this;
        synchronized (fifoDataEventListener) {
            this._fifoQueue.setInitialSeqNumbers(registration.getSequenceNumbers());
        }
    }

    @Override
    public void shutdown(GSEventRegistration registration) {
        this._fifoQueue.interrupt();
        super.shutdown(registration);
    }
}

